/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity.mana;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.BasicLensItem;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.ManaTrigger;
import vazkii.botania.api.mana.TinyPlanetExcempt;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.ExposedSimpleInventoryBlockEntity;

public class ManaPrismBlockEntity
extends ExposedSimpleInventoryBlockEntity
implements ManaTrigger {
    public ManaPrismBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.PRISM, pos, state);
    }

    @Override
    public void onBurstCollision(ManaBurst burst) {
        TinyPlanetExcempt excempt;
        Item item;
        boolean valid;
        ItemStack lens = this.getItemHandler().getItem(0);
        boolean active = (Boolean)this.getBlockState().getValue((Property)BlockStateProperties.POWERED) == false;
        boolean bl = valid = !lens.isEmpty() && lens.getItem() instanceof BasicLensItem && (!((item = lens.getItem()) instanceof TinyPlanetExcempt) || (excempt = (TinyPlanetExcempt)item).shouldPull(lens));
        if (active) {
            burst.setSourceLens(valid ? lens.copy() : ItemStack.EMPTY);
            burst.setColor(0xFFFFFF);
            burst.setGravity(0.0f);
            if (valid) {
                ThrowableProjectile burstEntity = burst.entity();
                BurstProperties properties = new BurstProperties(burst.getStartingMana(), burst.getMinManaLoss(), burst.getManaLossPerTick(), burst.getBurstGravity(), 1.0f, burst.getColor());
                ((BasicLensItem)lens.getItem()).apply(lens, properties, this.level);
                burst.setColor(properties.color);
                burst.setStartingMana(properties.maxMana);
                burst.setMinManaLoss(properties.ticksBeforeManaLoss);
                burst.setManaLossPerTick(properties.manaLossPerTick);
                burst.setGravity(properties.gravity);
                burstEntity.setDeltaMovement(burstEntity.getDeltaMovement().scale((double)properties.motionModifier));
            }
        }
    }

    @Override
    protected SimpleContainer createItemHandler() {
        return new SimpleContainer(1){

            public boolean canPlaceItem(int index, ItemStack stack) {
                return !stack.isEmpty() && stack.getItem() instanceof BasicLensItem;
            }

            public int getMaxStackSize() {
                return 1;
            }
        };
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            boolean hasLens;
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
            BlockState state = this.getBlockState();
            boolean bl = hasLens = !this.getItemHandler().getItem(0).isEmpty();
            if (!state.is(BotaniaBlocks.prism) || (Boolean)state.getValue((Property)BotaniaStateProperties.HAS_LENS) != hasLens) {
                BlockState base = state.is(BotaniaBlocks.prism) ? state : BotaniaBlocks.prism.defaultBlockState();
                this.level.setBlockAndUpdate(this.worldPosition, (BlockState)base.setValue((Property)BotaniaStateProperties.HAS_LENS, (Comparable)Boolean.valueOf(hasLens)));
            }
        }
    }

    public static class WandHud
    implements WandHUD {
        private final ManaPrismBlockEntity prism;

        public WandHud(ManaPrismBlockEntity prism) {
            this.prism = prism;
        }

        @Override
        public void renderHUD(GuiGraphics gui, Minecraft mc) {
            ItemStack lens = this.prism.getItem(0);
            if (!lens.isEmpty()) {
                Component lensName = lens.getHoverName();
                int halfWidth = (mc.font.width((FormattedText)lensName) + 24) / 2;
                int centerX = mc.getWindow().getGuiScaledWidth() / 2;
                int centerY = mc.getWindow().getGuiScaledHeight() / 2;
                RenderHelper.renderHUDBox(gui, centerX - halfWidth, centerY + 8, centerX + halfWidth, centerY + 28);
                gui.drawString(mc.font, lensName, centerX - halfWidth + 22, centerY + 14, 0xFFFFFF);
                gui.renderFakeItem(lens, centerX - halfWidth + 2, centerY + 10);
            }
        }
    }
}

