/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;
import vazkii.botania.common.block.decor.FloatingFlowerBlock;

public class FloatingSpecialFlowerBlock
extends FloatingFlowerBlock {
    private final Supplier<BlockEntityType<? extends SpecialFlowerBlockEntity>> blockEntityType;
    private final boolean hasComparatorOutput;

    public FloatingSpecialFlowerBlock(BlockBehaviour.Properties props, Supplier<BlockEntityType<? extends SpecialFlowerBlockEntity>> blockEntityType) {
        this(props, blockEntityType, false);
    }

    public FloatingSpecialFlowerBlock(BlockBehaviour.Properties props, Supplier<BlockEntityType<? extends SpecialFlowerBlockEntity>> blockEntityType, boolean hasComparatorOutput) {
        super(DyeColor.WHITE, props);
        this.blockEntityType = blockEntityType;
        this.hasComparatorOutput = hasComparatorOutput;
    }

    @Override
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        FloatingSpecialFlowerBlock.redstoneParticlesIfPowered(state, world, pos, rand);
    }

    public static void redstoneParticlesIfPowered(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof FunctionalFlowerBlockEntity) {
            VoxelShape shape;
            FunctionalFlowerBlockEntity flower = (FunctionalFlowerBlockEntity)te;
            if (rand.nextBoolean() && flower.acceptsRedstone() && flower.redstoneSignal > 0 && !(shape = state.getShape((BlockGetter)world, pos)).isEmpty()) {
                AABB localBox = shape.bounds();
                double x = (double)pos.getX() + localBox.minX + rand.nextDouble() * (localBox.maxX - localBox.minX);
                double y = (double)pos.getY() + localBox.minY + rand.nextDouble() * (localBox.maxY - localBox.minY);
                double z = (double)pos.getZ() + localBox.minZ + rand.nextDouble() * (localBox.maxZ - localBox.minZ);
                world.addParticle((ParticleOptions)DustParticleOptions.REDSTONE, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        ((SpecialFlowerBlockEntity)world.getBlockEntity(pos)).setPlacedBy(world, pos, state, entity, stack);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (this.hasComparatorOutput && !newState.hasAnalogOutputSignal()) {
            level.updateNeighbourForOutputSignal(pos, newState.getBlock());
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    @Override
    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        SpecialFlowerBlockEntity te = (SpecialFlowerBlockEntity)this.blockEntityType.get().create(pos, state);
        te.setFloating(true);
        return te;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> type) {
        return FloatingSpecialFlowerBlock.createTickerHelper(type, this.blockEntityType.get(), SpecialFlowerBlockEntity::commonTick);
    }

    public boolean hasAnalogOutputSignal(BlockState bs) {
        return this.hasComparatorOutput;
    }

    public int getAnalogOutputSignal(BlockState bs, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SpecialFlowerBlockEntity) {
            SpecialFlowerBlockEntity flower = (SpecialFlowerBlockEntity)blockEntity;
            return flower.getComparatorSignal();
        }
        return 0;
    }
}

