/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.crafting.recipe.NoOpRecipeSerializer;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BotaniaItems;

public class ResoluteIvyRecipe
extends CustomRecipe {
    public static final NoOpRecipeSerializer<ResoluteIvyRecipe> SERIALIZER = new NoOpRecipeSerializer<ResoluteIvyRecipe>(ResoluteIvyRecipe::new);

    public ResoluteIvyRecipe(ResourceLocation id) {
        super(id, CraftingBookCategory.EQUIPMENT);
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level world) {
        boolean foundIvy = false;
        boolean foundItem = false;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.is(BotaniaItems.keepIvy) && !foundIvy) {
                foundIvy = true;
                continue;
            }
            if (!(foundItem || stack.hasTag() && ItemNBTHelper.getBoolean(stack, "Botania_keepIvy", false) || stack.getItem().hasCraftingRemainingItem())) {
                foundItem = true;
                continue;
            }
            return false;
        }
        return foundIvy && foundItem;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess registries) {
        ItemStack item = ItemStack.EMPTY;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || stack.is(BotaniaItems.keepIvy)) continue;
            item = stack;
        }
        ItemStack copy = item.copyWithCount(1);
        ItemNBTHelper.setBoolean(copy, "Botania_keepIvy", true);
        return copy;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }
}

