/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity.mana;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;
import vazkii.botania.common.block.block_entity.mana.ManaPoolBlockEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.handler.ExoflameFurnaceHandler;
import vazkii.botania.mixin.AbstractFurnaceBlockEntityAccessor;

public class BellowsBlockEntity
extends BotaniaBlockEntity {
    private static final String TAG_ACTIVE = "active";
    public float movePos;
    public boolean active = false;
    public float moving = 0.0f;

    public BellowsBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.BELLOWS, pos, state);
    }

    public void interact() {
        if (this.moving == 0.0f) {
            this.setActive(true);
        }
    }

    public static void commonTick(Level level, BlockPos worldPosition, BlockState state, BellowsBlockEntity self) {
        boolean disable = true;
        BlockEntity tile = self.getLinkedTile();
        if (!self.active && tile instanceof ManaPoolBlockEntity) {
            ManaPoolBlockEntity pool = (ManaPoolBlockEntity)tile;
            boolean transfer = pool.isDoingTransfer;
            if (transfer) {
                if (pool.ticksDoingTransfer > 0) {
                    self.setActive(true);
                }
                disable = false;
            }
        }
        float max = 0.9f;
        float min = 0.0f;
        float incr = max / 20.0f;
        if (self.movePos < max && self.active && self.moving >= 0.0f) {
            if (self.moving == 0.0f) {
                if (!level.isClientSide()) {
                    level.gameEvent(null, GameEvent.BLOCK_ACTIVATE, worldPosition);
                }
                level.playSound(null, worldPosition, BotaniaSounds.bellows, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (tile instanceof AbstractFurnaceBlockEntity) {
                AbstractFurnaceBlockEntity furnace = (AbstractFurnaceBlockEntity)tile;
                if (ExoflameFurnaceHandler.canSmelt(furnace)) {
                    AbstractFurnaceBlockEntityAccessor mFurnace = (AbstractFurnaceBlockEntityAccessor)furnace;
                    mFurnace.setCookingProgress(Math.min(mFurnace.getCookingTotalTime() - 1, mFurnace.getCookingProgress() + 20));
                    mFurnace.setLitTime(Math.max(0, mFurnace.getLitTime() - 10));
                }
                if (furnace instanceof FurnaceBlockEntity && furnace.hasLevel() && ((Boolean)furnace.getBlockState().getValue((Property)FurnaceBlock.LIT)).booleanValue()) {
                    double d0 = (double)worldPosition.getX() + 0.5;
                    double d1 = worldPosition.getY();
                    double d2 = (double)worldPosition.getZ() + 0.5;
                    Direction enumfacing = (Direction)furnace.getBlockState().getValue((Property)FurnaceBlock.FACING);
                    Direction.Axis enumfacing$axis = enumfacing.getAxis();
                    double d3 = 0.52;
                    double d4 = level.random.nextDouble() * 0.6 - 0.3;
                    double d5 = enumfacing$axis == Direction.Axis.X ? (double)enumfacing.getStepX() * 0.52 : d4;
                    double d6 = level.random.nextDouble() * 6.0 / 16.0;
                    double d7 = enumfacing$axis == Direction.Axis.Z ? (double)enumfacing.getStepZ() * 0.52 : d4;
                    level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
                    level.addParticle((ParticleOptions)ParticleTypes.FLAME, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
                }
            }
            self.movePos += incr * 3.0f;
            self.moving = incr * 3.0f;
            if (self.movePos >= max) {
                self.movePos = Math.min(max, self.movePos);
                self.moving = 0.0f;
                if (disable) {
                    self.setActive(false);
                }
            }
        } else if (self.movePos > min) {
            self.movePos -= incr;
            self.moving = -incr;
            if (self.movePos <= min) {
                self.movePos = Math.max(min, self.movePos);
                self.moving = 0.0f;
            }
        }
    }

    public BlockEntity getLinkedTile() {
        Direction side = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        return this.level.getBlockEntity(this.getBlockPos().relative(side));
    }

    @Override
    public void writePacketNBT(CompoundTag cmp) {
        cmp.putBoolean(TAG_ACTIVE, this.active);
    }

    @Override
    public void readPacketNBT(CompoundTag cmp) {
        this.active = cmp.getBoolean(TAG_ACTIVE);
    }

    public void setActive(boolean active) {
        if (!this.level.isClientSide) {
            boolean diff = this.active != active;
            this.active = active;
            if (diff) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
            }
        }
    }
}

