/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.entity.GaiaGuardianEntity;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class GaiaGuardianNoArmorTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final ResourceLocation ID = ResourceLocationHelper.prefix("gaia_guardian_no_armor");
    public static final GaiaGuardianNoArmorTrigger INSTANCE = new GaiaGuardianNoArmorTrigger();

    private GaiaGuardianNoArmorTrigger() {
    }

    @NotNull
    public ResourceLocation getId() {
        return ID;
    }

    @NotNull
    public Instance createInstance(@NotNull JsonObject json, ContextAwarePredicate playerPred, DeserializationContext conditions) {
        return new Instance(playerPred, EntityPredicate.fromJson((JsonElement)json.get("guardian")), DamageSourcePredicate.fromJson((JsonElement)json.get("killing_blow")));
    }

    public void trigger(ServerPlayer player, GaiaGuardianEntity guardian, DamageSource src) {
        this.trigger(player, instance -> instance.test(player, guardian, src));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final EntityPredicate guardian;
        private final DamageSourcePredicate killingBlow;

        public Instance(ContextAwarePredicate playerPred, EntityPredicate count, DamageSourcePredicate indexPos) {
            super(ID, playerPred);
            this.guardian = count;
            this.killingBlow = indexPos;
        }

        @NotNull
        public ResourceLocation getCriterion() {
            return ID;
        }

        boolean test(ServerPlayer player, GaiaGuardianEntity guardian, DamageSource src) {
            return this.guardian.matches(player, (Entity)guardian) && this.killingBlow.matches(player, src);
        }

        public JsonObject serializeToJson(SerializationContext context) {
            JsonObject json = super.serializeToJson(context);
            if (this.guardian != EntityPredicate.ANY) {
                json.add("guardian", this.guardian.serializeToJson());
            }
            if (this.killingBlow != DamageSourcePredicate.ANY) {
                json.add("killing_blow", this.killingBlow.serializeToJson());
            }
            return json;
        }

        public EntityPredicate getGuardian() {
            return this.guardian;
        }

        public DamageSourcePredicate getKillingBlow() {
            return this.killingBlow;
        }
    }
}

