/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.forge.network;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.network.TriConsumer;
import vazkii.botania.network.clientbound.AvatarSkiesRodPacket;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.network.clientbound.GogWorldPacket;
import vazkii.botania.network.clientbound.ItemAgePacket;
import vazkii.botania.network.clientbound.SpawnGaiaGuardianPacket;
import vazkii.botania.network.clientbound.UpdateItemsRemainingPacket;
import vazkii.botania.network.serverbound.DodgePacket;
import vazkii.botania.network.serverbound.IndexKeybindRequestPacket;
import vazkii.botania.network.serverbound.IndexStringRequestPacket;
import vazkii.botania.network.serverbound.JumpPacket;
import vazkii.botania.network.serverbound.LeftClickPacket;

public class ForgePacketHandler {
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)ResourceLocationHelper.prefix("main"), () -> "0", "0"::equals, "0"::equals);

    public static void init() {
        int i = 0;
        CHANNEL.registerMessage(i++, DodgePacket.class, DodgePacket::encode, DodgePacket::decode, ForgePacketHandler.makeServerBoundHandler(DodgePacket::handle));
        CHANNEL.registerMessage(i++, IndexKeybindRequestPacket.class, IndexKeybindRequestPacket::encode, IndexKeybindRequestPacket::decode, ForgePacketHandler.makeServerBoundHandler(IndexKeybindRequestPacket::handle));
        CHANNEL.registerMessage(i++, IndexStringRequestPacket.class, IndexStringRequestPacket::encode, IndexStringRequestPacket::decode, ForgePacketHandler.makeServerBoundHandler(IndexStringRequestPacket::handle));
        CHANNEL.registerMessage(i++, JumpPacket.class, JumpPacket::encode, JumpPacket::decode, ForgePacketHandler.makeServerBoundHandler(JumpPacket::handle));
        CHANNEL.registerMessage(i++, LeftClickPacket.class, LeftClickPacket::encode, LeftClickPacket::decode, ForgePacketHandler.makeServerBoundHandler(LeftClickPacket::handle));
        CHANNEL.registerMessage(i++, AvatarSkiesRodPacket.class, AvatarSkiesRodPacket::encode, AvatarSkiesRodPacket::decode, ForgePacketHandler.makeClientBoundHandler(AvatarSkiesRodPacket.Handler::handle));
        CHANNEL.registerMessage(i++, BotaniaEffectPacket.class, BotaniaEffectPacket::encode, BotaniaEffectPacket::decode, ForgePacketHandler.makeClientBoundHandler(BotaniaEffectPacket.Handler::handle));
        CHANNEL.registerMessage(i++, GogWorldPacket.class, GogWorldPacket::encode, GogWorldPacket::decode, ForgePacketHandler.makeClientBoundHandler(GogWorldPacket.Handler::handle));
        CHANNEL.registerMessage(i++, ItemAgePacket.class, ItemAgePacket::encode, ItemAgePacket::decode, ForgePacketHandler.makeClientBoundHandler(ItemAgePacket.Handler::handle));
        CHANNEL.registerMessage(i++, SpawnGaiaGuardianPacket.class, SpawnGaiaGuardianPacket::encode, SpawnGaiaGuardianPacket::decode, ForgePacketHandler.makeClientBoundHandler(SpawnGaiaGuardianPacket.Handler::handle));
        CHANNEL.registerMessage(i++, UpdateItemsRemainingPacket.class, UpdateItemsRemainingPacket::encode, UpdateItemsRemainingPacket::decode, ForgePacketHandler.makeClientBoundHandler(UpdateItemsRemainingPacket.Handler::handle));
    }

    private static <T> BiConsumer<T, Supplier<NetworkEvent.Context>> makeServerBoundHandler(TriConsumer<T, MinecraftServer, ServerPlayer> handler) {
        return (m, ctx) -> {
            handler.accept(m, ((NetworkEvent.Context)ctx.get()).getSender().getServer(), ((NetworkEvent.Context)ctx.get()).getSender());
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        };
    }

    private static <T> BiConsumer<T, Supplier<NetworkEvent.Context>> makeClientBoundHandler(Consumer<T> consumer) {
        return (m, ctx) -> {
            consumer.accept(m);
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        };
    }
}

