/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import java.util.Optional;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import vazkii.botania.api.mana.ManaBarTooltip;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.CustomCreativeTabContents;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;
import vazkii.botania.xplat.XplatAbstractions;

public class BandOfManaItem
extends BaubleItem
implements CustomCreativeTabContents {
    protected static final int MAX_MANA = 500000;
    private static final String TAG_MANA = "mana";

    public BandOfManaItem(Item.Properties props) {
        super(props);
    }

    @Override
    public void addToCreativeTab(Item me, CreativeModeTab.Output output) {
        output.accept((ItemLike)this);
        ItemStack full = new ItemStack((ItemLike)this);
        BandOfManaItem.setMana(full, 500000);
        output.accept(full);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.of(ManaBarTooltip.fromManaItem(stack));
    }

    protected static void setMana(ItemStack stack, int mana) {
        if (mana > 0) {
            ItemNBTHelper.setInt(stack, TAG_MANA, mana);
        } else {
            ItemNBTHelper.removeEntry(stack, TAG_MANA);
        }
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        ManaItem manaItem = XplatAbstractions.INSTANCE.findManaItem(stack);
        return Math.round(13.0f * ManaBarTooltip.getFractionForDisplay(manaItem));
    }

    public int getBarColor(ItemStack stack) {
        ManaItem manaItem = XplatAbstractions.INSTANCE.findManaItem(stack);
        return Mth.hsvToRgb((float)(ManaBarTooltip.getFractionForDisplay(manaItem) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public static class ManaItemImpl
    implements ManaItem {
        protected final ItemStack stack;

        public ManaItemImpl(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public int getMana() {
            return ItemNBTHelper.getInt(this.stack, BandOfManaItem.TAG_MANA, 0) * this.stack.getCount();
        }

        @Override
        public int getMaxMana() {
            return 500000 * this.stack.getCount();
        }

        @Override
        public void addMana(int mana) {
            BandOfManaItem.setMana(this.stack, Math.min(this.getMana() + mana, this.getMaxMana()) / this.stack.getCount());
        }

        @Override
        public boolean canReceiveManaFromPool(BlockEntity pool) {
            return true;
        }

        @Override
        public boolean canReceiveManaFromItem(ItemStack otherStack) {
            return true;
        }

        @Override
        public boolean canExportManaToPool(BlockEntity pool) {
            return true;
        }

        @Override
        public boolean canExportManaToItem(ItemStack otherStack) {
            return true;
        }

        @Override
        public boolean isNoExport() {
            return false;
        }
    }
}

