/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.entity.PixieEntity;
import vazkii.botania.common.helper.ItemNBTHelper;

public class BottledManaItem
extends Item {
    public static final int SWIGS = 6;
    private static final String TAG_SWIGS_LEFT = "swigsLeft";
    private static final String TAG_SEED = "randomSeed";
    private static final EffectAction[] EFFECT_ACTIONS = new EffectAction[]{BottledManaItem::effectRandomMotion, BottledManaItem::effectWater, BottledManaItem::effectSetOnFire, BottledManaItem::effectMiniExplosion, BottledManaItem::effectMegaJump, BottledManaItem::effectSetRandomHp, BottledManaItem::effectLotsOfHearts, BottledManaItem::effectDropAllItems, BottledManaItem::effectBreakNeck, BottledManaItem::effectHighestPossible, BottledManaItem::effectHyperspeed, BottledManaItem::effectNightVision, BottledManaItem::effectPixieFriend, BottledManaItem::effectNauseaBlindness, BottledManaItem::effectDropOwnHead};

    public BottledManaItem(Item.Properties props) {
        super(props);
    }

    private static void effectRandomMotion(Level level, LivingEntity living) {
        living.setDeltaMovement((Math.random() - 0.5) * 3.0, living.getDeltaMovement().y(), (Math.random() - 0.5) * 3.0);
    }

    private static void effectWater(Level level, LivingEntity living) {
        if (!level.isClientSide && !level.dimensionType().ultraWarm()) {
            BlockState replacedState;
            BlockPos waterPos;
            LiquidBlockContainer lbc;
            Block block;
            BlockPos playerPos = living.blockPosition();
            BlockState state = level.getBlockState(playerPos);
            if (state.isAir() || state.canBeReplaced((Fluid)Fluids.WATER) || (block = state.getBlock()) instanceof LiquidBlockContainer && (lbc = (LiquidBlockContainer)block).canPlaceLiquid((BlockGetter)level, playerPos, state, (Fluid)Fluids.WATER)) {
                waterPos = playerPos;
                replacedState = state;
            } else {
                LiquidBlockContainer lbc2;
                Block block2;
                BlockState aboveState = level.getBlockState(playerPos.above());
                waterPos = aboveState.isAir() || aboveState.canBeReplaced((Fluid)Fluids.WATER) || (block2 = aboveState.getBlock()) instanceof LiquidBlockContainer && (lbc2 = (LiquidBlockContainer)block2).canPlaceLiquid((BlockGetter)level, playerPos.above(), aboveState, (Fluid)Fluids.WATER) ? playerPos.above() : null;
                replacedState = aboveState;
            }
            if (waterPos != null) {
                boolean placed;
                Block block3 = replacedState.getBlock();
                if (block3 instanceof LiquidBlockContainer) {
                    LiquidBlockContainer lbc3 = (LiquidBlockContainer)block3;
                    placed = lbc3.placeLiquid((LevelAccessor)level, waterPos, replacedState, Fluids.WATER.getSource(false));
                } else {
                    if (replacedState.canBeReplaced((Fluid)Fluids.WATER)) {
                        level.destroyBlock(waterPos, true);
                    }
                    placed = level.setBlockAndUpdate(waterPos, Blocks.WATER.defaultBlockState());
                }
                if (placed) {
                    level.playSound((Entity)living, waterPos, SoundEvents.WATER_AMBIENT, SoundSource.BLOCKS, 1.0f, level.random.nextFloat() + 0.5f);
                }
            }
        }
    }

    private static void effectSetOnFire(Level level, LivingEntity living) {
        if (!level.isClientSide) {
            living.setSecondsOnFire(4);
        }
    }

    private static void effectMiniExplosion(Level level, LivingEntity living) {
        if (!level.isClientSide) {
            level.explode(null, living.getX(), living.getY(), living.getZ(), 0.25f, Level.ExplosionInteraction.NONE);
        }
    }

    private static void effectMegaJump(Level level, LivingEntity living) {
        if (!level.dimensionType().ultraWarm()) {
            if (!level.isClientSide) {
                living.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 300, 5));
            }
            living.setDeltaMovement(living.getDeltaMovement().x(), 6.0, living.getDeltaMovement().z());
        }
    }

    private static void effectSetRandomHp(Level level, LivingEntity living) {
        if (!level.isClientSide) {
            float nextHealth = (float)(Math.random() * (double)living.getMaxHealth());
            if (Mth.equal((float)nextHealth, (float)0.0f)) {
                nextHealth = 0.5f;
            }
            living.setHealth(nextHealth);
        }
    }

    private static void effectLotsOfHearts(Level level, LivingEntity living) {
        if (!level.isClientSide) {
            living.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 2400, 9));
        }
    }

    private static void effectBreakNeck(Level level, LivingEntity living) {
        living.setXRot((float)Math.random() * 360.0f);
        living.setYRot((float)Math.random() * 180.0f);
    }

    private static void effectHighestPossible(Level level, LivingEntity living) {
        int x = Mth.floor((double)living.getX());
        int z = Mth.floor((double)living.getZ());
        for (int i = level.getMaxBuildHeight(); i > level.getMinBuildHeight(); --i) {
            BlockState state = level.getBlockState(new BlockPos(x, i, z));
            if (state.isAir()) continue;
            living.teleportTo(living.getX(), (double)i, living.getZ());
            break;
        }
    }

    private static void effectDropAllItems(Level level, LivingEntity living) {
        if (!level.isClientSide && living instanceof Player) {
            Player player = (Player)living;
            player.getInventory().dropAll();
        }
    }

    private static void effectHyperspeed(Level level, LivingEntity living) {
        if (!level.isClientSide) {
            living.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 60, 200));
        }
    }

    private static void effectNightVision(Level level, LivingEntity living) {
        if (!level.isClientSide) {
            living.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 6000, 0));
        }
    }

    private static void effectPixieFriend(Level level, LivingEntity living) {
        if (!level.isClientSide) {
            PixieEntity pixie = new PixieEntity(level);
            pixie.setPos(living.getX(), living.getY() + 1.5, living.getZ());
            level.addFreshEntity((Entity)pixie);
        }
    }

    private static void effectNauseaBlindness(Level level, LivingEntity living) {
        if (!level.isClientSide) {
            living.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 160, 3));
            living.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 160, 0));
        }
    }

    private static void effectDropOwnHead(Level level, LivingEntity living) {
        if (!level.isClientSide && living instanceof Player) {
            Player player = (Player)living;
            living.hurt(living.damageSources().magic(), living.getHealth() - 1.0f);
            ItemStack skull = new ItemStack((ItemLike)Items.PLAYER_HEAD);
            ItemNBTHelper.setString(skull, "SkullOwner", player.getGameProfile().getName());
            living.spawnAtLocation(skull, 0.0f);
        }
    }

    private long getSeed(ItemStack stack) {
        long seed = ItemNBTHelper.getLong(stack, TAG_SEED, -1L);
        if (seed == -1L) {
            return this.randomSeed(stack);
        }
        return seed;
    }

    private long randomSeed(ItemStack stack) {
        long seed = Math.abs(ThreadLocalRandom.current().nextLong());
        ItemNBTHelper.setLong(stack, TAG_SEED, seed);
        return seed;
    }

    public void appendHoverText(ItemStack stack, Level world, List<Component> stacks, TooltipFlag flags) {
        stacks.add((Component)Component.translatable((String)"botaniamisc.bottleTooltip"));
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, Level world, LivingEntity living) {
        EFFECT_ACTIONS[new Random(this.getSeed(stack)).nextInt(EFFECT_ACTIONS.length)].apply(world, living);
        int left = BottledManaItem.getSwigsLeft(stack);
        if (left <= 1) {
            stack.setCount(0);
            return new ItemStack((ItemLike)Items.GLASS_BOTTLE);
        }
        this.setSwigsLeft(stack, left - 1);
        this.randomSeed(stack);
        return stack;
    }

    public int getUseDuration(ItemStack stack) {
        return 20;
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public static int getSwigsLeft(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_SWIGS_LEFT, 6);
    }

    private void setSwigsLeft(ItemStack stack, int swigs) {
        ItemNBTHelper.setInt(stack, TAG_SWIGS_LEFT, swigs);
    }

    @FunctionalInterface
    private static interface EffectAction {
        public void apply(Level var1, LivingEntity var2);
    }
}

