/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.mixin.ItemEntityAccessor;

public class ThrownItemEntity
extends ItemEntity {
    public ThrownItemEntity(EntityType<ThrownItemEntity> type, Level world) {
        super(type, world);
    }

    public ThrownItemEntity(Level world, double x, double y, double z, ItemEntity item) {
        super(world, x, y, z, item.getItem());
        this.setPickUpDelay(((ItemEntityAccessor)item).getPickupDelay());
        this.setDeltaMovement(item.getDeltaMovement());
        this.setInvulnerable(true);
    }

    @NotNull
    public EntityType<?> getType() {
        return BotaniaEntities.THROWN_ITEM;
    }

    public void tick() {
        super.tick();
        int pickupDelay = ((ItemEntityAccessor)((Object)this)).getPickupDelay();
        Predicate<Entity> filter = e -> !e.isSpectator() && e.isAlive() && e.isPickable() && (!(e instanceof Player) || pickupDelay == 0);
        HitResult hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, filter);
        boolean teleported = false;
        if (hitResult.getType() == HitResult.Type.BLOCK) {
            BlockPos blockPos = ((BlockHitResult)hitResult).getBlockPos();
            BlockState blockState = this.level().getBlockState(blockPos);
            if (blockState.is(Blocks.NETHER_PORTAL)) {
                this.handleInsidePortal(blockPos);
                teleported = true;
            } else if (blockState.is(Blocks.END_GATEWAY)) {
                BlockEntity blockEntity = this.level().getBlockEntity(blockPos);
                if (blockEntity instanceof TheEndGatewayBlockEntity) {
                    TheEndGatewayBlockEntity gateway = (TheEndGatewayBlockEntity)blockEntity;
                    if (TheEndGatewayBlockEntity.canEntityTeleport((Entity)this)) {
                        TheEndGatewayBlockEntity.teleportEntity((Level)this.level(), (BlockPos)blockPos, (BlockState)blockState, (Entity)this, (TheEndGatewayBlockEntity)gateway);
                    }
                }
                teleported = true;
            }
        }
        if (teleported) {
            return;
        }
        if (!this.level().isClientSide && hitResult.getType() == HitResult.Type.ENTITY) {
            Entity bonk = ((EntityHitResult)hitResult).getEntity();
            bonk.hurt(this.damageSources().magic(), 2.0f);
            ItemEntity item = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), this.getItem());
            this.level().addFreshEntity((Entity)item);
            item.setDeltaMovement(this.getDeltaMovement().scale(0.25));
            this.discard();
            return;
        }
        if (!this.level().isClientSide && this.getDeltaMovement().length() < 1.0) {
            ItemEntity item = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), this.getItem());
            this.level().addFreshEntity((Entity)item);
            item.setDeltaMovement(this.getDeltaMovement());
            this.discard();
        }
    }
}

