/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.PistonType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.block.BotaniaBlock;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.ForcePushHelper;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.common.item.lens.ForceLens;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.xplat.XplatAbstractions;

public class ForceRelayBlock
extends BotaniaBlock {
    public final Map<UUID, GlobalPos> activeBindingAttempts = new HashMap<UUID, GlobalPos>();

    public ForceRelayBlock(BlockBehaviour.Properties builder) {
        super(builder.pushReaction(PushReaction.PUSH_ONLY));
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (!world.isClientSide) {
            WorldData data = WorldData.get(world);
            Direction movementContextDirection = ForcePushHelper.getMovementContextDirection();
            if (isMoving && (movementContextDirection != null || newState.is(Blocks.MOVING_PISTON))) {
                Direction pistonDirection = movementContextDirection != null ? movementContextDirection : (Direction)newState.getValue((Property)MovingPistonBlock.FACING);
                Direction moveDirection = ForcePushHelper.isExtendingMovementContext() ? pistonDirection : pistonDirection.getOpposite();
                BlockPos destPos = data.mapping.get(pos);
                if (destPos != null) {
                    BlockPos newSrcPos = pos.relative(moveDirection);
                    data.mapping.remove(pos);
                    data.mapping.put(newSrcPos, destPos);
                    data.setDirty();
                    if ((!newState.is(Blocks.MOVING_PISTON) || newState.getValue((Property)MovingPistonBlock.TYPE) == PistonType.DEFAULT) && ForceLens.moveBlocks(world, destPos.relative(moveDirection.getOpposite()), moveDirection, pos)) {
                        data.mapping.put(newSrcPos, data.mapping.get(newSrcPos).relative(moveDirection));
                    }
                }
            } else if (data.mapping.remove(pos) != null) {
                data.setDirty();
            }
        }
    }

    public boolean onUsedByWand(Player player, ItemStack stack, Level world, BlockPos pos) {
        if (world.isClientSide) {
            return false;
        }
        if (player == null || player.isShiftKeyDown()) {
            world.destroyBlock(pos, true);
        } else {
            GlobalPos clicked = GlobalPos.of((ResourceKey)world.dimension(), (BlockPos)pos.immutable());
            if (WandOfTheForestItem.getBindMode(stack)) {
                this.activeBindingAttempts.put(player.getUUID(), clicked);
                world.playSound(null, pos, BotaniaSounds.ding, SoundSource.BLOCKS, 0.5f, 1.0f);
            } else {
                BlockPos dest;
                WorldData data = WorldData.get(world);
                if (XplatAbstractions.INSTANCE.isDevEnvironment()) {
                    BotaniaAPI.LOGGER.info("PistonRelay pairs");
                    for (Map.Entry<BlockPos, BlockPos> e : data.mapping.entrySet()) {
                        BotaniaAPI.LOGGER.info("{} -> {}", (Object)e.getKey(), (Object)e.getValue());
                    }
                }
                if ((dest = data.mapping.get(pos)) != null) {
                    XplatAbstractions.INSTANCE.sendToNear(world, pos, new BotaniaEffectPacket(EffectType.PARTICLE_BEAM, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, dest.getX(), dest.getY(), dest.getZ()));
                }
            }
        }
        return true;
    }

    public static class WorldData
    extends SavedData {
        private static final String ID = "PistonRelayPairs";
        public final Map<BlockPos, BlockPos> mapping = new HashMap<BlockPos, BlockPos>();

        public WorldData(@NotNull CompoundTag cmp) {
            ListTag list = cmp.getList("list", 11);
            for (int i = 0; i < list.size(); i += 2) {
                Tag from = list.get(i);
                Tag to = list.get(i + 1);
                BlockPos fromPos = (BlockPos)((Pair)BlockPos.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)from).result().get()).getFirst();
                BlockPos toPos = (BlockPos)((Pair)BlockPos.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)to).result().get()).getFirst();
                this.mapping.put(fromPos, toPos);
            }
        }

        @NotNull
        public CompoundTag save(@NotNull CompoundTag cmp) {
            ListTag list = new ListTag();
            for (Map.Entry<BlockPos, BlockPos> e : this.mapping.entrySet()) {
                Tag from = (Tag)BlockPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)e.getKey()).result().get();
                Tag to = (Tag)BlockPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)e.getValue()).result().get();
                list.add((Object)from);
                list.add((Object)to);
            }
            cmp.put("list", (Tag)list);
            return cmp;
        }

        public static WorldData get(Level world) {
            WorldData data = (WorldData)((ServerLevel)world).getDataStorage().get(WorldData::new, ID);
            if (data == null) {
                data = new WorldData(new CompoundTag());
                data.setDirty();
                ((ServerLevel)world).getDataStorage().set(ID, (SavedData)data);
            }
            return data;
        }
    }
}

