/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.block_entity.red_string.RedStringBlockEntity;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.WandOfTheForestItem;

public class RedStringBlockEntityRenderer<T extends RedStringBlockEntity>
implements BlockEntityRenderer<T> {
    private static int transparency = 0;

    public static void tick() {
        boolean hasWand;
        LocalPlayer player = Minecraft.getInstance().player;
        boolean bl = hasWand = player != null && PlayerHelper.hasHeldItemClass((Player)player, WandOfTheForestItem.class);
        if (transparency > 0 && !hasWand) {
            --transparency;
        } else if (transparency < 10 && hasWand) {
            ++transparency;
        }
    }

    public RedStringBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(RedStringBlockEntity tile, float partialTicks, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        if (transparency <= 0) {
            return;
        }
        float sizeAlpha = (float)transparency / 10.0f;
        int color = 0xFF0000 | (int)(sizeAlpha * 255.0f) << 24;
        Direction dir = tile.getOrientation();
        BlockPos bind = tile.getBinding();
        if (bind != null) {
            Vec3 step;
            ms.pushPose();
            ms.translate(0.5, 0.5, 0.5);
            Vec3 span = new Vec3((double)(bind.getX() - tile.getBlockPos().getX()), (double)(bind.getY() - tile.getBlockPos().getY()), (double)(bind.getZ() - tile.getBlockPos().getZ()));
            Vec3 cur = step = span.normalize().scale(0.025);
            int stepCount = (int)(span.length() / step.length());
            double len = (double)(-ClientTickHandler.ticksInGame) / 100.0 + (double)new Random(dir.ordinal() ^ tile.getBlockPos().hashCode()).nextInt(10000);
            double add = step.length();
            double rand = Math.random() - 0.5;
            VertexConsumer buffer = buffers.getBuffer(RenderHelper.RED_STRING);
            for (int i = 0; i < stepCount; ++i) {
                RedStringBlockEntityRenderer.vertex(ms, buffer, color, dir, cur.x, cur.y, cur.z, rand, len);
                rand = Math.random() - 0.5;
                cur = cur.add(step);
                RedStringBlockEntityRenderer.vertex(ms, buffer, color, dir, cur.x, cur.y, cur.z, rand, len += add);
            }
            ms.popPose();
        }
    }

    private static void vertex(PoseStack ms, VertexConsumer buffer, int color, Direction dir, double xpos, double ypos, double zpos, double rand, double l) {
        float sizeAlpha = (float)transparency / 10.0f;
        float ampl = (float)(0.15 * ((double)Mth.sin((float)((float)l * 2.0f)) * 0.5 + 0.5) + 0.1) * sizeAlpha;
        float trigInput = (float)(l * 20.0);
        float sin = Mth.sin((float)trigInput);
        float cos = Mth.cos((float)trigInput);
        float lastTerm = (float)(rand * 0.05);
        float x = (float)xpos + sin * ampl * (float)RedStringBlockEntityRenderer.killNonZero(dir.getStepX()) + lastTerm;
        float y = (float)ypos + cos * ampl * (float)RedStringBlockEntityRenderer.killNonZero(dir.getStepY()) + lastTerm;
        float z = (float)zpos + (dir.getStepY() == 0 ? sin : cos) * ampl * (float)RedStringBlockEntityRenderer.killNonZero(dir.getStepZ()) + lastTerm;
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        buffer.vertex(ms.last().pose(), x, y, z).color(r, g, b, a);
        switch (dir.getAxis().getPlane()) {
            case HORIZONTAL: {
                buffer.normal(ms.last().normal(), 0.0f, 1.0f, 0.0f);
                break;
            }
            case VERTICAL: {
                buffer.normal(ms.last().normal(), 1.0f, 0.0f, 0.0f);
            }
        }
        buffer.endVertex();
    }

    private static int killNonZero(int diff) {
        if (diff != 0) {
            return 0;
        }
        return 1;
    }
}

