/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.patchouli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.xplat.XplatAbstractions;
import vazkii.patchouli.api.IVariable;

public class PatchouliUtils {
    private static boolean crafttweakerInfoNote = false;
    private static boolean inVisualizer;

    public static <T extends Recipe<C>, C extends Container> T getRecipe(Level level, RecipeType<T> type, ResourceLocation id) {
        Map<ResourceLocation, T> map = BotaniaRecipeTypes.getRecipes(level, type);
        Recipe r = (Recipe)map.get(id);
        if (r != null) {
            return (T)r;
        }
        r = (Recipe)map.get(new ResourceLocation("crafttweaker", id.getPath()));
        if (r != null) {
            return (T)r;
        }
        r = (Recipe)map.get(new ResourceLocation("crafttweaker", "autogenerated/" + id.getNamespace() + "." + id.getPath()));
        if (r != null) {
            return (T)r;
        }
        BotaniaAPI.LOGGER.warn("Template references nonexistent recipe {} of type {}", (Object)id, type);
        if (!crafttweakerInfoNote) {
            crafttweakerInfoNote = true;
            if (XplatAbstractions.INSTANCE.isModLoaded("crafttweaker")) {
                BotaniaAPI.LOGGER.info("To add a recipe that replaces a builtin recipe with CT, \nadd one with the same type, named the same as the path of the missing recipe.\neg. for recipe {}, add a recipe named \"{}\".", (Object)id, (Object)id.getPath());
            }
        }
        return null;
    }

    public static <T extends Recipe<C>, C extends Container> List<T> getRecipeGroup(RecipeType<T> type, String group) {
        Map<ResourceLocation, T> map = BotaniaRecipeTypes.getRecipes((Level)Minecraft.getInstance().level, type);
        ArrayList<Recipe> list = new ArrayList<Recipe>();
        for (Recipe value : map.values()) {
            if (!group.equals(value.getGroup())) continue;
            list.add(value);
        }
        if (list.isEmpty()) {
            BotaniaAPI.LOGGER.warn("Template references empty group {} of recipe type {}", (Object)group, type);
        }
        return list;
    }

    public static IVariable interweaveIngredients(List<Ingredient> ingredients, int longestIngredientSize) {
        if (ingredients.size() == 1) {
            return IVariable.wrapList((Iterable)Arrays.stream(ingredients.get(0).getItems()).map(IVariable::from).collect(Collectors.toList()));
        }
        ItemStack[] empty = new ItemStack[]{ItemStack.EMPTY};
        ArrayList<ItemStack[]> stacks = new ArrayList<ItemStack[]>();
        for (Ingredient ingredient : ingredients) {
            if (ingredient != null && !ingredient.isEmpty()) {
                stacks.add(ingredient.getItems());
                continue;
            }
            stacks.add(empty);
        }
        ArrayList<IVariable> list = new ArrayList<IVariable>(stacks.size() * longestIngredientSize);
        for (int i = 0; i < longestIngredientSize; ++i) {
            for (ItemStack[] stack : stacks) {
                list.add(IVariable.from((Object)stack[i % stack.length]));
            }
        }
        return IVariable.wrapList(list);
    }

    public static IVariable interweaveIngredients(List<Ingredient> ingredients) {
        return PatchouliUtils.interweaveIngredients(ingredients, ingredients.stream().mapToInt(ingr -> ingr.getItems().length).max().orElse(1));
    }

    public static boolean isInVisualizer() {
        return inVisualizer;
    }

    public static void setInVisualizer(boolean inVisualization) {
        inVisualizer = inVisualization;
    }
}

