/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.armor.terrasteel;

import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.item.AncientWillContainer;
import vazkii.botania.api.mana.ManaDiscountArmor;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.BotaniaDamageTypes;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.armor.terrasteel.TerrasteelArmorItem;

public class TerrasteelHelmItem
extends TerrasteelArmorItem
implements ManaDiscountArmor,
AncientWillContainer {
    public static final String TAG_ANCIENT_WILL = "AncientWill";

    public TerrasteelHelmItem(Item.Properties props) {
        super(ArmorItem.Type.HELMET, props);
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(stack, world, entity, slot, selected);
        if (!world.isClientSide && entity instanceof Player) {
            Player player = (Player)entity;
            if (player.getInventory().armor.contains((Object)stack) && this.hasArmorSet(player)) {
                int food = player.getFoodData().getFoodLevel();
                if (food > 0 && food < 18 && player.isHurt() && player.tickCount % 80 == 0) {
                    player.heal(1.0f);
                }
                if (player.tickCount % 10 == 0) {
                    ManaItemHandler.instance().dispatchManaExact(stack, player, 10, true);
                }
            }
        }
    }

    @Override
    public float getDiscount(ItemStack stack, int slot, Player player, @Nullable ItemStack tool) {
        return this.hasArmorSet(player) ? 0.2f : 0.0f;
    }

    @Override
    public void addAncientWill(ItemStack stack, AncientWillContainer.AncientWillType will) {
        ItemNBTHelper.setBoolean(stack, "AncientWill_" + will.name().toLowerCase(Locale.ROOT), true);
    }

    @Override
    public boolean hasAncientWill(ItemStack stack, AncientWillContainer.AncientWillType will) {
        return TerrasteelHelmItem.hasAncientWill_(stack, will);
    }

    private static boolean hasAncientWill_(ItemStack stack, AncientWillContainer.AncientWillType will) {
        return ItemNBTHelper.getBoolean(stack, "AncientWill_" + will.name().toLowerCase(Locale.ROOT), false);
    }

    @Override
    public void addArmorSetDescription(ItemStack stack, List<Component> list) {
        super.addArmorSetDescription(stack, list);
        for (AncientWillContainer.AncientWillType type : AncientWillContainer.AncientWillType.values()) {
            if (!this.hasAncientWill(stack, type)) continue;
            list.add((Component)Component.translatable((String)("botania.armorset.will_" + type.name().toLowerCase(Locale.ROOT) + ".desc")).withStyle(ChatFormatting.GRAY));
        }
    }

    public static boolean hasAnyWill(ItemStack stack) {
        for (AncientWillContainer.AncientWillType type : AncientWillContainer.AncientWillType.values()) {
            if (!TerrasteelHelmItem.hasAncientWill_(stack, type)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasTerraArmorSet(Player player) {
        return ((TerrasteelHelmItem)BotaniaItems.terrasteelHelm).hasArmorSet(player);
    }

    public static float getCritDamageMult(Player player) {
        ItemStack stack;
        if (TerrasteelHelmItem.hasTerraArmorSet(player) && !(stack = player.getItemBySlot(EquipmentSlot.HEAD)).isEmpty() && stack.getItem() instanceof TerrasteelHelmItem && TerrasteelHelmItem.hasAncientWill_(stack, AncientWillContainer.AncientWillType.DHAROK)) {
            return 1.0f + (1.0f - player.getHealth() / player.getMaxHealth()) * 0.5f;
        }
        return 1.0f;
    }

    public static DamageSource onEntityAttacked(DamageSource source, float amount, Player player, LivingEntity entity) {
        ItemStack stack;
        if (TerrasteelHelmItem.hasTerraArmorSet(player) && !(stack = player.getItemBySlot(EquipmentSlot.HEAD)).isEmpty() && stack.getItem() instanceof TerrasteelHelmItem) {
            if (TerrasteelHelmItem.hasAncientWill_(stack, AncientWillContainer.AncientWillType.AHRIM)) {
                entity.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 20, 1));
            }
            if (TerrasteelHelmItem.hasAncientWill_(stack, AncientWillContainer.AncientWillType.GUTHAN)) {
                player.heal(amount * 0.25f);
            }
            if (TerrasteelHelmItem.hasAncientWill_(stack, AncientWillContainer.AncientWillType.TORAG)) {
                entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 1));
            }
            if (TerrasteelHelmItem.hasAncientWill_(stack, AncientWillContainer.AncientWillType.VERAC)) {
                source = BotaniaDamageTypes.Sources.playerAttackArmorPiercing(player.level().registryAccess(), player);
            }
            if (TerrasteelHelmItem.hasAncientWill_(stack, AncientWillContainer.AncientWillType.KARIL)) {
                entity.addEffect(new MobEffectInstance(MobEffects.WITHER, 60, 1));
            }
        }
        return source;
    }
}

