/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.mana.CompositableLensItem;
import vazkii.botania.common.crafting.recipe.NoOpRecipeSerializer;
import vazkii.botania.common.lib.BotaniaTags;

public class CompositeLensRecipe
extends CustomRecipe {
    public static final NoOpRecipeSerializer<CompositeLensRecipe> SERIALIZER = new NoOpRecipeSerializer<CompositeLensRecipe>(CompositeLensRecipe::new);

    public CompositeLensRecipe(ResourceLocation id) {
        super(id, CraftingBookCategory.REDSTONE);
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level world) {
        boolean foundLens = false;
        boolean foundSecondLens = false;
        boolean foundGlue = false;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof CompositableLensItem && !foundSecondLens) {
                if (foundLens) {
                    foundSecondLens = true;
                    continue;
                }
                foundLens = true;
                continue;
            }
            if (stack.is(BotaniaTags.Items.LENS_GLUE) && !foundGlue) {
                foundGlue = true;
                continue;
            }
            return false;
        }
        return foundSecondLens && foundGlue;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess registries) {
        Item stack;
        ItemStack lens = ItemStack.EMPTY;
        ItemStack secondLens = ItemStack.EMPTY;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            stack = inv.getItem(i);
            if (stack.isEmpty() || !(stack.getItem() instanceof CompositableLensItem)) continue;
            if (lens.isEmpty()) {
                lens = stack;
                continue;
            }
            secondLens = stack;
        }
        stack = lens.getItem();
        if (stack instanceof CompositableLensItem) {
            CompositableLensItem lensItem = (CompositableLensItem)stack;
            if (secondLens.isEmpty() || !lensItem.canCombineLenses(lens, secondLens) || !lensItem.getCompositeLens(lens).isEmpty() || !lensItem.getCompositeLens(secondLens).isEmpty()) {
                return ItemStack.EMPTY;
            }
            ItemStack lensCopy = lens.copyWithCount(1);
            ItemStack secondCopy = secondLens.copyWithCount(1);
            lensItem.setCompositeLens(lensCopy, secondCopy);
            return lensCopy;
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 3;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }
}

