/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class WaterBottleMatchingRecipe
extends ShapedRecipe {
    public static final RecipeSerializer<WaterBottleMatchingRecipe> SERIALIZER = new Serializer();

    public WaterBottleMatchingRecipe(ResourceLocation id, String group, CraftingBookCategory category, int width, int height, NonNullList<Ingredient> recipeItems, ItemStack result) {
        super(id, group, category, width, height, NonNullList.of((Object)Ingredient.EMPTY, (Object[])((Ingredient[])recipeItems.stream().map(i -> {
            if (i.test(new ItemStack((ItemLike)Items.POTION))) {
                return Ingredient.of((ItemStack[])new ItemStack[]{PotionUtils.setPotion((ItemStack)new ItemStack((ItemLike)Items.POTION), (Potion)Potions.WATER)});
            }
            return i;
        }).toArray(Ingredient[]::new))), result);
    }

    public WaterBottleMatchingRecipe(ShapedRecipe recipe) {
        this(recipe.getId(), recipe.getGroup(), recipe.category(), recipe.getWidth(), recipe.getHeight(), (NonNullList<Ingredient>)recipe.getIngredients(), recipe.getResultItem((RegistryAccess)RegistryAccess.EMPTY));
    }

    public boolean matches(@NotNull CraftingContainer craftingContainer, @NotNull Level level) {
        if (!super.matches(craftingContainer, level)) {
            return false;
        }
        for (int i = 0; i < craftingContainer.getContainerSize(); ++i) {
            ItemStack item = craftingContainer.getItem(i);
            if (!item.is(Items.POTION) || PotionUtils.getPotion((ItemStack)item) == Potions.WATER) continue;
            return false;
        }
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    private static class Serializer
    implements RecipeSerializer<WaterBottleMatchingRecipe> {
        private Serializer() {
        }

        public WaterBottleMatchingRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            return new WaterBottleMatchingRecipe((ShapedRecipe)SHAPED_RECIPE.fromJson(recipeId, json));
        }

        public WaterBottleMatchingRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
            return new WaterBottleMatchingRecipe((ShapedRecipe)SHAPED_RECIPE.fromNetwork(recipeId, buffer));
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull WaterBottleMatchingRecipe recipe) {
            SHAPED_RECIPE.toNetwork(buffer, (Recipe)recipe);
        }
    }
}

