/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.forge.data;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.lib.BotaniaTags;

public class ForgeBlockTagProvider
extends IntrinsicHolderTagsProvider<Block> {
    public static final TagKey<Block> MUSHROOMS = ForgeBlockTagProvider.forge("mushrooms");
    public static final TagKey<Block> ELEMENTIUM = ForgeBlockTagProvider.forge("storage_blocks/elementium");
    public static final TagKey<Block> MANASTEEL = ForgeBlockTagProvider.forge("storage_blocks/manasteel");
    public static final TagKey<Block> TERRASTEEL = ForgeBlockTagProvider.forge("storage_blocks/terrasteel");
    public static final TagKey<Block> MANA_DIAMOND = ForgeBlockTagProvider.forge("storage_blocks/mana_diamond");
    public static final TagKey<Block> DRAGONSTONE = ForgeBlockTagProvider.forge("storage_blocks/dragonstone");
    public static final TagKey<Block> BLAZE_MESH = ForgeBlockTagProvider.forge("storage_blocks/blaze_mesh");
    public static final Map<DyeColor, TagKey<Block>> PETAL_BLOCKS = ColorHelper.supportedColors().collect(Collectors.toMap(Function.identity(), color -> ForgeBlockTagProvider.forge("storage_blocks/" + ForgeRegistries.BLOCKS.getKey((Object)BotaniaBlocks.getPetalBlock(color)).getPath())));

    public ForgeBlockTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, ExistingFileHelper existingFileHelper) {
        super(output, Registries.BLOCK, provider, block -> block.builtInRegistryHolder().key(), "botania", existingFileHelper);
    }

    public String getName() {
        return "Botania block tags (Forge-specific)";
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.tag(Tags.Blocks.STORAGE_BLOCKS_QUARTZ).add((Object[])new Block[]{BotaniaBlocks.darkQuartz, BotaniaBlocks.manaQuartz, BotaniaBlocks.blazeQuartz, BotaniaBlocks.lavenderQuartz, BotaniaBlocks.redQuartz, BotaniaBlocks.elfQuartz, BotaniaBlocks.sunnyQuartz});
        IntrinsicHolderTagsProvider.IntrinsicTagAppender storageBlocks = this.tag(Tags.Blocks.STORAGE_BLOCKS);
        ColorHelper.supportedColors().forEach(color -> {
            this.tag(MUSHROOMS).add((Object)BotaniaBlocks.getMushroom(color));
            TagKey<Block> petalStorageBlockTag = PETAL_BLOCKS.get(color);
            this.tag(petalStorageBlockTag).add((Object)BotaniaBlocks.getPetalBlock(color));
            storageBlocks.addTag(petalStorageBlockTag);
        });
        this.tag(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)new ResourceLocation("buzzier_bees", "flower_blacklist"))).addTag(BotaniaTags.Blocks.MYSTICAL_FLOWERS).addTag(BotaniaTags.Blocks.SPECIAL_FLOWERS);
        this.tag(ELEMENTIUM).addTag(BotaniaTags.Blocks.BLOCKS_ELEMENTIUM);
        this.tag(MANASTEEL).addTag(BotaniaTags.Blocks.BLOCKS_MANASTEEL);
        this.tag(TERRASTEEL).addTag(BotaniaTags.Blocks.BLOCKS_TERRASTEEL);
        this.tag(MANA_DIAMOND).add((Object)BotaniaBlocks.manaDiamondBlock);
        this.tag(DRAGONSTONE).add((Object)BotaniaBlocks.dragonstoneBlock);
        this.tag(BLAZE_MESH).add((Object)BotaniaBlocks.blazeBlock);
        storageBlocks.addTag(ELEMENTIUM).addTag(MANASTEEL).addTag(TERRASTEEL).addTag(MANA_DIAMOND).addTag(DRAGONSTONE).addTag(BLAZE_MESH);
        this.tag(Tags.Blocks.GLASS).add((Object[])new Block[]{BotaniaBlocks.manaGlass, BotaniaBlocks.elfGlass, BotaniaBlocks.bifrostPerm});
        this.tag(Tags.Blocks.GLASS_PANES).add((Object[])new Block[]{BotaniaBlocks.managlassPane, BotaniaBlocks.alfglassPane, BotaniaBlocks.bifrostPane});
        this.tag(Tags.Blocks.FENCES_WOODEN).add((Object[])new Block[]{BotaniaBlocks.livingwoodFence, BotaniaBlocks.dreamwoodFence});
        this.tag(Tags.Blocks.FENCE_GATES_WOODEN).add((Object[])new Block[]{BotaniaBlocks.livingwoodFenceGate, BotaniaBlocks.dreamwoodFenceGate});
    }

    private static TagKey<Block> forge(String name) {
        return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)new ResourceLocation("forge", name));
    }
}

