/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.crafting.StateIngredientHelper;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.data.recipes.BotaniaRecipeProvider;

public class ManaInfusionProvider
extends BotaniaRecipeProvider {
    public ManaInfusionProvider(PackOutput packOutput) {
        super(packOutput);
    }

    public String getName() {
        return "Botania mana pool recipes";
    }

    @Override
    public void buildRecipes(Consumer<net.minecraft.data.recipes.FinishedRecipe> consumer) {
        consumer.accept(new FinishedRecipe(this.id("manasteel"), new ItemStack((ItemLike)BotaniaItems.manaSteel), Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT}), 3000));
        consumer.accept(new FinishedRecipe(this.id("manasteel_block"), new ItemStack((ItemLike)BotaniaBlocks.manasteelBlock), ManaInfusionProvider.ingr((ItemLike)Blocks.IRON_BLOCK), 27000));
        consumer.accept(new FinishedRecipe(this.id("mana_pearl"), new ItemStack((ItemLike)BotaniaItems.manaPearl), ManaInfusionProvider.ingr((ItemLike)Items.ENDER_PEARL), 6000));
        consumer.accept(new FinishedRecipe(this.id("mana_diamond"), new ItemStack((ItemLike)BotaniaItems.manaDiamond), Ingredient.of((ItemLike[])new ItemLike[]{Items.DIAMOND}), 10000));
        consumer.accept(new FinishedRecipe(this.id("mana_diamond_block"), new ItemStack((ItemLike)BotaniaBlocks.manaDiamondBlock), ManaInfusionProvider.ingr((ItemLike)Blocks.DIAMOND_BLOCK), 90000));
        Ingredient dust = Ingredient.of((ItemLike[])new ItemLike[]{Items.GUNPOWDER, Items.REDSTONE, Items.GLOWSTONE_DUST, Items.SUGAR});
        consumer.accept(new FinishedRecipe(this.id("mana_powder_dust"), new ItemStack((ItemLike)BotaniaItems.manaPowder), dust, 500));
        Ingredient dyeIngredient = Ingredient.of((ItemLike[])((ItemLike[])ColorHelper.supportedColors().map(DyeItem::byColor).toArray(Item[]::new)));
        consumer.accept(new FinishedRecipe(this.id("mana_powder_dye"), new ItemStack((ItemLike)BotaniaItems.manaPowder), dyeIngredient, 400));
        consumer.accept(new FinishedRecipe(this.id("piston_relay"), new ItemStack((ItemLike)BotaniaBlocks.pistonRelay), ManaInfusionProvider.ingr((ItemLike)Blocks.PISTON), 15000));
        consumer.accept(new FinishedRecipe(this.id("mana_cookie"), new ItemStack((ItemLike)BotaniaItems.manaCookie), ManaInfusionProvider.ingr((ItemLike)Items.COOKIE), 20000));
        consumer.accept(new FinishedRecipe(this.id("grass_seeds"), new ItemStack((ItemLike)BotaniaItems.grassSeeds), ManaInfusionProvider.ingr((ItemLike)Blocks.GRASS), 2500));
        consumer.accept(new FinishedRecipe(this.id("podzol_seeds"), new ItemStack((ItemLike)BotaniaItems.podzolSeeds), ManaInfusionProvider.ingr((ItemLike)Blocks.DEAD_BUSH), 2500));
        consumer.accept(new FinishedRecipe(this.id("mycel_seeds"), new ItemStack((ItemLike)BotaniaItems.mycelSeeds), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.RED_MUSHROOM, Blocks.BROWN_MUSHROOM}), 6500));
        consumer.accept(new FinishedRecipe(this.id("mana_quartz"), new ItemStack((ItemLike)BotaniaItems.manaQuartz), ManaInfusionProvider.ingr((ItemLike)Items.QUARTZ), 250));
        consumer.accept(new FinishedRecipe(this.id("tiny_potato"), new ItemStack((ItemLike)BotaniaBlocks.tinyPotato), ManaInfusionProvider.ingr((ItemLike)Items.POTATO), 1337));
        consumer.accept(new FinishedRecipe(this.id("mana_glass"), new ItemStack((ItemLike)BotaniaBlocks.manaGlass), ManaInfusionProvider.ingr((ItemLike)Blocks.GLASS), 150));
        consumer.accept(new FinishedRecipe(this.id("mana_string"), new ItemStack((ItemLike)BotaniaItems.manaString), ManaInfusionProvider.ingr((ItemLike)Items.STRING), 1250));
        consumer.accept(new FinishedRecipe(this.id("mana_bottle"), new ItemStack((ItemLike)BotaniaItems.manaBottle), ManaInfusionProvider.ingr((ItemLike)Items.GLASS_BOTTLE), 5000));
        consumer.accept(FinishedRecipe.alchemy(this.id("rotten_flesh_to_leather"), new ItemStack((ItemLike)Items.LEATHER), ManaInfusionProvider.ingr((ItemLike)Items.ROTTEN_FLESH), 600));
        this.cycle(consumer, 40, "botania:log_cycle", new ItemLike[]{Blocks.OAK_LOG, Blocks.SPRUCE_LOG, Blocks.BIRCH_LOG, Blocks.JUNGLE_LOG, Blocks.ACACIA_LOG, Blocks.DARK_OAK_LOG, Blocks.MANGROVE_LOG, Blocks.CHERRY_LOG});
        this.cycle(consumer, 40, "botania:froglight_cycle", new ItemLike[]{Blocks.OCHRE_FROGLIGHT, Blocks.VERDANT_FROGLIGHT, Blocks.PEARLESCENT_FROGLIGHT});
        this.cycle(consumer, 120, "botania:sapling_cycle", new ItemLike[]{Blocks.OAK_SAPLING, Blocks.SPRUCE_SAPLING, Blocks.BIRCH_SAPLING, Blocks.JUNGLE_SAPLING, Blocks.ACACIA_SAPLING, Blocks.DARK_OAK_SAPLING, Blocks.MANGROVE_PROPAGULE, Blocks.CHERRY_SAPLING});
        consumer.accept(this.deconstruct("glowstone_deconstruct", (ItemLike)Items.GLOWSTONE_DUST, (ItemLike)Blocks.GLOWSTONE));
        consumer.accept(this.deconstruct("quartz_deconstruct", (ItemLike)Items.QUARTZ, (ItemLike)Blocks.QUARTZ_BLOCK));
        consumer.accept(this.deconstruct("dark_quartz_deconstruct", (ItemLike)BotaniaItems.darkQuartz, (ItemLike)BotaniaBlocks.darkQuartz));
        consumer.accept(this.deconstruct("mana_quartz_deconstruct", (ItemLike)BotaniaItems.manaQuartz, (ItemLike)BotaniaBlocks.manaQuartz));
        consumer.accept(this.deconstruct("blaze_quartz_deconstruct", (ItemLike)BotaniaItems.blazeQuartz, (ItemLike)BotaniaBlocks.blazeQuartz));
        consumer.accept(this.deconstruct("lavender_quartz_deconstruct", (ItemLike)BotaniaItems.lavenderQuartz, (ItemLike)BotaniaBlocks.lavenderQuartz));
        consumer.accept(this.deconstruct("red_quartz_deconstruct", (ItemLike)BotaniaItems.redQuartz, (ItemLike)BotaniaBlocks.redQuartz));
        consumer.accept(this.deconstruct("elf_quartz_deconstruct", (ItemLike)BotaniaItems.elfQuartz, (ItemLike)BotaniaBlocks.elfQuartz));
        consumer.accept(this.deconstruct("sunny_quartz_deconstruct", (ItemLike)BotaniaItems.sunnyQuartz, (ItemLike)BotaniaBlocks.sunnyQuartz));
        consumer.accept(FinishedRecipe.alchemy(this.id("chiseled_stone_bricks"), new ItemStack((ItemLike)Blocks.CHISELED_STONE_BRICKS, 1), ManaInfusionProvider.ingr((ItemLike)Blocks.STONE_BRICKS), 150));
        consumer.accept(FinishedRecipe.alchemy(this.id("ice"), new ItemStack((ItemLike)Blocks.ICE), ManaInfusionProvider.ingr((ItemLike)Blocks.SNOW_BLOCK), 2250));
        String vineLilypadGroup = "botania:vine_and_lily_pad_cycle";
        consumer.accept(FinishedRecipe.alchemy(this.id("vine_to_lily_pad"), new ItemStack((ItemLike)Blocks.LILY_PAD), ManaInfusionProvider.ingr((ItemLike)Blocks.VINE), 320, "botania:vine_and_lily_pad_cycle"));
        consumer.accept(FinishedRecipe.alchemy(this.id("lily_pad_to_vine"), new ItemStack((ItemLike)Blocks.VINE), ManaInfusionProvider.ingr((ItemLike)Blocks.LILY_PAD), 320, "botania:vine_and_lily_pad_cycle"));
        this.cycle(consumer, 200, "botania:fish_cycle", new ItemLike[]{Items.COD, Items.SALMON, Items.TROPICAL_FISH, Items.PUFFERFISH});
        this.cycle(consumer, 6000, "botania:crop_cycle", new ItemLike[]{Items.COCOA_BEANS, Items.WHEAT_SEEDS, Items.POTATO, Items.CARROT, Items.BEETROOT_SEEDS, Items.MELON_SEEDS, Items.PUMPKIN_SEEDS});
        consumer.accept(FinishedRecipe.alchemy(this.id("potato_unpoison"), new ItemStack((ItemLike)Items.POTATO), ManaInfusionProvider.ingr((ItemLike)Items.POISONOUS_POTATO), 1200));
        consumer.accept(FinishedRecipe.alchemy(this.id("blaze_rod_to_nether_wart"), new ItemStack((ItemLike)Items.NETHER_WART), ManaInfusionProvider.ingr((ItemLike)Items.BLAZE_ROD), 4000));
        this.cycle(consumer, 200, "", new ItemLike[]{Items.GUNPOWDER, Items.FLINT});
        consumer.accept(FinishedRecipe.alchemy(this.id("book_to_name_tag"), new ItemStack((ItemLike)Items.NAME_TAG), ManaInfusionProvider.ingr((ItemLike)Items.WRITABLE_BOOK), 6000));
        consumer.accept(FinishedRecipe.alchemy(this.id("wool_deconstruct"), new ItemStack((ItemLike)Items.STRING, 3), Ingredient.of((TagKey)ItemTags.WOOL), 100));
        String cactusSlimeGroup = "botania:cactus_and_slime_cycle";
        consumer.accept(FinishedRecipe.alchemy(this.id("cactus_to_slime"), new ItemStack((ItemLike)Items.SLIME_BALL), ManaInfusionProvider.ingr((ItemLike)Blocks.CACTUS), 1200, "botania:cactus_and_slime_cycle"));
        consumer.accept(FinishedRecipe.alchemy(this.id("slime_to_cactus"), new ItemStack((ItemLike)Blocks.CACTUS), ManaInfusionProvider.ingr((ItemLike)Items.SLIME_BALL), 1200, "botania:cactus_and_slime_cycle"));
        consumer.accept(FinishedRecipe.alchemy(this.id("ender_pearl_from_ghast_tear"), new ItemStack((ItemLike)Items.ENDER_PEARL), ManaInfusionProvider.ingr((ItemLike)Items.GHAST_TEAR), 28000));
        this.cycle(consumer, 300, "botania:glowstone_and_redstone_cycle", new ItemLike[]{Items.GLOWSTONE_DUST, Items.REDSTONE});
        consumer.accept(FinishedRecipe.alchemy(this.id("cobble_to_sand"), new ItemStack((ItemLike)Blocks.SAND), ManaInfusionProvider.ingr((ItemLike)Blocks.COBBLESTONE), 50));
        consumer.accept(FinishedRecipe.alchemy(this.id("terracotta_to_red_sand"), new ItemStack((ItemLike)Blocks.RED_SAND), ManaInfusionProvider.ingr((ItemLike)Blocks.TERRACOTTA), 50));
        consumer.accept(this.deconstruct("clay_deconstruct", (ItemLike)Items.CLAY_BALL, (ItemLike)Blocks.CLAY));
        consumer.accept(this.deconstruct("brick_deconstruct", (ItemLike)Items.BRICK, (ItemLike)Blocks.BRICKS));
        consumer.accept(FinishedRecipe.alchemy(this.id("coarse_dirt"), new ItemStack((ItemLike)Blocks.COARSE_DIRT), ManaInfusionProvider.ingr((ItemLike)Blocks.DIRT), 120));
        consumer.accept(FinishedRecipe.alchemy(this.id("soul_soil"), new ItemStack((ItemLike)Blocks.SOUL_SOIL), ManaInfusionProvider.ingr((ItemLike)Blocks.SOUL_SAND), 120));
        consumer.accept(FinishedRecipe.alchemy(this.id("stone_to_andesite"), new ItemStack((ItemLike)Blocks.ANDESITE), ManaInfusionProvider.ingr((ItemLike)Blocks.STONE), 200));
        this.cycle(consumer, 200, "botania:stone_cycle", new ItemLike[]{Blocks.DIORITE, Blocks.GRANITE, Blocks.ANDESITE});
        this.cycle(consumer, 200, "botania:117_stone_cycle", new ItemLike[]{Blocks.TUFF, Blocks.CALCITE, Blocks.DEEPSLATE});
        this.cycle(consumer, 500, "botania:shrub_cycle", new ItemLike[]{Blocks.FERN, Blocks.DEAD_BUSH, Blocks.GRASS});
        this.cycle(consumer, 400, "botania:flower_cycle", new ItemLike[]{Blocks.DANDELION, Blocks.POPPY, Blocks.BLUE_ORCHID, Blocks.ALLIUM, Blocks.AZURE_BLUET, Blocks.RED_TULIP, Blocks.ORANGE_TULIP, Blocks.WHITE_TULIP, Blocks.PINK_TULIP, Blocks.OXEYE_DAISY, Blocks.CORNFLOWER, Blocks.LILY_OF_THE_VALLEY, Blocks.SUNFLOWER, Blocks.LILAC, Blocks.ROSE_BUSH, Blocks.PEONY});
        consumer.accept(FinishedRecipe.alchemy(this.id("dripleaf_shrinking"), new ItemStack((ItemLike)Blocks.SMALL_DRIPLEAF), ManaInfusionProvider.ingr((ItemLike)Items.BIG_DRIPLEAF), 500));
        consumer.accept(FinishedRecipe.alchemy(this.id("chorus_fruit_to_flower"), new ItemStack((ItemLike)Blocks.CHORUS_FLOWER), ManaInfusionProvider.ingr((ItemLike)Items.POPPED_CHORUS_FRUIT), 10000));
        this.cycle(consumer, 240, "botania:berry_cycle", new ItemLike[]{Items.APPLE, Items.SWEET_BERRIES, Items.GLOW_BERRIES});
        consumer.accept(this.mini((ItemLike)BotaniaFlowerBlocks.agricarnationChibi, (ItemLike)BotaniaFlowerBlocks.agricarnation));
        consumer.accept(this.mini((ItemLike)BotaniaFlowerBlocks.clayconiaChibi, (ItemLike)BotaniaFlowerBlocks.clayconia));
        consumer.accept(this.mini((ItemLike)BotaniaFlowerBlocks.bellethornChibi, (ItemLike)BotaniaFlowerBlocks.bellethorn));
        consumer.accept(this.mini((ItemLike)BotaniaFlowerBlocks.bubbellChibi, (ItemLike)BotaniaFlowerBlocks.bubbell));
        consumer.accept(this.mini((ItemLike)BotaniaFlowerBlocks.hopperhockChibi, (ItemLike)BotaniaFlowerBlocks.hopperhock));
        consumer.accept(this.mini((ItemLike)BotaniaFlowerBlocks.jiyuuliaChibi, (ItemLike)BotaniaFlowerBlocks.jiyuulia));
        consumer.accept(this.mini((ItemLike)BotaniaFlowerBlocks.tangleberrieChibi, (ItemLike)BotaniaFlowerBlocks.tangleberrie));
        consumer.accept(this.mini((ItemLike)BotaniaFlowerBlocks.marimorphosisChibi, (ItemLike)BotaniaFlowerBlocks.marimorphosis));
        consumer.accept(this.mini((ItemLike)BotaniaFlowerBlocks.rannuncarpusChibi, (ItemLike)BotaniaFlowerBlocks.rannuncarpus));
        consumer.accept(this.mini((ItemLike)BotaniaFlowerBlocks.solegnoliaChibi, (ItemLike)BotaniaFlowerBlocks.solegnolia));
        consumer.accept(FinishedRecipe.alchemy(this.id("hydroangeas_motif"), new ItemStack((ItemLike)BotaniaBlocks.motifHydroangeas), ManaInfusionProvider.ingr((ItemLike)BotaniaFlowerBlocks.hydroangeas), 2500));
        consumer.accept(FinishedRecipe.conjuration(this.id("redstone_dupe"), new ItemStack((ItemLike)Items.REDSTONE, 2), ManaInfusionProvider.ingr((ItemLike)Items.REDSTONE), 5000));
        consumer.accept(FinishedRecipe.conjuration(this.id("glowstone_dupe"), new ItemStack((ItemLike)Items.GLOWSTONE_DUST, 2), ManaInfusionProvider.ingr((ItemLike)Items.GLOWSTONE_DUST), 5000));
        consumer.accept(FinishedRecipe.conjuration(this.id("quartz_dupe"), new ItemStack((ItemLike)Items.QUARTZ, 2), ManaInfusionProvider.ingr((ItemLike)Items.QUARTZ), 2500));
        consumer.accept(FinishedRecipe.conjuration(this.id("coal_dupe"), new ItemStack((ItemLike)Items.COAL, 2), ManaInfusionProvider.ingr((ItemLike)Items.COAL), 2100));
        consumer.accept(FinishedRecipe.conjuration(this.id("snowball_dupe"), new ItemStack((ItemLike)Items.SNOWBALL, 2), ManaInfusionProvider.ingr((ItemLike)Items.SNOWBALL), 200));
        consumer.accept(FinishedRecipe.conjuration(this.id("netherrack_dupe"), new ItemStack((ItemLike)Blocks.NETHERRACK, 2), ManaInfusionProvider.ingr((ItemLike)Blocks.NETHERRACK), 200));
        consumer.accept(FinishedRecipe.conjuration(this.id("soul_sand_dupe"), new ItemStack((ItemLike)Blocks.SOUL_SAND, 2), ManaInfusionProvider.ingr((ItemLike)Blocks.SOUL_SAND), 1500));
        consumer.accept(FinishedRecipe.conjuration(this.id("gravel_dupe"), new ItemStack((ItemLike)Blocks.GRAVEL, 2), ManaInfusionProvider.ingr((ItemLike)Blocks.GRAVEL), 720));
        consumer.accept(FinishedRecipe.conjuration(this.id("oak_leaves_dupe"), new ItemStack((ItemLike)Blocks.OAK_LEAVES, 2), ManaInfusionProvider.ingr((ItemLike)Blocks.OAK_LEAVES), 2000));
        consumer.accept(FinishedRecipe.conjuration(this.id("birch_leaves_dupe"), new ItemStack((ItemLike)Blocks.BIRCH_LEAVES, 2), ManaInfusionProvider.ingr((ItemLike)Blocks.BIRCH_LEAVES), 2000));
        consumer.accept(FinishedRecipe.conjuration(this.id("spruce_leaves_dupe"), new ItemStack((ItemLike)Blocks.SPRUCE_LEAVES, 2), ManaInfusionProvider.ingr((ItemLike)Blocks.SPRUCE_LEAVES), 2000));
        consumer.accept(FinishedRecipe.conjuration(this.id("jungle_leaves_dupe"), new ItemStack((ItemLike)Blocks.JUNGLE_LEAVES, 2), ManaInfusionProvider.ingr((ItemLike)Blocks.JUNGLE_LEAVES), 2000));
        consumer.accept(FinishedRecipe.conjuration(this.id("acacia_leaves_dupe"), new ItemStack((ItemLike)Blocks.ACACIA_LEAVES, 2), ManaInfusionProvider.ingr((ItemLike)Blocks.ACACIA_LEAVES), 2000));
        consumer.accept(FinishedRecipe.conjuration(this.id("dark_oak_leaves_dupe"), new ItemStack((ItemLike)Blocks.DARK_OAK_LEAVES, 2), ManaInfusionProvider.ingr((ItemLike)Blocks.DARK_OAK_LEAVES), 2000));
        consumer.accept(FinishedRecipe.conjuration(this.id("azalea_leaves_dupe"), new ItemStack((ItemLike)Blocks.AZALEA_LEAVES, 2), ManaInfusionProvider.ingr((ItemLike)Blocks.AZALEA_LEAVES), 2000));
        consumer.accept(FinishedRecipe.conjuration(this.id("flowering_azalea_leaves_dupe"), new ItemStack((ItemLike)Blocks.FLOWERING_AZALEA_LEAVES, 2), ManaInfusionProvider.ingr((ItemLike)Blocks.FLOWERING_AZALEA_LEAVES), 2000));
        consumer.accept(FinishedRecipe.conjuration(this.id("mangrove_leaves_dupe"), new ItemStack((ItemLike)Blocks.MANGROVE_LEAVES, 2), ManaInfusionProvider.ingr((ItemLike)Blocks.MANGROVE_LEAVES), 2000));
        consumer.accept(FinishedRecipe.conjuration(this.id("cherry_leaves_dupe"), new ItemStack((ItemLike)Blocks.CHERRY_LEAVES, 2), ManaInfusionProvider.ingr((ItemLike)Blocks.CHERRY_LEAVES), 2000));
        consumer.accept(FinishedRecipe.conjuration(this.id("grass"), new ItemStack((ItemLike)Blocks.GRASS, 2), ManaInfusionProvider.ingr((ItemLike)Blocks.GRASS), 800));
    }

    protected void cycle(Consumer<net.minecraft.data.recipes.FinishedRecipe> consumer, int cost, String group, ItemLike ... items) {
        for (int i = 0; i < items.length; ++i) {
            Ingredient in = ManaInfusionProvider.ingr(items[i]);
            ItemStack out = new ItemStack(i == items.length - 1 ? items[0] : items[i + 1]);
            String id = String.format("%s_to_%s", BuiltInRegistries.ITEM.getKey((Object)items[i].asItem()).getPath(), BuiltInRegistries.ITEM.getKey((Object)out.getItem()).getPath());
            consumer.accept(FinishedRecipe.alchemy(this.id(id), out, in, cost, group));
        }
    }

    protected FinishedRecipe mini(ItemLike mini, ItemLike full) {
        return FinishedRecipe.alchemy(this.id(BuiltInRegistries.ITEM.getKey((Object)mini.asItem()).getPath()), new ItemStack(mini), ManaInfusionProvider.ingr(full), 2500, "botania:flower_shrinking");
    }

    protected FinishedRecipe deconstruct(String id, ItemLike items, ItemLike block) {
        return FinishedRecipe.alchemy(this.id(id), new ItemStack(items, 4), ManaInfusionProvider.ingr(block), 25, "botania:block_deconstruction");
    }

    protected ResourceLocation id(String s) {
        return ResourceLocationHelper.prefix("mana_infusion/" + s);
    }

    protected static Ingredient ingr(ItemLike i) {
        return Ingredient.of((ItemLike[])new ItemLike[]{i});
    }

    protected static class FinishedRecipe
    implements net.minecraft.data.recipes.FinishedRecipe {
        private static final StateIngredient CONJURATION = StateIngredientHelper.of(BotaniaBlocks.conjurationCatalyst);
        private static final StateIngredient ALCHEMY = StateIngredientHelper.of(BotaniaBlocks.alchemyCatalyst);
        private final ResourceLocation id;
        private final Ingredient input;
        private final ItemStack output;
        private final int mana;
        private final String group;
        @Nullable
        private final StateIngredient catalyst;

        public static FinishedRecipe conjuration(ResourceLocation id, ItemStack output, Ingredient input, int mana) {
            return new FinishedRecipe(id, output, input, mana, "", CONJURATION);
        }

        public static FinishedRecipe alchemy(ResourceLocation id, ItemStack output, Ingredient input, int mana) {
            return FinishedRecipe.alchemy(id, output, input, mana, "");
        }

        public static FinishedRecipe alchemy(ResourceLocation id, ItemStack output, Ingredient input, int mana, String group) {
            return new FinishedRecipe(id, output, input, mana, group, ALCHEMY);
        }

        public FinishedRecipe(ResourceLocation id, ItemStack output, Ingredient input, int mana) {
            this(id, output, input, mana, "");
        }

        public FinishedRecipe(ResourceLocation id, ItemStack output, Ingredient input, int mana, String group) {
            this(id, output, input, mana, group, null);
        }

        public FinishedRecipe(ResourceLocation id, ItemStack output, Ingredient input, int mana, String group, @Nullable StateIngredient catalyst) {
            this.id = id;
            this.input = input;
            this.output = output;
            this.mana = mana;
            this.group = group;
            this.catalyst = catalyst;
        }

        public void serializeRecipeData(JsonObject json) {
            json.add("input", this.input.toJson());
            json.add("output", (JsonElement)ItemNBTHelper.serializeStack(this.output));
            json.addProperty("mana", (Number)this.mana);
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            if (this.catalyst != null) {
                json.add("catalyst", (JsonElement)this.catalyst.serialize());
            }
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public RecipeSerializer<?> getType() {
            return BotaniaRecipeTypes.MANA_INFUSION_SERIALIZER;
        }

        @Nullable
        public JsonObject serializeAdvancement() {
            return null;
        }

        @Nullable
        public ResourceLocation getAdvancementId() {
            return null;
        }
    }
}

