/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ImpossibleTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.advancements.AdvancementSubProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import vazkii.botania.common.advancements.AlfheimPortalBreadTrigger;
import vazkii.botania.common.advancements.AlfheimPortalTrigger;
import vazkii.botania.common.advancements.CorporeaRequestTrigger;
import vazkii.botania.common.advancements.GaiaGuardianNoArmorTrigger;
import vazkii.botania.common.advancements.LokiPlaceTrigger;
import vazkii.botania.common.advancements.ManaBlasterTrigger;
import vazkii.botania.common.advancements.RelicBindTrigger;
import vazkii.botania.common.advancements.UseItemSuccessTrigger;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class AdvancementProvider {
    public static net.minecraft.data.advancements.AdvancementProvider create(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        return new net.minecraft.data.advancements.AdvancementProvider(packOutput, lookupProvider, List.of(new BotaniaStoryAdvancements(), new BotaniaChallengeAdvancements()));
    }

    private static Advancement relicBindAdvancement(Consumer<Advancement> consumer, Advancement parent, Item relicItem, String titleKey, String criterionName) {
        String id = AdvancementProvider.challengeId(BuiltInRegistries.ITEM.getKey((Object)relicItem).getPath());
        return Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)relicItem, titleKey, FrameType.CHALLENGE)).parent(parent).rewards(AdvancementRewards.Builder.experience((int)50)).addCriterion(criterionName, (CriterionTriggerInstance)new RelicBindTrigger.Instance(ContextAwarePredicate.ANY, ItemPredicate.Builder.item().of(new ItemLike[]{relicItem}).build())).save(consumer, id);
    }

    protected static InventoryChangeTrigger.TriggerInstance onPickup(TagKey<Item> tag) {
        return InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(tag).build()});
    }

    protected static InventoryChangeTrigger.TriggerInstance onPickup(ItemLike ... items) {
        return InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{AdvancementProvider.matchItems(items)});
    }

    protected static ItemPredicate matchItems(ItemLike ... items) {
        return ItemPredicate.Builder.item().of(items).build();
    }

    protected static DisplayInfo simple(ItemLike icon, String name, FrameType frameType) {
        String expandedName = "advancement.botania:" + name;
        return new DisplayInfo(new ItemStack((ItemLike)icon.asItem()), (Component)Component.translatable((String)expandedName), (Component)Component.translatable((String)(expandedName + ".desc")), null, frameType, true, true, false);
    }

    protected static DisplayInfo hidden(ItemLike icon, String name, FrameType frameType) {
        String expandedName = "advancement.botania:" + name;
        return new DisplayInfo(new ItemStack((ItemLike)icon.asItem()), (Component)Component.translatable((String)expandedName), (Component)Component.translatable((String)(expandedName + ".desc")), null, frameType, true, true, true);
    }

    protected static DisplayInfo rootDisplay(ItemLike icon, String titleKey, String descKey, ResourceLocation background) {
        return new DisplayInfo(new ItemStack((ItemLike)icon.asItem()), (Component)Component.translatable((String)titleKey), (Component)Component.translatable((String)descKey), background, FrameType.TASK, false, false, false);
    }

    private static String mainId(String name) {
        return ResourceLocationHelper.prefix("main/" + name).toString();
    }

    private static String challengeId(String name) {
        return ResourceLocationHelper.prefix("challenge/" + name).toString();
    }

    public static class BotaniaStoryAdvancements
    implements AdvancementSubProvider {
        public void generate(HolderLookup.Provider lookup, Consumer<Advancement> consumer) {
            CompoundTag elvenLexiconUnlock = new CompoundTag();
            elvenLexiconUnlock.putBoolean("botania:elven_unlock", true);
            InventoryChangeTrigger.TriggerInstance elvenLexicon = InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(new ItemLike[]{BotaniaItems.lexicon}).hasNbt(elvenLexiconUnlock).build()});
            Advancement root = Advancement.Builder.advancement().display(AdvancementProvider.rootDisplay((ItemLike)BotaniaItems.lexicon, "itemGroup.botania", "botania.desc", ResourceLocationHelper.prefix("textures/block/livingwood_log.png"))).addCriterion("flower", (CriterionTriggerInstance)AdvancementProvider.onPickup(BotaniaTags.Items.MYSTICAL_FLOWERS)).save(consumer, AdvancementProvider.mainId("root"));
            Advancement flowerPickup = Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaBlocks.pinkFlower, "flowerPickup", FrameType.TASK)).parent(root).addCriterion("flower", (CriterionTriggerInstance)AdvancementProvider.onPickup(BotaniaTags.Items.MYSTICAL_FLOWERS)).addCriterion("double_flower", (CriterionTriggerInstance)AdvancementProvider.onPickup(BotaniaTags.Items.DOUBLE_MYSTICAL_FLOWERS)).requirements(RequirementsStrategy.OR).save(consumer, AdvancementProvider.mainId("flower_pickup"));
            Advancement manaPoolPickup = Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaBlocks.manaPool, "manaPoolPickup", FrameType.TASK)).parent(flowerPickup).addCriterion("pickup", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaBlocks.manaPool, BotaniaBlocks.creativePool, BotaniaBlocks.dilutedPool, BotaniaBlocks.fabulousPool})).save(consumer, AdvancementProvider.mainId("mana_pool_pickup"));
            Advancement runePickup = Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaBlocks.runeAltar, "runePickup", FrameType.TASK)).parent(manaPoolPickup).addCriterion("rune", (CriterionTriggerInstance)AdvancementProvider.onPickup(BotaniaTags.Items.RUNES)).save(consumer, AdvancementProvider.mainId("rune_pickup"));
            Advancement terrasteelPickup = Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.terrasteel, "terrasteelPickup", FrameType.TASK)).parent(runePickup).addCriterion("terrasteel", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaItems.terrasteel})).save(consumer, AdvancementProvider.mainId("terrasteel_pickup"));
            Advancement elfPortalOpen = Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaBlocks.alfPortal, "elfPortalOpen", FrameType.TASK)).parent(terrasteelPickup).addCriterion("portal", (CriterionTriggerInstance)new AlfheimPortalTrigger.Instance(ContextAwarePredicate.ANY, ItemPredicate.ANY, LocationPredicate.ANY)).save(consumer, AdvancementProvider.mainId("elf_portal_open"));
            Advancement gaiaGuardianKill = Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaBlocks.gaiaHead, "gaiaGuardianKill", FrameType.TASK)).parent(elfPortalOpen).addCriterion("guardian", (CriterionTriggerInstance)KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of(BotaniaEntities.DOPPLEGANGER))).save(consumer, AdvancementProvider.mainId("gaia_guardian_kill"));
            Advancement enderAirMake = Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.enderAirBottle, "enderAirMake", FrameType.TASK)).parent(elfPortalOpen).addCriterion("air", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaItems.enderAirBottle})).save(consumer, AdvancementProvider.mainId("ender_air_make"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.lexicon, "lexiconUse", FrameType.TASK)).parent(root).addCriterion("use_lexicon", (CriterionTriggerInstance)new UseItemSuccessTrigger.Instance(ContextAwarePredicate.ANY, ItemPredicate.Builder.item().of(new ItemLike[]{BotaniaItems.lexicon}).build(), LocationPredicate.ANY)).save(consumer, AdvancementProvider.mainId("lexicon_use"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.cacophonium, "cacophoniumCraft", FrameType.TASK)).parent(root).addCriterion("cacophonium", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaItems.cacophonium})).save(consumer, AdvancementProvider.mainId("cacophonium_craft"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaFlowerBlocks.endoflame, "generatingFlower", FrameType.TASK)).parent(flowerPickup).addCriterion("flower", (CriterionTriggerInstance)AdvancementProvider.onPickup(BotaniaTags.Items.GENERATING_SPECIAL_FLOWERS)).save(consumer, AdvancementProvider.mainId("generating_flower"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaBlocks.enchanter, "enchanterMake", FrameType.TASK)).parent(manaPoolPickup).addCriterion("code_triggered", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).save(consumer, AdvancementProvider.mainId("enchanter_make"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaFlowerBlocks.bellethorn, "functionalFlower", FrameType.TASK)).parent(manaPoolPickup).addCriterion("flower", (CriterionTriggerInstance)AdvancementProvider.onPickup(BotaniaTags.Items.FUNCTIONAL_SPECIAL_FLOWERS)).save(consumer, AdvancementProvider.mainId("functional_flower"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.poolMinecart, "manaCartCraft", FrameType.TASK)).parent(manaPoolPickup).addCriterion("poolcart", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaItems.poolMinecart})).save(consumer, AdvancementProvider.mainId("mana_cart_craft"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.manaweaveCloth, "manaweaveArmorCraft", FrameType.TASK)).parent(manaPoolPickup).addCriterion("head", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaItems.manaweaveHelm, BotaniaItems.manaweaveChest, BotaniaItems.manaweaveLegs, BotaniaItems.manaweaveBoots})).save(consumer, AdvancementProvider.mainId("manaweave_armor_craft"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.spark, "sparkCraft", FrameType.TASK)).parent(manaPoolPickup).addCriterion("spark", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaItems.spark})).save(consumer, AdvancementProvider.mainId("spark_craft"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.manaCookie, "manaCookieEat", FrameType.TASK)).parent(manaPoolPickup).addCriterion("cookie", (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)BotaniaItems.manaCookie)).save(consumer, AdvancementProvider.mainId("mana_cookie_eat"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.craftingHalo, "craftingHaloCraft", FrameType.TASK)).parent(manaPoolPickup).addCriterion("pool", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaItems.craftingHalo})).save(consumer, AdvancementProvider.mainId("crafting_halo_craft"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.manaRing, "baubleWear", FrameType.TASK)).parent(manaPoolPickup).addCriterion("code_triggered", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).save(consumer, AdvancementProvider.mainId("bauble_wear"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaBlocks.tinyPotato, "tinyPotatoPet", FrameType.TASK)).parent(manaPoolPickup).addCriterion("code_triggered", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).save(consumer, AdvancementProvider.mainId("tiny_potato_pet"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.manaGun, "manaBlasterShoot", FrameType.TASK)).parent(runePickup).addCriterion("shoot", (CriterionTriggerInstance)new ManaBlasterTrigger.Instance(ContextAwarePredicate.ANY, ItemPredicate.ANY, EntityPredicate.ANY)).save(consumer, AdvancementProvider.mainId("mana_blaster_shoot"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaFlowerBlocks.pollidisiac, "pollidisiacPickup", FrameType.TASK)).parent(runePickup).addCriterion("pollidisiac", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaFlowerBlocks.pollidisiac})).save(consumer, AdvancementProvider.mainId("pollidisiac_pickup"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.dirtRod, "dirtRodCraft", FrameType.TASK)).parent(runePickup).addCriterion("dirtrod", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaItems.dirtRod})).save(consumer, AdvancementProvider.mainId("dirt_rod_craft"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaBlocks.brewery, "brewPickup", FrameType.TASK)).parent(runePickup).addCriterion("pickup", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaItems.brewFlask, BotaniaItems.brewVial})).save(consumer, AdvancementProvider.mainId("brew_pickup"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.terraSword, "terrasteelWeaponCraft", FrameType.TASK)).parent(terrasteelPickup).addCriterion("terrablade", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaItems.terraSword, BotaniaItems.thornChakram})).save(consumer, AdvancementProvider.mainId("terrasteel_weapon_craft"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaFlowerBlocks.heiseiDream, "heiseiDreamPickup", FrameType.TASK)).parent(elfPortalOpen).addCriterion("heisei_dream", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaFlowerBlocks.heiseiDream})).save(consumer, AdvancementProvider.mainId("heisei_dream_pickup"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaFlowerBlocks.kekimurus, "kekimurusPickup", FrameType.TASK)).parent(elfPortalOpen).addCriterion("kekimurus", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaFlowerBlocks.kekimurus})).save(consumer, AdvancementProvider.mainId("kekimurus_pickup"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaFlowerBlocks.bubbell, "bubbellPickup", FrameType.TASK)).parent(elfPortalOpen).addCriterion("bubbell", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaFlowerBlocks.bubbell})).save(consumer, AdvancementProvider.mainId("bubbell_pickup"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.spawnerMover, "spawnerMoverUse", FrameType.TASK)).parent(gaiaGuardianKill).addCriterion("use_spawner_mover", (CriterionTriggerInstance)new UseItemSuccessTrigger.Instance(ContextAwarePredicate.ANY, ItemPredicate.Builder.item().of(new ItemLike[]{BotaniaItems.spawnerMover}).build(), LocationPredicate.ANY)).save(consumer, AdvancementProvider.mainId("spawner_mover_use"));
            DisplayInfo tiaraWings = AdvancementProvider.simple((ItemLike)BotaniaItems.flightTiara, "tiaraWings", FrameType.TASK);
            tiaraWings.getIcon().getOrCreateTag().putInt("variant", 1);
            InventoryChangeTrigger.TriggerInstance[] variants = (InventoryChangeTrigger.TriggerInstance[])IntStream.range(1, 9).mapToObj(i -> {
                CompoundTag tag = new CompoundTag();
                tag.putInt("variant", i);
                return tag;
            }).map(nbt -> ItemPredicate.Builder.item().of(new ItemLike[]{BotaniaItems.flightTiara}).hasNbt(nbt).build()).map(xva$0 -> InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{xva$0})).toArray(InventoryChangeTrigger.TriggerInstance[]::new);
            Advancement.Builder builder = Advancement.Builder.advancement().display(tiaraWings).parent(gaiaGuardianKill).requirements(RequirementsStrategy.OR);
            for (int i2 = 0; i2 < variants.length; ++i2) {
                InventoryChangeTrigger.TriggerInstance variant = variants[i2];
                builder.addCriterion("tiara_" + (i2 + 1), (CriterionTriggerInstance)variant);
            }
            builder.save(consumer, AdvancementProvider.mainId("tiara_wings"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaFlowerBlocks.dandelifeon, "dandelifeonPickup", FrameType.TASK)).parent(gaiaGuardianKill).addCriterion("dandelifeon", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaFlowerBlocks.dandelifeon})).save(consumer, AdvancementProvider.mainId("dandelifeon_pickup"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaBlocks.manaBomb, "manaBombIgnite", FrameType.TASK)).parent(gaiaGuardianKill).addCriterion("bomb", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaBlocks.manaBomb})).save(consumer, AdvancementProvider.mainId("mana_bomb_ignite"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaBlocks.lightRelayDefault, "luminizerRide", FrameType.TASK)).parent(enderAirMake).addCriterion("code_triggered", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).save(consumer, AdvancementProvider.mainId("luminizer_ride"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaBlocks.corporeaCrystalCube, "corporeaCraft", FrameType.TASK)).parent(enderAirMake).addCriterion("pickup", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaBlocks.corporeaCrystalCube, BotaniaBlocks.corporeaFunnel, BotaniaBlocks.corporeaIndex, BotaniaBlocks.corporeaInterceptor, BotaniaBlocks.corporeaRetainer})).save(consumer, AdvancementProvider.mainId("corporea_craft"));
            Advancement.Builder.advancement().parent(root).addCriterion("flower", (CriterionTriggerInstance)AdvancementProvider.onPickup(BotaniaTags.Items.MYSTICAL_FLOWERS)).addCriterion("elven_lexicon", (CriterionTriggerInstance)elvenLexicon).requirements(RequirementsStrategy.OR).save(consumer, AdvancementProvider.mainId("flower_pickup_lexicon"));
            Advancement.Builder.advancement().parent(flowerPickup).addCriterion("apothecary", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaBlocks.defaultAltar})).addCriterion("elven_lexicon", (CriterionTriggerInstance)elvenLexicon).requirements(RequirementsStrategy.OR).save(consumer, AdvancementProvider.mainId("apothecary_pickup"));
            Advancement.Builder.advancement().parent(flowerPickup).addCriterion("daisy", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaFlowerBlocks.pureDaisy})).addCriterion("elven_lexicon", (CriterionTriggerInstance)elvenLexicon).requirements(RequirementsStrategy.OR).save(consumer, AdvancementProvider.mainId("pure_daisy_pickup"));
            Advancement.Builder.advancement().parent(root).addCriterion("pickup", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaBlocks.manaPool, BotaniaBlocks.creativePool, BotaniaBlocks.dilutedPool, BotaniaBlocks.fabulousPool})).addCriterion("elven_lexicon", (CriterionTriggerInstance)elvenLexicon).requirements(RequirementsStrategy.OR).save(consumer, AdvancementProvider.mainId("mana_pool_pickup_lexicon"));
            Advancement.Builder.advancement().parent(flowerPickup).addCriterion("altar", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaBlocks.runeAltar})).addCriterion("rune", (CriterionTriggerInstance)AdvancementProvider.onPickup(BotaniaTags.Items.RUNES)).addCriterion("elven_lexicon", (CriterionTriggerInstance)elvenLexicon).requirements(RequirementsStrategy.OR).save(consumer, AdvancementProvider.mainId("runic_altar_pickup"));
            Advancement.Builder.advancement().parent(flowerPickup).addCriterion("terrasteel", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaItems.terrasteel})).addCriterion("elven_lexicon", (CriterionTriggerInstance)elvenLexicon).requirements(RequirementsStrategy.OR).save(consumer, AdvancementProvider.mainId("terrasteel_pickup_lexicon"));
            Advancement.Builder.advancement().parent(elfPortalOpen).addCriterion("lexicon", (CriterionTriggerInstance)elvenLexicon).save(consumer, AdvancementProvider.mainId("elf_lexicon_pickup"));
        }
    }

    public static class BotaniaChallengeAdvancements
    implements AdvancementSubProvider {
        private static final EntityType<?>[] LOONIUM_MOBS_TO_KILL = new EntityType[]{EntityType.BLAZE, EntityType.CAVE_SPIDER, EntityType.CREEPER, EntityType.DROWNED, EntityType.ENDERMAN, EntityType.EVOKER, EntityType.GUARDIAN, EntityType.HOGLIN, EntityType.HUSK, EntityType.PIGLIN, EntityType.PIGLIN_BRUTE, EntityType.PILLAGER, EntityType.SHULKER, EntityType.SILVERFISH, EntityType.SKELETON, EntityType.STRAY, EntityType.VINDICATOR, EntityType.WITHER_SKELETON, EntityType.ZOGLIN, EntityType.ZOMBIE_VILLAGER, EntityType.ZOMBIE, EntityType.ZOMBIFIED_PIGLIN};

        public void generate(HolderLookup.Provider lookup, Consumer<Advancement> consumer) {
            Advancement root = Advancement.Builder.advancement().display(AdvancementProvider.rootDisplay((ItemLike)BotaniaItems.dice, "advancement.botania_challenge", "advancement.botania_challenge.desc", ResourceLocationHelper.prefix("textures/block/livingrock_bricks.png"))).addCriterion("flower", (CriterionTriggerInstance)AdvancementProvider.onPickup(BotaniaTags.Items.MYSTICAL_FLOWERS)).save(consumer, AdvancementProvider.challengeId("root"));
            CompoundTag hardmodeNbt = new CompoundTag();
            hardmodeNbt.putBoolean("hardMode", true);
            Advancement hardMode = Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.lifeEssence, "gaiaGuardianHardmode", FrameType.CHALLENGE)).parent(root).rewards(AdvancementRewards.Builder.experience((int)100)).addCriterion("guardian", (CriterionTriggerInstance)KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate)EntityPredicate.Builder.entity().of(BotaniaEntities.DOPPLEGANGER).nbt(new NbtPredicate(hardmodeNbt)).build())).save(consumer, AdvancementProvider.challengeId("gaia_guardian_hardmode"));
            AdvancementProvider.relicBindAdvancement(consumer, hardMode, BotaniaItems.infiniteFruit, "infiniteFruit", "fruit");
            AdvancementProvider.relicBindAdvancement(consumer, hardMode, BotaniaItems.kingKey, "kingKey", "key");
            AdvancementProvider.relicBindAdvancement(consumer, hardMode, BotaniaItems.flugelEye, "flugelEye", "eye");
            AdvancementProvider.relicBindAdvancement(consumer, hardMode, BotaniaItems.thorRing, "thorRing", "ring");
            AdvancementProvider.relicBindAdvancement(consumer, hardMode, BotaniaItems.odinRing, "odinRing", "ring");
            Advancement lokiRing = AdvancementProvider.relicBindAdvancement(consumer, hardMode, BotaniaItems.lokiRing, "lokiRing", "ring");
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.lokiRing, "lokiRingMany", FrameType.CHALLENGE)).parent(lokiRing).rewards(AdvancementRewards.Builder.experience((int)85)).addCriterion("place_blocks", (CriterionTriggerInstance)new LokiPlaceTrigger.Instance(ContextAwarePredicate.ANY, EntityPredicate.ANY, ItemPredicate.ANY, MinMaxBounds.Ints.atLeast((int)255))).save(consumer, AdvancementProvider.challengeId("loki_ring_many"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.pinkinator, "pinkinator", FrameType.CHALLENGE)).parent(hardMode).rewards(AdvancementRewards.Builder.experience((int)40)).addCriterion("use_pinkinator", (CriterionTriggerInstance)new UseItemSuccessTrigger.Instance(ContextAwarePredicate.ANY, AdvancementProvider.matchItems(new ItemLike[]{BotaniaItems.pinkinator}), LocationPredicate.ANY)).save(consumer, AdvancementProvider.challengeId("pinkinator"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)Blocks.PLAYER_HEAD, "gaiaGuardianNoArmor", FrameType.CHALLENGE)).parent(root).rewards(AdvancementRewards.Builder.experience((int)1000)).addCriterion("no_armor", (CriterionTriggerInstance)new GaiaGuardianNoArmorTrigger.Instance(ContextAwarePredicate.ANY, EntityPredicate.ANY, DamageSourcePredicate.ANY)).save(consumer, AdvancementProvider.challengeId("gaia_guardian_no_armor"));
            Advancement.Builder.advancement().display(AdvancementProvider.hidden((ItemLike)BotaniaBlocks.motifDaybloom, "old_flower_pickup", FrameType.CHALLENGE)).parent(root).rewards(AdvancementRewards.Builder.experience((int)40)).addCriterion("flower", (CriterionTriggerInstance)AdvancementProvider.onPickup(new ItemLike[]{BotaniaBlocks.motifDaybloom, BotaniaBlocks.motifNightshade})).requirements(RequirementsStrategy.OR).save(consumer, AdvancementProvider.challengeId("old_flower_pickup"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaBlocks.corporeaIndex, "superCorporeaRequest", FrameType.CHALLENGE)).parent(root).rewards(AdvancementRewards.Builder.experience((int)85)).addCriterion("big_request", (CriterionTriggerInstance)new CorporeaRequestTrigger.Instance(ContextAwarePredicate.ANY, MinMaxBounds.Ints.atLeast((int)65536), LocationPredicate.ANY)).save(consumer, AdvancementProvider.challengeId("super_corporea_request"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.terraPick, "rankSSPick", FrameType.CHALLENGE)).parent(root).rewards(AdvancementRewards.Builder.experience((int)500)).addCriterion("code_triggered", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).save(consumer, AdvancementProvider.challengeId("rank_ss_pick"));
            CompoundTag level20Shard = new CompoundTag();
            level20Shard.putInt("level", 19);
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaItems.laputaShard, "l20ShardUse", FrameType.CHALLENGE)).parent(root).rewards(AdvancementRewards.Builder.experience((int)65)).addCriterion("use_l20_shard", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(new ItemLike[]{BotaniaItems.laputaShard}).hasNbt(level20Shard).build()})).save(consumer, AdvancementProvider.challengeId("l20_shard_use"));
            Advancement.Builder.advancement().display(AdvancementProvider.hidden((ItemLike)Items.BREAD, "alfPortalBread", FrameType.CHALLENGE)).parent(root).rewards(AdvancementRewards.Builder.experience((int)40)).addCriterion("bread", (CriterionTriggerInstance)new AlfheimPortalBreadTrigger.Instance(ContextAwarePredicate.ANY, LocationPredicate.ANY)).save(consumer, AdvancementProvider.challengeId("alf_portal_bread"));
            Advancement.Builder.advancement().display(AdvancementProvider.simple((ItemLike)BotaniaBlocks.tinyPotato, "tinyPotatoBirthday", FrameType.CHALLENGE)).parent(root).rewards(AdvancementRewards.Builder.experience((int)40)).addCriterion("code_triggered", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).save(consumer, AdvancementProvider.challengeId("tiny_potato_birthday"));
            BotaniaChallengeAdvancements.addLooniumMobsToKill(Advancement.Builder.advancement()).display(AdvancementProvider.simple((ItemLike)BotaniaFlowerBlocks.loonium, "allLooniumMobs", FrameType.CHALLENGE)).parent(root).requirements(RequirementsStrategy.AND).save(consumer, AdvancementProvider.challengeId("all_loonium_mobs"));
        }

        private static Advancement.Builder addLooniumMobsToKill(Advancement.Builder builder) {
            for (EntityType<?> entityType : LOONIUM_MOBS_TO_KILL) {
                builder.addCriterion(BuiltInRegistries.ENTITY_TYPE.getKey(entityType).toString(), (CriterionTriggerInstance)KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of(entityType).team("Loonium Monsters")));
            }
            return builder;
        }
    }
}

