/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity.mana;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;
import vazkii.botania.xplat.XplatAbstractions;

public class ManaSplitterBlockEntity
extends BotaniaBlockEntity
implements ManaReceiver {
    private final List<ManaReceiver> validPools = new ArrayList<ManaReceiver>();

    public ManaSplitterBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.DISTRIBUTOR, pos, state);
    }

    public static void serverTick(Level level, BlockPos worldPosition, BlockState state, ManaSplitterBlockEntity self) {
        self.validPools.clear();
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            ManaReceiver receiver;
            BlockPos pos = worldPosition.relative(dir);
            if (!level.hasChunkAt(pos) || !((receiver = XplatAbstractions.INSTANCE.findManaReceiver(level, pos, dir.getOpposite())) instanceof ManaPool) || receiver.isFull()) continue;
            self.validPools.add(receiver);
        }
    }

    @Override
    public Level getManaReceiverLevel() {
        return this.getLevel();
    }

    @Override
    public BlockPos getManaReceiverPos() {
        return this.getBlockPos();
    }

    @Override
    public int getCurrentMana() {
        return 0;
    }

    @Override
    public boolean isFull() {
        return this.validPools.isEmpty();
    }

    @Override
    public void receiveMana(int mana) {
        int tiles = this.validPools.size();
        if (tiles != 0) {
            int manaForEach = mana / tiles;
            for (ManaReceiver pool : this.validPools) {
                pool.receiveMana(manaForEach);
            }
        }
    }

    @Override
    public boolean canReceiveManaFromBursts() {
        return !this.isFull();
    }
}

