/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.item.material.MysticalPetalItem;
import vazkii.botania.xplat.BotaniaConfig;

public class BotaniaFlowerBlock
extends FlowerBlock
implements BonemealableBlock {
    public final DyeColor color;

    protected BotaniaFlowerBlock(DyeColor color, BlockBehaviour.Properties builder) {
        super(BotaniaFlowerBlock.effectForFlower(color), 4, builder);
        this.color = color;
    }

    private static MobEffect effectForFlower(DyeColor color) {
        return switch (color) {
            default -> throw new IncompatibleClassChangeError();
            case DyeColor.WHITE -> MobEffects.MOVEMENT_SPEED;
            case DyeColor.ORANGE -> MobEffects.FIRE_RESISTANCE;
            case DyeColor.MAGENTA -> MobEffects.DIG_SLOWDOWN;
            case DyeColor.LIGHT_BLUE -> MobEffects.JUMP;
            case DyeColor.YELLOW -> MobEffects.ABSORPTION;
            case DyeColor.LIME -> MobEffects.POISON;
            case DyeColor.PINK -> MobEffects.REGENERATION;
            case DyeColor.GRAY -> MobEffects.DAMAGE_RESISTANCE;
            case DyeColor.LIGHT_GRAY -> MobEffects.WEAKNESS;
            case DyeColor.CYAN -> MobEffects.WATER_BREATHING;
            case DyeColor.PURPLE -> MobEffects.CONFUSION;
            case DyeColor.BLUE -> MobEffects.NIGHT_VISION;
            case DyeColor.BROWN -> MobEffects.WITHER;
            case DyeColor.GREEN -> MobEffects.HUNGER;
            case DyeColor.RED -> MobEffects.DAMAGE_BOOST;
            case DyeColor.BLACK -> MobEffects.BLINDNESS;
        };
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        int hex = MysticalPetalItem.getPetalLikeColor(this.color);
        int r = (hex & 0xFF0000) >> 16;
        int g = (hex & 0xFF00) >> 8;
        int b = hex & 0xFF;
        Vec3 offset = state.getOffset((BlockGetter)world, pos);
        double x = (double)pos.getX() + offset.x;
        double y = (double)pos.getY() + offset.y;
        double z = (double)pos.getZ() + offset.z;
        if (rand.nextDouble() < BotaniaConfig.client().flowerParticleFrequency()) {
            SparkleParticleData data = SparkleParticleData.sparkle(rand.nextFloat(), (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 5);
            world.addParticle((ParticleOptions)data, x + 0.3 + (double)rand.nextFloat() * 0.5, y + 0.5 + (double)rand.nextFloat() * 0.5, z + 0.3 + (double)rand.nextFloat() * 0.5, 0.0, 0.0, 0.0);
        }
    }

    public boolean isValidBonemealTarget(@NotNull LevelReader world, @NotNull BlockPos pos, @NotNull BlockState state, boolean fuckifiknow) {
        return world.getBlockState(pos.above()).isAir();
    }

    public boolean isBonemealSuccess(@NotNull Level world, @NotNull RandomSource rand, @NotNull BlockPos pos, @NotNull BlockState state) {
        return this.isValidBonemealTarget((LevelReader)world, pos, state, false);
    }

    public void performBonemeal(@NotNull ServerLevel world, @NotNull RandomSource rand, @NotNull BlockPos pos, @NotNull BlockState state) {
        Block block = BotaniaBlocks.getDoubleFlower(this.color);
        if (block instanceof DoublePlantBlock) {
            DoublePlantBlock.placeAt((LevelAccessor)world, (BlockState)block.defaultBlockState(), (BlockPos)pos, (int)3);
        }
    }
}

