/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.loot;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.loot.BotaniaLootModifiers;

public class RealPlayerCondition
implements LootItemCondition {
    public static final RealPlayerCondition INSTANCE = new RealPlayerCondition();

    private RealPlayerCondition() {
    }

    public boolean test(LootContext lootContext) {
        Player player = (Player)lootContext.getParamOrNull(LootContextParams.LAST_DAMAGE_PLAYER);
        return PlayerHelper.isTruePlayer((Entity)player);
    }

    @NotNull
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return ImmutableSet.of((Object)LootContextParams.LAST_DAMAGE_PLAYER);
    }

    @NotNull
    public LootItemConditionType getType() {
        return BotaniaLootModifiers.KILLED_BY_REAL_PLAYER;
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<RealPlayerCondition> {
        public void serialize(@NotNull JsonObject json, @NotNull RealPlayerCondition value, @NotNull JsonSerializationContext context) {
        }

        @NotNull
        public RealPlayerCondition deserialize(@NotNull JsonObject json, @NotNull JsonDeserializationContext context) {
            return INSTANCE;
        }
    }
}

