/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.common.proxy.Proxy;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.PatchouliAPI;

public class WorldshaperssSextantItem
extends Item {
    public static final ResourceLocation MULTIBLOCK_ID = ResourceLocationHelper.prefix("sextant");
    private static final int MAX_RADIUS = 256;
    private static final String TAG_SOURCE_X = "sourceX";
    private static final String TAG_SOURCE_Y = "sourceY";
    private static final String TAG_SOURCE_Z = "sourceZ";
    private static final String TAG_MODE = "mode";

    public WorldshaperssSextantItem(Item.Properties builder) {
        super(builder);
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack) {
        return 72000;
    }

    public void onUseTick(Level world, LivingEntity living, ItemStack stack, int count) {
        if (this.getUseDuration(stack) - count < 10 || !(living instanceof Player) || !world.isClientSide) {
            return;
        }
        int x = ItemNBTHelper.getInt(stack, TAG_SOURCE_X, 0);
        int y = ItemNBTHelper.getInt(stack, TAG_SOURCE_Y, Integer.MIN_VALUE);
        int z = ItemNBTHelper.getInt(stack, TAG_SOURCE_Z, 0);
        if (y != Integer.MIN_VALUE) {
            double radius = WorldshaperssSextantItem.calculateRadius(stack, living);
            WispParticleData data = WispParticleData.wisp(0.3f, 0.0f, 1.0f, 1.0f, 1.0f);
            world.addParticle((ParticleOptions)data, (double)x + 0.5, (double)(y + 1), (double)z + 0.5, 0.0, 0.1, 0.0);
            ShapeVisualizer visualizer = WorldshaperssSextantItem.getMode(stack).getVisualizer();
            for (int i = count % 20; i < 360; i += 20) {
                float radian = (float)((double)i * Math.PI / 180.0);
                double cosR = Math.cos(radian) * radius;
                double sinR = Math.sin(radian) * radius;
                visualizer.visualize(world, x, y, z, data, cosR, sinR);
            }
        }
    }

    private static void visualizeSphere(Level world, int x, int y, int z, WispParticleData data, double cosR, double sinR) {
        world.addParticle((ParticleOptions)data, (double)x + cosR + 0.5, (double)y + 1.3, (double)z + sinR + 0.5, 0.0, 0.01, 0.0);
        world.addParticle((ParticleOptions)data, (double)x + sinR + 0.5, (double)y + cosR + 1.5, (double)z + 0.3, 0.0, 0.0, 0.01);
        world.addParticle((ParticleOptions)data, (double)x + 0.3, (double)y + sinR + 1.5, (double)z + cosR + 0.5, 0.01, 0.0, 0.0);
    }

    private static void visualizeCircle(Level world, int x, int y, int z, WispParticleData data, double cosR, double sinR) {
        world.addParticle((ParticleOptions)data, (double)x + cosR + 0.5, (double)(y + 1), (double)z + sinR + 0.5, 0.0, 0.01, 0.0);
    }

    private static void makeSphere(IStateMatcher matcher, double radius, Map<BlockPos, IStateMatcher> map) {
        int maxR2 = (int)Math.floor(radius * radius);
        int zMax = (int)Math.floor(radius);
        int x = 0;
        while (true) {
            if (x * x + zMax * zMax > maxR2 && zMax >= x) {
                --zMax;
                continue;
            }
            if (zMax < x) break;
            int z = zMax;
            int y = 0;
            while (true) {
                if (x * x + y * y + z * z > maxR2 && z >= x && z >= y) {
                    --z;
                    continue;
                }
                if (z < x || z < y) break;
                WorldshaperssSextantItem.generateMirroredPositions(x, y, z, map, matcher);
                WorldshaperssSextantItem.generateMirroredPositions(y, z, x, map, matcher);
                WorldshaperssSextantItem.generateMirroredPositions(z, x, y, map, matcher);
                ++y;
            }
            ++x;
        }
    }

    private static void generateMirroredPositions(int x, int y, int z, Map<BlockPos, IStateMatcher> map, IStateMatcher matcher) {
        Stream.of(new BlockPos(x, y, z), new BlockPos(-x, y, z), new BlockPos(x, -y, z), new BlockPos(-x, -y, z), new BlockPos(x, y, -z), new BlockPos(-x, y, -z), new BlockPos(x, -y, -z), new BlockPos(-x, -y, -z)).forEach(pos -> map.put((BlockPos)pos, matcher));
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity living, int time) {
        if (!(living instanceof Player)) {
            return;
        }
        double radius = WorldshaperssSextantItem.calculateRadius(stack, living);
        if (1.0 < radius && radius <= 256.0) {
            IStateMatcher matcher = PatchouliAPI.get().predicateMatcher(Blocks.COBBLESTONE, s -> !s.isAir());
            int x = ItemNBTHelper.getInt(stack, TAG_SOURCE_X, 0);
            int y = ItemNBTHelper.getInt(stack, TAG_SOURCE_Y, Integer.MIN_VALUE);
            int z = ItemNBTHelper.getInt(stack, TAG_SOURCE_Z, 0);
            if (y != Integer.MIN_VALUE) {
                HashMap<BlockPos, IStateMatcher> map = new HashMap<BlockPos, IStateMatcher>();
                WorldshaperssSextantItem.getMode(stack).getCreator().create(matcher, radius + 0.5, map);
                IMultiblock sparse = PatchouliAPI.get().makeSparseMultiblock(map).setId(MULTIBLOCK_ID);
                Proxy.INSTANCE.showMultiblock(sparse, (Component)Component.literal((String)("r = " + WorldshaperssSextantItem.getRadiusString(radius))), new BlockPos(x, y, z), Rotation.NONE);
            }
        }
    }

    private static void makeCircle(IStateMatcher matcher, double radius, Map<BlockPos, IStateMatcher> map) {
        int maxR2 = (int)Math.floor(radius * radius);
        int z = (int)Math.floor(radius);
        int x = 0;
        while (true) {
            if (x * x + z * z > maxR2 && z >= x) {
                --z;
                continue;
            }
            if (z < x) break;
            WorldshaperssSextantItem.generateMirroredPositions(x, z, map, matcher);
            WorldshaperssSextantItem.generateMirroredPositions(z, x, map, matcher);
            ++x;
        }
    }

    private static void generateMirroredPositions(int x, int z, Map<BlockPos, IStateMatcher> map, IStateMatcher matcher) {
        Stream.of(new BlockPos(x, 0, z), new BlockPos(-x, 0, z), new BlockPos(x, 0, -z), new BlockPos(-x, 0, -z)).forEach(pos -> map.put((BlockPos)pos, matcher));
    }

    private static Modes getMode(ItemStack stack) {
        String modeString = ItemNBTHelper.getString(stack, TAG_MODE, "circle");
        return Arrays.stream(Modes.values()).filter(m -> m.getKey().equals(modeString)).findFirst().orElse(Modes.CIRCLE);
    }

    private void reset(Level world, Player player, ItemStack stack) {
        if (ItemNBTHelper.getInt(stack, TAG_SOURCE_Y, Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            if (!world.isClientSide) {
                Modes currentMode = WorldshaperssSextantItem.getMode(stack);
                int numModes = Modes.values().length;
                int nextMode = currentMode.ordinal() + 1;
                WorldshaperssSextantItem.setMode(stack, Modes.values()[nextMode >= numModes ? 0 : nextMode]);
            } else {
                player.playSound(BotaniaSounds.ding, 0.1f, 1.0f);
            }
        } else {
            ItemNBTHelper.setInt(stack, TAG_SOURCE_Y, Integer.MIN_VALUE);
        }
        if (world.isClientSide) {
            Proxy.INSTANCE.clearSextantMultiblock();
        }
    }

    private static void setMode(ItemStack stack, Modes mode) {
        ItemNBTHelper.setString(stack, TAG_MODE, mode.getKey());
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!player.isSecondaryUseActive()) {
            BlockHitResult rtr = ToolCommons.raytraceFromEntity((Entity)player, 128.0, false);
            if (rtr.getType() == HitResult.Type.BLOCK) {
                if (!world.isClientSide) {
                    BlockPos pos = rtr.getBlockPos();
                    ItemNBTHelper.setInt(stack, TAG_SOURCE_X, pos.getX());
                    ItemNBTHelper.setInt(stack, TAG_SOURCE_Y, pos.getY());
                    ItemNBTHelper.setInt(stack, TAG_SOURCE_Z, pos.getZ());
                }
                return ItemUtils.startUsingInstantly((Level)world, (Player)player, (InteractionHand)hand);
            }
            return InteractionResultHolder.pass((Object)stack);
        }
        this.reset(world, player, stack);
        return InteractionResultHolder.success((Object)stack);
    }

    private static double calculateRadius(ItemStack stack, LivingEntity living) {
        int x = ItemNBTHelper.getInt(stack, TAG_SOURCE_X, 0);
        int y = ItemNBTHelper.getInt(stack, TAG_SOURCE_Y, Integer.MIN_VALUE);
        int z = ItemNBTHelper.getInt(stack, TAG_SOURCE_Z, 0);
        Vec3 source = new Vec3((double)x, (double)y, (double)z);
        Vec3 centerVec = VecHelper.fromEntityCenter((Entity)living);
        Vec3 diffVec = source.subtract(centerVec);
        Vec3 lookVec = living.getLookAngle();
        double mul = diffVec.y / lookVec.y;
        lookVec = lookVec.scale(mul).add(centerVec);
        lookVec = new Vec3((double)Mth.floor((double)lookVec.x), (double)Mth.floor((double)lookVec.y), (double)Mth.floor((double)lookVec.z));
        return MathHelper.pointDistancePlane(source.x, source.z, lookVec.x, lookVec.z);
    }

    public Component getName(@NotNull ItemStack stack) {
        MutableComponent mode = Component.literal((String)" (").append((Component)Component.translatable((String)WorldshaperssSextantItem.getModeString(stack))).append(")");
        return super.getName(stack).plainCopy().append((Component)mode);
    }

    public static String getModeString(ItemStack stack) {
        return "botaniamisc.sextantMode." + WorldshaperssSextantItem.getMode(stack).getKey();
    }

    private static String getRadiusString(double radius) {
        NumberFormat format = WorldshaperssSextantItem.getNumberFormat();
        return format.format(radius);
    }

    private static NumberFormat getNumberFormat() {
        NumberFormat format = NumberFormat.getInstance(Proxy.INSTANCE.getLocale());
        format.setRoundingMode(RoundingMode.HALF_UP);
        format.setMaximumFractionDigits(1);
        format.setMinimumFractionDigits(1);
        return format;
    }

    public static enum Modes {
        CIRCLE("circle", WorldshaperssSextantItem::makeCircle, WorldshaperssSextantItem::visualizeCircle),
        SPHERE("sphere", WorldshaperssSextantItem::makeSphere, WorldshaperssSextantItem::visualizeSphere);

        private final String key;
        private final ShapeCreator creator;
        private final ShapeVisualizer visualizer;

        private Modes(String key, ShapeCreator creator, ShapeVisualizer visualizer) {
            this.key = key;
            this.creator = creator;
            this.visualizer = visualizer;
        }

        public String getKey() {
            return this.key;
        }

        public ShapeCreator getCreator() {
            return this.creator;
        }

        public ShapeVisualizer getVisualizer() {
            return this.visualizer;
        }
    }

    @FunctionalInterface
    private static interface ShapeVisualizer {
        public void visualize(Level var1, int var2, int var3, int var4, WispParticleData var5, double var6, double var8);
    }

    @FunctionalInterface
    private static interface ShapeCreator {
        public void create(IStateMatcher var1, double var2, Map<BlockPos, IStateMatcher> var4);
    }

    public static class Hud {
        public static void render(GuiGraphics gui, Player player, ItemStack stack) {
            PoseStack ms = gui.pose();
            ItemStack onUse = player.getUseItem();
            int time = player.getUseItemRemainingTicks();
            if (onUse == stack && stack.getItem().getUseDuration(stack) - time >= 10) {
                boolean inRange;
                double radius = WorldshaperssSextantItem.calculateRadius(stack, (LivingEntity)player);
                Font font = Minecraft.getInstance().font;
                int x = Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2 + 30;
                int y = Minecraft.getInstance().getWindow().getGuiScaledHeight() / 2;
                Object s = WorldshaperssSextantItem.getRadiusString(radius);
                boolean bl = inRange = 0.0 < radius && radius <= 256.0;
                if (!inRange) {
                    s = ChatFormatting.RED + (String)s;
                }
                gui.drawString(font, (String)s, x - font.width((String)s) / 2, y - 4, 0xFFFFFF);
                if (inRange) {
                    radius += 4.0;
                    RenderSystem.lineWidth((float)3.0f);
                    Tesselator.getInstance().getBuilder().begin(VertexFormat.Mode.LINE_STRIP, DefaultVertexFormat.POSITION);
                    RenderSystem.setShaderColor((float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    for (int i = 0; i < 361; ++i) {
                        float radian = (float)((double)i * Math.PI / 180.0);
                        float xp = (float)x + Mth.cos((float)radian) * (float)radius;
                        float yp = (float)y + Mth.sin((float)radian) * (float)radius;
                        Tesselator.getInstance().getBuilder().vertex(ms.last().pose(), xp, yp, 0.0f).endVertex();
                    }
                    Tesselator.getInstance().end();
                }
            }
        }
    }
}

