/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.generating;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.xplat.XplatAbstractions;

public class NarslimmusBlockEntity
extends GeneratingFlowerBlockEntity {
    private static final int RANGE = 2;
    private static final int MAX_MANA = NarslimmusBlockEntity.manaForSize(4);
    public static final int MANA_BASE = 1200;
    public static final int MANA_BASE_GOG = 300;

    public NarslimmusBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.NARSLIMMUS, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.ticksExisted % 5 == 0) {
            List slimes = this.getLevel().getEntitiesOfClass(Slime.class, new AABB(this.getEffectivePos().offset(-2, -2, -2), this.getEffectivePos().offset(3, 3, 3)));
            for (Slime slime : slimes) {
                if (!slime.isAlive() || !XplatAbstractions.INSTANCE.narslimmusComponent(slime).isNaturalSpawned()) continue;
                int size = slime.getSize();
                if (!slime.level().isClientSide) {
                    slime.discard();
                    slime.playSound(size > 1 ? BotaniaSounds.narslimmusEatBig : BotaniaSounds.narslimmusEatSmall, 1.0f, 1.0f);
                    this.addMana(NarslimmusBlockEntity.manaForSize(size));
                    this.sync();
                }
                int times = 8 * (int)Math.pow(2.0, size);
                for (int j = 0; j < times; ++j) {
                    float f = slime.level().random.nextFloat() * (float)Math.PI * 2.0f;
                    float f1 = slime.level().random.nextFloat() * 0.5f + 0.5f;
                    float f2 = Mth.sin((float)f) * (float)size * 0.5f * f1;
                    float f3 = Mth.cos((float)f) * (float)size * 0.5f * f1;
                    float f4 = slime.level().random.nextFloat() * (float)size * 0.5f * f1;
                    slime.level().addParticle((ParticleOptions)ParticleTypes.ITEM_SLIME, slime.getX() + (double)f2, slime.getBoundingBox().minY + (double)f4, slime.getZ() + (double)f3, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    private static int manaForSize(int size) {
        size = Math.min(size, 4);
        return (XplatAbstractions.INSTANCE.gogLoaded() ? 300 : 1200) * (int)Math.pow(2.0, size);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 2);
    }

    @Override
    public int getMaxMana() {
        return MAX_MANA;
    }

    @Override
    public int getColor() {
        return 7455603;
    }

    public static void onSpawn(Entity entity) {
        boolean slimeChunk = NarslimmusBlockEntity.isSlimeChunk(entity.level(), entity.getX(), entity.getZ());
        if (slimeChunk) {
            entity.getSelfAndPassengers().forEach(e -> {
                if (e instanceof Slime) {
                    Slime slime = (Slime)e;
                    XplatAbstractions.INSTANCE.narslimmusComponent(slime).setNaturalSpawn(true);
                }
            });
        }
    }

    private static boolean isSlimeChunk(Level world, double x, double z) {
        return NarslimmusBlockEntity.isSlimeChunk(world, BlockPos.containing((double)x, (double)0.0, (double)z));
    }

    public static boolean isSlimeChunk(Level world, BlockPos pos) {
        ChunkPos chunkpos = new ChunkPos(pos);
        return WorldgenRandom.seedSlimeChunk((int)chunkpos.x, (int)chunkpos.z, (long)((ServerLevel)world).getSeed(), (long)987234911L).nextInt(10) == 0;
    }
}

