/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.xplat.XplatAbstractions;

public class ManastarBlockEntity
extends SpecialFlowerBlockEntity {
    private static final int SET_STATE_EVENT = 0;
    private static final int NONE = 0;
    private static final int DECREASING = 1;
    private static final int INCREASING = 2;
    private int lastMana = 0;
    private int state = 0;

    public ManastarBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.MANASTAR, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.getLevel().isClientSide) {
            if (this.state != 0 && Math.random() > 0.6) {
                float r = this.state == 2 ? 0.05f : 1.0f;
                float b = this.state == 2 ? 1.0f : 0.05f;
                WispParticleData data = WispParticleData.wisp((float)Math.random() / 7.0f, r, 0.05f, b, 1.0f);
                this.emitParticle(data, 0.5 + Math.random() * 0.2 - 0.1, 0.75 + Math.random() * 0.2 - 0.1, 0.5 + Math.random() * 0.2 - 0.1, 0.0, (float)Math.random() / 50.0f, 0.0);
            }
        } else {
            int newState;
            int mana = 0;
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                ManaReceiver receiver;
                BlockPos pos = this.getEffectivePos().relative(dir);
                if (!this.getLevel().hasChunkAt(pos) || !((receiver = XplatAbstractions.INSTANCE.findManaReceiver(this.getLevel(), pos, dir.getOpposite())) instanceof ManaPool)) continue;
                ManaPool pool = (ManaPool)receiver;
                mana += pool.getCurrentMana();
            }
            int n = mana > this.lastMana ? 2 : (newState = mana < this.lastMana ? 1 : 0);
            if (newState != this.state) {
                this.getLevel().blockEvent(this.getBlockPos(), this.getBlockState().getBlock(), 0, newState);
            }
            if (this.ticksExisted % 60 == 0) {
                this.lastMana = mana;
            }
        }
    }

    public boolean triggerEvent(int id, int param) {
        if (id == 0) {
            this.state = param;
            return true;
        }
        return super.triggerEvent(id, param);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return null;
    }
}

