/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;
import vazkii.botania.common.block.flower.functional.BubbellBlockEntity;

public class FakeAirBlockEntity
extends BotaniaBlockEntity {
    private static final String TAG_FLOWER_X = "flowerX";
    private static final String TAG_FLOWER_Y = "flowerY";
    private static final String TAG_FLOWER_Z = "flowerZ";
    private BlockPos flowerPos = ManaBurst.NO_SOURCE;

    public FakeAirBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.FAKE_AIR, pos, state);
    }

    public void setFlower(BlockEntity tile) {
        this.flowerPos = tile.getBlockPos();
        this.setChanged();
    }

    public boolean canStay() {
        return BubbellBlockEntity.isValidBubbell(this.level, this.flowerPos);
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.putInt(TAG_FLOWER_X, this.flowerPos.getX());
        tag.putInt(TAG_FLOWER_Y, this.flowerPos.getY());
        tag.putInt(TAG_FLOWER_Z, this.flowerPos.getZ());
    }

    @Override
    public void load(@NotNull CompoundTag tag) {
        super.load(tag);
        this.flowerPos = new BlockPos(tag.getInt(TAG_FLOWER_X), tag.getInt(TAG_FLOWER_Y), tag.getInt(TAG_FLOWER_Z));
    }
}

