/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;
import vazkii.botania.common.item.CacophoniumItem;

public class CacophoniumBlockEntity
extends BotaniaBlockEntity {
    private static final String TAG_STACK = "stack";
    public ItemStack stack = ItemStack.EMPTY;

    public CacophoniumBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.CACOPHONIUM, pos, state);
    }

    public void annoyDirewolf() {
        CacophoniumItem.playSound(this.level, this.stack, this.worldPosition.getX(), this.worldPosition.getY(), this.worldPosition.getZ(), SoundSource.BLOCKS, 1.0f);
        if (!this.level.isClientSide) {
            float noteColor = (float)this.level.random.nextInt(25) / 24.0f;
            ((ServerLevel)this.level).sendParticles((ParticleOptions)ParticleTypes.NOTE, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 1.2, (double)this.worldPosition.getZ() + 0.5, 0, (double)noteColor, 0.0, 0.0, 1.0);
            this.level.gameEvent(null, GameEvent.NOTE_BLOCK_PLAY, this.getBlockPos());
        }
    }

    @Override
    public void writePacketNBT(CompoundTag cmp) {
        super.writePacketNBT(cmp);
        CompoundTag cmp1 = new CompoundTag();
        if (!this.stack.isEmpty()) {
            cmp1 = this.stack.save(cmp1);
        }
        cmp.put(TAG_STACK, (Tag)cmp1);
    }

    @Override
    public void readPacketNBT(CompoundTag cmp) {
        super.readPacketNBT(cmp);
        CompoundTag cmp1 = cmp.getCompound(TAG_STACK);
        this.stack = ItemStack.of((CompoundTag)cmp1);
    }
}

