/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.test.item;

import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.CacophoniumBlockEntity;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.CacophoniumItem;
import vazkii.botania.test.TestingUtil;

public class CacophoniumTest {
    @GameTest(template="botania:block/cacophonium")
    public void testCacophonium(GameTestHelper helper) {
        BlockPos cowPos = new BlockPos(1, 2, 1);
        BlockPos noteBlockPos = new BlockPos(1, 2, 3);
        helper.assertBlockPresent(Blocks.NOTE_BLOCK, noteBlockPos);
        Player player = helper.makeMockPlayer();
        Cow cow = (Cow)helper.spawnWithNoFreeWill(EntityType.COW, cowPos);
        player.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)BotaniaItems.cacophonium));
        player.interactOn((Entity)cow, InteractionHand.MAIN_HAND);
        TestingUtil.assertEquals(CacophoniumItem.getSound(player.getMainHandItem()), SoundEvents.COW_AMBIENT);
        TestingUtil.useItemOn(helper, player, InteractionHand.MAIN_HAND, noteBlockPos);
        helper.assertBlockPresent(BotaniaBlocks.cacophonium, noteBlockPos);
        CacophoniumBlockEntity cacophoniumBlock = TestingUtil.assertBlockEntity(helper, noteBlockPos, BotaniaBlockEntities.CACOPHONIUM);
        TestingUtil.assertEqualsAt(helper, noteBlockPos, CacophoniumItem.getSound(cacophoniumBlock.stack), SoundEvents.COW_AMBIENT);
        helper.setBlock(noteBlockPos.south(), Blocks.REDSTONE_BLOCK);
        helper.assertBlockProperty(noteBlockPos, (Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(true));
        helper.succeed();
    }
}

