/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.network.serverbound;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.item.equipment.bauble.CirrusAmuletItem;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.network.BotaniaPacket;

public class JumpPacket
implements BotaniaPacket {
    public static final JumpPacket INSTANCE = new JumpPacket();
    public static final ResourceLocation ID = ResourceLocationHelper.prefix("jmp");

    @Override
    public void encode(FriendlyByteBuf buf) {
    }

    @Override
    public ResourceLocation getFabricId() {
        return ID;
    }

    public static JumpPacket decode(FriendlyByteBuf buf) {
        return INSTANCE;
    }

    public void handle(MinecraftServer server, ServerPlayer player) {
        server.execute(() -> {
            ItemStack amuletStack = EquipmentHandler.findOrEmpty(s -> s.getItem() instanceof CirrusAmuletItem, (LivingEntity)player);
            if (!amuletStack.isEmpty()) {
                player.causeFoodExhaustion(0.3f);
                player.fallDistance = 0.0f;
                CirrusAmuletItem.setJumping((Player)player);
            }
        });
    }
}

