/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;

public class InvisibilityCloakItem
extends BaubleItem {
    public InvisibilityCloakItem(Item.Properties props) {
        super(props);
    }

    @Override
    public void onUnequipped(ItemStack stack, LivingEntity living) {
        MobEffectInstance effect = living.getEffect(MobEffects.INVISIBILITY);
        if (effect != null && effect.getAmplifier() == -42) {
            living.removeEffect(MobEffects.INVISIBILITY);
        }
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.level().isClientSide) {
                int manaCost = 2;
                boolean hasMana = ManaItemHandler.instance().requestManaExact(stack, player, manaCost, true);
                if (!hasMana) {
                    this.onUnequipped(stack, (LivingEntity)player);
                } else {
                    if (player.getEffect(MobEffects.INVISIBILITY) != null) {
                        player.removeEffect(MobEffects.INVISIBILITY);
                    }
                    player.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, Integer.MAX_VALUE, -42, true, true));
                }
            }
        }
    }
}

