/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.mana.BasicLensItem;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.ControlLensItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.gui.ItemsRemainingRenderHandler;
import vazkii.botania.client.gui.TooltipHandler;
import vazkii.botania.common.advancements.ManaBlasterTrigger;
import vazkii.botania.common.entity.ManaBurstEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.proxy.Proxy;

public class ManaBlasterItem
extends Item {
    private static final String TAG_LENS = "lens";
    private static final String TAG_CLIP = "clip";
    private static final String TAG_CLIP_POS = "clipPos";
    private static final String TAG_COOLDOWN = "cooldown";
    private static final int CLIP_SLOTS = 6;
    private static final int COOLDOWN = 30;

    public ManaBlasterItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        int effCd = 30;
        MobEffectInstance effect = player.getEffect(MobEffects.DIG_SPEED);
        if (effect != null) {
            effCd = Math.max(2, 30 - (effect.getAmplifier() + 1) * 8);
        }
        if (player.isSecondaryUseActive() && ManaBlasterItem.hasClip(stack)) {
            ManaBlasterItem.rotatePos(stack);
            world.playSound(null, player.getX(), player.getY(), player.getZ(), BotaniaSounds.manaBlasterCycle, SoundSource.PLAYERS, 0.6f, (1.0f + (world.random.nextFloat() - world.random.nextFloat()) * 0.2f) * 0.7f);
            if (!world.isClientSide) {
                ItemStack lens = ManaBlasterItem.getLens(stack);
                ItemsRemainingRenderHandler.send(player, lens, -2);
                this.setCooldown(stack, effCd);
            }
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide);
        }
        if (this.getCooldown(stack) <= 0) {
            ManaBurstEntity burst = this.getBurst(player, stack, true, hand);
            if (burst != null && ManaItemHandler.instance().requestManaExact(stack, player, burst.getMana(), true)) {
                if (!world.isClientSide) {
                    world.playSound(null, player.getX(), player.getY(), player.getZ(), BotaniaSounds.manaBlaster, SoundSource.PLAYERS, 1.0f, 1.0f);
                    world.addFreshEntity((Entity)burst);
                    ManaBlasterTrigger.INSTANCE.trigger((ServerPlayer)player, stack);
                    this.setCooldown(stack, effCd);
                } else if (!EquipmentHandler.getAllWorn((LivingEntity)player).hasAnyMatching(k -> k.is(BotaniaItems.knockbackBelt))) {
                    player.setDeltaMovement(player.getDeltaMovement().subtract(burst.getDeltaMovement().multiply(0.1, 0.3, 0.1)));
                }
            } else {
                player.playSound(BotaniaSounds.manaBlasterMisfire, 0.6f, (1.0f + (world.random.nextFloat() - world.random.nextFloat()) * 0.2f) * 0.7f);
            }
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    @NotNull
    public BurstProperties getBurstProps(Player player, ItemStack stack, boolean request, InteractionHand hand) {
        int maxMana = 120;
        int color = 0x20FF20;
        int ticksBeforeManaLoss = 60;
        float manaLossPerTick = 4.0f;
        float motionModifier = 5.0f;
        float gravity = 0.0f;
        BurstProperties props = new BurstProperties(maxMana, ticksBeforeManaLoss, manaLossPerTick, gravity, motionModifier, color);
        ItemStack lens = ManaBlasterItem.getLens(stack);
        if (!lens.isEmpty()) {
            ((BasicLensItem)lens.getItem()).apply(lens, props, player.level());
        }
        return props;
    }

    private ManaBurstEntity getBurst(Player player, ItemStack stack, boolean request, InteractionHand hand) {
        ManaBurstEntity burst = new ManaBurstEntity(player);
        BurstProperties props = this.getBurstProps(player, stack, request, hand);
        burst.setSourceLens(ManaBlasterItem.getLens(stack));
        if (!request || ManaItemHandler.instance().requestManaExact(stack, player, props.maxMana, false)) {
            burst.setColor(props.color);
            burst.setMana(props.maxMana);
            burst.setStartingMana(props.maxMana);
            burst.setMinManaLoss(props.ticksBeforeManaLoss);
            burst.setManaLossPerTick(props.manaLossPerTick);
            burst.setGravity(props.gravity);
            burst.setDeltaMovement(burst.getDeltaMovement().scale((double)props.motionModifier));
            return burst;
        }
        return null;
    }

    public void appendHoverText(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flags) {
        boolean clip = ManaBlasterItem.hasClip(stack);
        if (clip) {
            TooltipHandler.addOnShift(tooltip, () -> this.appendHoverTextImpl(stack, tooltip));
        } else {
            this.appendHoverTextImpl(stack, tooltip);
        }
    }

    private void appendHoverTextImpl(ItemStack stack, List<Component> tooltip) {
        List lensTip;
        boolean clip = ManaBlasterItem.hasClip(stack);
        if (clip && !Screen.hasShiftDown()) {
            tooltip.add(TooltipHandler.getShiftInfoTooltip());
            return;
        }
        ItemStack lens = ManaBlasterItem.getLens(stack);
        if (!lens.isEmpty() && (lensTip = lens.getTooltipLines(Proxy.INSTANCE.getClientPlayer(), (TooltipFlag)TooltipFlag.Default.NORMAL)).size() > 1) {
            tooltip.addAll(lensTip.subList(1, lensTip.size()));
        }
        if (clip) {
            int pos = ManaBlasterItem.getClipPos(stack);
            tooltip.add((Component)Component.translatable((String)"botaniamisc.hasClip"));
            for (int i = 0; i < 6; ++i) {
                ItemStack lensAt = ManaBlasterItem.getLensAtPos(stack, i);
                Object name = lensAt.isEmpty() ? Component.translatable((String)"botaniamisc.clipEmpty") : lensAt.getHoverName();
                MutableComponent tip = Component.literal((String)" - ").append((Component)name);
                tip.withStyle(i == pos ? ChatFormatting.GREEN : ChatFormatting.GRAY);
                tooltip.add((Component)tip);
            }
        }
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        ItemStack lens = ManaBlasterItem.getLens(stack);
        MutableComponent cmp = super.getName(stack).copy();
        if (!lens.isEmpty()) {
            cmp.append(" (");
            cmp.append((Component)lens.getHoverName().copy().withStyle(ChatFormatting.GREEN));
            cmp.append(")");
        }
        return cmp;
    }

    public static boolean hasClip(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_CLIP, false);
    }

    public static void setClip(ItemStack stack, boolean clip) {
        ItemNBTHelper.setBoolean(stack, TAG_CLIP, clip);
    }

    public static int getClipPos(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_CLIP_POS, 0);
    }

    public static void setClipPos(ItemStack stack, int pos) {
        ItemNBTHelper.setInt(stack, TAG_CLIP_POS, pos);
    }

    public static void rotatePos(ItemStack stack) {
        int currPos = ManaBlasterItem.getClipPos(stack);
        boolean acceptEmpty = !ManaBlasterItem.getLensAtPos(stack, currPos).isEmpty();
        int[] slots = new int[5];
        int index = 0;
        int i = currPos + 1;
        while (i < 6) {
            slots[index] = i++;
            ++index;
        }
        i = 0;
        while (i < currPos) {
            slots[index] = i++;
            ++index;
        }
        for (int i2 : slots) {
            ItemStack lensAt = ManaBlasterItem.getLensAtPos(stack, i2);
            if (!acceptEmpty && lensAt.isEmpty()) continue;
            ManaBlasterItem.setClipPos(stack, i2);
            return;
        }
    }

    public static ItemStack getLensAtPos(ItemStack stack, int pos) {
        CompoundTag cmp = ItemNBTHelper.getCompound(stack, TAG_LENS + pos, true);
        if (cmp != null) {
            return ItemStack.of((CompoundTag)cmp);
        }
        return ItemStack.EMPTY;
    }

    public static void setLensAtPos(ItemStack stack, ItemStack lens, int pos) {
        CompoundTag cmp = new CompoundTag();
        if (lens != null) {
            cmp = lens.save(cmp);
        }
        ItemNBTHelper.setCompound(stack, TAG_LENS + pos, cmp);
    }

    public static void setLens(ItemStack stack, ItemStack lens) {
        if (ManaBlasterItem.hasClip(stack)) {
            ManaBlasterItem.setLensAtPos(stack, lens, ManaBlasterItem.getClipPos(stack));
        }
        CompoundTag cmp = new CompoundTag();
        if (!lens.isEmpty()) {
            cmp = lens.save(cmp);
        }
        ItemNBTHelper.setCompound(stack, TAG_LENS, cmp);
    }

    public static ItemStack getLens(ItemStack stack) {
        if (ManaBlasterItem.hasClip(stack)) {
            return ManaBlasterItem.getLensAtPos(stack, ManaBlasterItem.getClipPos(stack));
        }
        CompoundTag cmp = ItemNBTHelper.getCompound(stack, TAG_LENS, true);
        if (cmp != null) {
            return ItemStack.of((CompoundTag)cmp);
        }
        return ItemStack.EMPTY;
    }

    public static boolean isValidLens(ItemStack lens) {
        ControlLensItem control;
        Item item = lens.getItem();
        if (!(item instanceof BasicLensItem)) {
            return false;
        }
        return !(item instanceof ControlLensItem) || !(control = (ControlLensItem)item).isControlLens(lens);
    }

    public static List<ItemStack> getAllLens(ItemStack stack) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (int i = 0; i < 6; ++i) {
            ret.add(ManaBlasterItem.getLensAtPos(stack, i));
        }
        return ret;
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (this.getCooldown(stack) > 0) {
            this.setCooldown(stack, this.getCooldown(stack) - 1);
        }
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        return this.getCooldown(stack) > 0;
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round(13.0f * (1.0f - (float)this.getCooldown(stack) / 30.0f));
    }

    public int getBarColor(ItemStack stack) {
        return Mth.hsvToRgb((float)((1.0f - (float)this.getCooldown(stack) / 30.0f) / 3.0f), (float)1.0f, (float)1.0f);
    }

    private int getCooldown(ItemStack stack) {
        return stack.getOrCreateTag().getInt(TAG_COOLDOWN);
    }

    private void setCooldown(ItemStack stack, int cooldown) {
        CompoundTag tag = stack.getOrCreateTag();
        tag.putInt(TAG_COOLDOWN, cooldown);
    }
}

