/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.armor.elementium;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.mana.ManaDiscountArmor;
import vazkii.botania.common.handler.PixieHandler;
import vazkii.botania.common.item.equipment.armor.elementium.ElementiumArmorItem;

public class ElementiumHelmItem
extends ElementiumArmorItem
implements ManaDiscountArmor {
    public ElementiumHelmItem(Item.Properties props) {
        super(ArmorItem.Type.HELMET, props);
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers(@NotNull EquipmentSlot slot) {
        Multimap ret = super.getDefaultAttributeModifiers(slot);
        if (slot == this.getEquipmentSlot()) {
            ret = HashMultimap.create((Multimap)ret);
            ret.put((Object)PixieHandler.PIXIE_SPAWN_CHANCE, (Object)PixieHandler.makeModifier(slot, "Armor modifier", 0.11));
        }
        return ret;
    }

    @Override
    public float getDiscount(ItemStack stack, int slot, Player player, @Nullable ItemStack tool) {
        return this.hasArmorSet(player) ? 0.1f : 0.0f;
    }
}

