/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class EnderAirEntity
extends Entity {
    private static final String TAG_AGE = "Age";
    private static final int MAX_AGE = 60;

    public EnderAirEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && this.tickCount > 60) {
            this.discard();
        }
        if (this.level().isClientSide && this.random.nextBoolean()) {
            float r = 0.0f;
            float g = 0.0f;
            float b = 0.03137255f;
            for (int i = 0; i < 5; ++i) {
                double x = this.getX() + this.random.nextDouble();
                double y = this.getY() + this.random.nextDouble();
                double z = this.getZ() + this.random.nextDouble();
                this.level().addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.ENTITY_EFFECT, x, y, z, (double)r, (double)g, (double)b);
            }
        }
    }

    protected void defineSynchedData() {
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag tag) {
        this.tickCount = tag.getInt(TAG_AGE);
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag tag) {
        tag.putInt(TAG_AGE, this.tickCount);
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

