/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import net.minecraft.commands.CommandFunction;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.crafting.StateIngredientHelper;

public class PureDaisyRecipe
implements vazkii.botania.api.recipe.PureDaisyRecipe {
    public static final int DEFAULT_TIME = 150;
    private final ResourceLocation id;
    protected final StateIngredient input;
    protected final BlockState outputState;
    private final int time;
    private final CommandFunction.CacheableFunction function;

    public PureDaisyRecipe(ResourceLocation id, StateIngredient input, BlockState state, int time, CommandFunction.CacheableFunction function) {
        Preconditions.checkArgument((time >= 0 ? 1 : 0) != 0, (Object)"Time must be nonnegative");
        this.id = id;
        this.input = input;
        this.outputState = state;
        this.time = time;
        this.function = function;
    }

    @Override
    public boolean matches(Level world, BlockPos pos, SpecialFlowerBlockEntity pureDaisy, BlockState state) {
        return this.input.test(state) && this.outputState != state;
    }

    @Override
    public boolean set(Level world, BlockPos pos, SpecialFlowerBlockEntity pureDaisy) {
        if (!world.isClientSide) {
            boolean success = world.setBlockAndUpdate(pos, this.outputState);
            if (success) {
                ServerLevel serverLevel = (ServerLevel)world;
                MinecraftServer server = serverLevel.getServer();
                this.function.get(server.getFunctions()).ifPresent(command -> {
                    CommandSourceStack context = server.getFunctions().getGameLoopSender().withLevel((ServerLevel)world).withPosition(Vec3.atBottomCenterOf((Vec3i)pos));
                    server.getFunctions().execute(command, context);
                });
            }
            return success;
        }
        return true;
    }

    @Override
    public StateIngredient getInput() {
        return this.input;
    }

    @Override
    public BlockState getOutputState() {
        return this.outputState;
    }

    @Override
    public CommandFunction.CacheableFunction getSuccessFunction() {
        return this.function;
    }

    @Override
    public int getTime() {
        return this.time;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public RecipeSerializer<?> getSerializer() {
        return BotaniaRecipeTypes.PURE_DAISY_SERIALIZER;
    }

    public static class Serializer
    implements RecipeSerializer<PureDaisyRecipe> {
        @NotNull
        public PureDaisyRecipe fromJson(@NotNull ResourceLocation id, JsonObject object) {
            StateIngredient input = StateIngredientHelper.deserialize(GsonHelper.getAsJsonObject((JsonObject)object, (String)"input"));
            BlockState output = StateIngredientHelper.readBlockState(GsonHelper.getAsJsonObject((JsonObject)object, (String)"output"));
            int time = GsonHelper.getAsInt((JsonObject)object, (String)"time", (int)150);
            String functionIdString = GsonHelper.getAsString((JsonObject)object, (String)"success_function", null);
            ResourceLocation functionId = functionIdString == null ? null : new ResourceLocation(functionIdString);
            CommandFunction.CacheableFunction function = functionId == null ? CommandFunction.CacheableFunction.NONE : new CommandFunction.CacheableFunction(functionId);
            return new PureDaisyRecipe(id, input, output, time, function);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buf, PureDaisyRecipe recipe) {
            recipe.input.write(buf);
            buf.writeVarInt(Block.getId((BlockState)recipe.outputState));
            buf.writeVarInt(recipe.time);
        }

        @NotNull
        public PureDaisyRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
            StateIngredient input = StateIngredientHelper.read(buf);
            BlockState output = Block.stateById((int)buf.readVarInt());
            int time = buf.readVarInt();
            return new PureDaisyRecipe(id, input, output, time, CommandFunction.CacheableFunction.NONE);
        }
    }
}

