/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.Condition;
import net.minecraft.data.models.blockstates.MultiPartGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.blockstates.VariantProperty;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.block.state.properties.WallSide;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.api.state.enums.AlfheimPortalState;
import vazkii.botania.api.state.enums.CraftyCratePattern;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaDoubleFlowerBlock;
import vazkii.botania.common.block.BotaniaFlowerBlock;
import vazkii.botania.common.block.BotaniaGrassBlock;
import vazkii.botania.common.block.PetalApothecaryBlock;
import vazkii.botania.common.block.decor.BotaniaMushroomBlock;
import vazkii.botania.common.block.decor.BuriedPetalBlock;
import vazkii.botania.common.block.decor.FloatingFlowerBlock;
import vazkii.botania.common.block.decor.FlowerMotifBlock;
import vazkii.botania.common.block.decor.PetalBlock;
import vazkii.botania.common.block.decor.panes.BotaniaPaneBlock;
import vazkii.botania.common.block.red_string.RedStringBlock;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.mixin.BlockModelGeneratorsAccessor;
import vazkii.botania.mixin.TextureSlotAccessor;
import vazkii.botania.xplat.XplatAbstractions;

public class BlockstateProvider
implements DataProvider {
    protected final PackOutput packOutput;
    protected final List<BlockStateGenerator> blockstates = new ArrayList<BlockStateGenerator>();
    protected final Map<ResourceLocation, Supplier<JsonElement>> models = new HashMap<ResourceLocation, Supplier<JsonElement>>();
    protected final BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput = this.models::put;

    public BlockstateProvider(PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    protected Logger getLogger() {
        return BotaniaAPI.LOGGER;
    }

    @NotNull
    public String getName() {
        return "Botania Blockstates and Models";
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        Path path;
        try {
            this.registerStatesAndModels();
        }
        catch (Exception e) {
            this.getLogger().error("Error registering states and models", (Throwable)e);
        }
        PackOutput.PathProvider blockstatePathProvider = this.packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "blockstates");
        PackOutput.PathProvider modelPathProvider = this.packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "models");
        ArrayList<CompletableFuture> output = new ArrayList<CompletableFuture>();
        for (BlockStateGenerator blockStateGenerator : this.blockstates) {
            ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)blockStateGenerator.getBlock());
            path = blockstatePathProvider.json(id);
            output.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)((JsonElement)blockStateGenerator.get()), (Path)path));
        }
        for (Map.Entry entry : this.models.entrySet()) {
            ResourceLocation modelId = (ResourceLocation)entry.getKey();
            path = modelPathProvider.json(modelId);
            output.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)((JsonElement)((Supplier)entry.getValue()).get()), (Path)path));
        }
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    protected void registerStatesAndModels() {
        Set<Block> remainingBlocks = BuiltInRegistries.BLOCK.stream().filter(b -> "botania".equals(BuiltInRegistries.BLOCK.getKey(b).getNamespace())).collect(Collectors.toSet());
        remainingBlocks.remove(BotaniaBlocks.ghostRail);
        remainingBlocks.remove(BotaniaBlocks.solidVines);
        this.manualModel(remainingBlocks, BotaniaBlocks.cocoon);
        this.manualModel(remainingBlocks, BotaniaBlocks.corporeaCrystalCube);
        this.manualModel(remainingBlocks, BotaniaBlocks.distributor);
        this.manualModel(remainingBlocks, BotaniaBlocks.prism);
        this.manualModel(remainingBlocks, BotaniaBlocks.runeAltar);
        this.manualModel(remainingBlocks, BotaniaBlocks.spawnerClaw);
        ResourceLocation alfPortalModel = ModelTemplates.CUBE_ALL.create(ModelLocationUtils.getModelLocation((Block)BotaniaBlocks.alfPortal), TextureMapping.cube((Block)BotaniaBlocks.alfPortal), this.modelOutput);
        ResourceLocation alfPortalActivatedModel = ModelTemplates.CUBE_ALL.create(ModelLocationUtils.getModelLocation((Block)BotaniaBlocks.alfPortal, (String)"_activated"), TextureMapping.cube((ResourceLocation)ModelLocationUtils.getModelLocation((Block)BotaniaBlocks.alfPortal, (String)"_activated")), this.modelOutput);
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)BotaniaBlocks.alfPortal).with((PropertyDispatch)PropertyDispatch.property(BotaniaStateProperties.ALFPORTAL_STATE).select((Comparable)((Object)AlfheimPortalState.OFF), Variant.variant().with(VariantProperties.MODEL, (Object)alfPortalModel)).select((Comparable)((Object)AlfheimPortalState.ON_X), Variant.variant().with(VariantProperties.MODEL, (Object)alfPortalActivatedModel)).select((Comparable)((Object)AlfheimPortalState.ON_Z), Variant.variant().with(VariantProperties.MODEL, (Object)alfPortalActivatedModel))));
        remainingBlocks.remove(BotaniaBlocks.alfPortal);
        this.singleVariantBlockState(BotaniaBlocks.bifrostPerm, ModelTemplates.CUBE_ALL.create(ModelLocationUtils.getModelLocation((Block)BotaniaBlocks.bifrostPerm), TextureMapping.cube((Block)BotaniaBlocks.bifrost), this.modelOutput));
        remainingBlocks.remove(BotaniaBlocks.bifrostPerm);
        this.singleVariantBlockState(BotaniaBlocks.cacophonium, ModelTemplates.CUBE_TOP.create(BotaniaBlocks.cacophonium, new TextureMapping().put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)Blocks.NOTE_BLOCK)).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)BotaniaBlocks.cacophonium, (String)"_top")), this.modelOutput));
        remainingBlocks.remove(BotaniaBlocks.cacophonium);
        ModelTemplate crateTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/crate")), Optional.empty(), new TextureSlot[]{TextureSlot.BOTTOM, TextureSlot.SIDE});
        ResourceLocation craftCrateBottomTex = TextureMapping.getBlockTexture((Block)BotaniaBlocks.craftCrate, (String)"_bottom");
        PropertyDispatch.C1 crateDispatch = PropertyDispatch.property(BotaniaStateProperties.CRATE_PATTERN);
        for (CraftyCratePattern pattern : CraftyCratePattern.values()) {
            String suffix = pattern == CraftyCratePattern.NONE ? "" : "_" + pattern.getSerializedName().substring("crafty_".length());
            ResourceLocation model = crateTemplate.create(ModelLocationUtils.getModelLocation((Block)BotaniaBlocks.craftCrate, (String)suffix), new TextureMapping().put(TextureSlot.BOTTOM, craftCrateBottomTex).put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)BotaniaBlocks.craftCrate, (String)suffix)), this.modelOutput);
            crateDispatch = crateDispatch.select((Comparable)((Object)pattern), Variant.variant().with(VariantProperties.MODEL, (Object)model));
        }
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)BotaniaBlocks.craftCrate).with((PropertyDispatch)crateDispatch));
        remainingBlocks.remove(BotaniaBlocks.craftCrate);
        ResourceLocation corpSlabSide = ResourceLocationHelper.prefix("block/corporea_slab_side");
        ResourceLocation corpBlock = TextureMapping.getBlockTexture((Block)BotaniaBlocks.corporeaBlock);
        ResourceLocation corpSlabBottomModel = ModelTemplates.SLAB_BOTTOM.create((Block)BotaniaBlocks.corporeaSlab, new TextureMapping().put(TextureSlot.BOTTOM, corpBlock).put(TextureSlot.TOP, corpBlock).put(TextureSlot.SIDE, corpBlock), this.modelOutput);
        ResourceLocation corpSlabTopModel = ModelTemplates.SLAB_TOP.create(ModelLocationUtils.getModelLocation((Block)BotaniaBlocks.corporeaSlab, (String)"_top"), new TextureMapping().put(TextureSlot.BOTTOM, corpBlock).put(TextureSlot.TOP, corpBlock).put(TextureSlot.SIDE, corpBlock), this.modelOutput);
        ResourceLocation corpSlabDoubleModel = ModelTemplates.CUBE_BOTTOM_TOP.create(ResourceLocationHelper.prefix("block/corporea_double_slab"), new TextureMapping().put(TextureSlot.SIDE, corpSlabSide).put(TextureSlot.BOTTOM, corpBlock).put(TextureSlot.TOP, corpBlock), this.modelOutput);
        this.blockstates.add(BlockModelGeneratorsAccessor.makeSlabState((Block)BotaniaBlocks.corporeaSlab, corpSlabBottomModel, corpSlabTopModel, corpSlabDoubleModel));
        remainingBlocks.remove(BotaniaBlocks.corporeaSlab);
        this.stairsBlock(remainingBlocks, (Block)BotaniaBlocks.corporeaStairs, corpBlock, corpBlock, corpBlock);
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)BotaniaBlocks.elfGlass, (Variant[])((Variant[])IntStream.rangeClosed(0, 3).mapToObj(i -> {
            ResourceLocation model = ModelTemplates.CUBE_ALL.create(ModelLocationUtils.getModelLocation((Block)BotaniaBlocks.elfGlass, (String)("_" + i)), TextureMapping.cube((ResourceLocation)TextureMapping.getBlockTexture((Block)BotaniaBlocks.elfGlass, (String)("_" + i))), this.modelOutput);
            return Variant.variant().with(VariantProperties.MODEL, (Object)model);
        }).toArray(Variant[]::new))));
        remainingBlocks.remove(BotaniaBlocks.elfGlass);
        this.singleVariantBlockState(BotaniaBlocks.enchantedSoil, ModelTemplates.CUBE_BOTTOM_TOP.create(BotaniaBlocks.enchantedSoil, TextureMapping.cubeBottomTop((Block)BotaniaBlocks.enchantedSoil).put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)Blocks.DIRT)), this.modelOutput));
        remainingBlocks.remove(BotaniaBlocks.enchantedSoil);
        ResourceLocation pumpkinModel = ModelTemplates.CUBE_ORIENTABLE.create(BotaniaBlocks.felPumpkin, new TextureMapping().put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)Blocks.PUMPKIN, (String)"_side")).put(TextureSlot.FRONT, TextureMapping.getBlockTexture((Block)BotaniaBlocks.felPumpkin)).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)Blocks.PUMPKIN, (String)"_top")), this.modelOutput);
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)BotaniaBlocks.felPumpkin, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)pumpkinModel)).with(BlockModelGeneratorsAccessor.horizontalDispatch()));
        remainingBlocks.remove(BotaniaBlocks.felPumpkin);
        ModelTemplate eightByEightTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/eightbyeight")), Optional.empty(), new TextureSlot[]{TextureSlot.BOTTOM, TextureSlot.TOP, TextureSlot.NORTH, TextureSlot.SOUTH, TextureSlot.WEST, TextureSlot.EAST});
        this.singleVariantBlockState(BotaniaBlocks.forestEye, eightByEightTemplate.create(BotaniaBlocks.forestEye, new TextureMapping().put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)BotaniaBlocks.forestEye, (String)"_bottom")).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)BotaniaBlocks.forestEye, (String)"_top")).put(TextureSlot.NORTH, TextureMapping.getBlockTexture((Block)BotaniaBlocks.forestEye, (String)"_north")).put(TextureSlot.SOUTH, TextureMapping.getBlockTexture((Block)BotaniaBlocks.forestEye, (String)"_south")).put(TextureSlot.WEST, TextureMapping.getBlockTexture((Block)BotaniaBlocks.forestEye, (String)"_west")).put(TextureSlot.EAST, TextureMapping.getBlockTexture((Block)BotaniaBlocks.forestEye, (String)"_east")), this.modelOutput));
        remainingBlocks.remove(BotaniaBlocks.forestEye);
        ResourceLocation plateFile = ModelLocationUtils.getModelLocation((Block)BotaniaBlocks.incensePlate);
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)BotaniaBlocks.incensePlate, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)plateFile)).with(BlockModelGeneratorsAccessor.horizontalDispatch()));
        remainingBlocks.remove(BotaniaBlocks.incensePlate);
        ModelTemplate fourHighBottomTopTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/four_high_bottom_top")), Optional.empty(), new TextureSlot[]{TextureSlot.BOTTOM, TextureSlot.TOP, TextureSlot.SIDE});
        this.singleVariantBlockState(BotaniaBlocks.lightLauncher, fourHighBottomTopTemplate.create(BotaniaBlocks.lightLauncher, new TextureMapping().put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)BotaniaBlocks.lightLauncher, (String)"_end")).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)BotaniaBlocks.lightLauncher, (String)"_end")).put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)BotaniaBlocks.lightLauncher, (String)"_side")), this.modelOutput));
        remainingBlocks.remove(BotaniaBlocks.lightLauncher);
        this.singleVariantBlockState(BotaniaBlocks.openCrate, crateTemplate.create(BotaniaBlocks.openCrate, new TextureMapping().put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)BotaniaBlocks.openCrate)).put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)BotaniaBlocks.openCrate, (String)"_bottom")), this.modelOutput));
        remainingBlocks.remove(BotaniaBlocks.openCrate);
        ModelTemplate threeHighBottomTopTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/three_high_bottom_top")), Optional.empty(), new TextureSlot[]{TextureSlot.BOTTOM, TextureSlot.TOP, TextureSlot.SIDE});
        this.singleVariantBlockState(BotaniaBlocks.sparkChanger, threeHighBottomTopTemplate.create(BotaniaBlocks.sparkChanger, TextureMapping.cubeBottomTop((Block)BotaniaBlocks.sparkChanger), this.modelOutput));
        remainingBlocks.remove(BotaniaBlocks.sparkChanger);
        this.singleVariantBlockState(BotaniaBlocks.starfield, fourHighBottomTopTemplate.create(BotaniaBlocks.starfield, TextureMapping.cubeBottomTop((Block)BotaniaBlocks.starfield), this.modelOutput));
        remainingBlocks.remove(BotaniaBlocks.starfield);
        this.singleVariantBlockState(BotaniaBlocks.terraPlate, threeHighBottomTopTemplate.create(BotaniaBlocks.terraPlate, TextureMapping.cubeBottomTop((Block)BotaniaBlocks.terraPlate), this.modelOutput));
        remainingBlocks.remove(BotaniaBlocks.terraPlate);
        ModelTemplate tenByTenAllTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/tenbyten_all")), Optional.empty(), new TextureSlot[]{TextureSlot.ALL});
        this.singleVariantBlockState(BotaniaBlocks.tinyPlanet, tenByTenAllTemplate.create(BotaniaBlocks.tinyPlanet, TextureMapping.cube((Block)BotaniaBlocks.tinyPlanet), this.modelOutput));
        remainingBlocks.remove(BotaniaBlocks.tinyPlanet);
        this.singleVariantBlockState(BotaniaBlocks.turntable, ModelTemplates.CUBE_BOTTOM_TOP.create(BotaniaBlocks.turntable, TextureMapping.cubeBottomTop((Block)BotaniaBlocks.turntable), this.modelOutput));
        remainingBlocks.remove(BotaniaBlocks.turntable);
        ResourceLocation[] topTexs = new ResourceLocation[6];
        ResourceLocation[] sideTexs = new ResourceLocation[6];
        ResourceLocation[] topStrippedTexs = new ResourceLocation[6];
        ResourceLocation[] sideStrippedTexs = new ResourceLocation[6];
        ResourceLocation[] sideGlimmeringTexs = new ResourceLocation[6];
        ResourceLocation[] sideGlimmeringStrippedTexs = new ResourceLocation[6];
        ResourceLocation[] logModels = new ResourceLocation[6];
        ResourceLocation[] strippedLogModels = new ResourceLocation[6];
        for (int i2 = 0; i2 < 6; ++i2) {
            Object suffix = i2 == 0 ? "" : "_" + i2;
            sideTexs[i2] = TextureMapping.getBlockTexture((Block)BotaniaBlocks.dreamwoodLog, (String)suffix);
            topTexs[i2] = TextureMapping.getBlockTexture((Block)BotaniaBlocks.dreamwoodLog, (String)"_top");
            sideStrippedTexs[i2] = TextureMapping.getBlockTexture((Block)BotaniaBlocks.dreamwoodLogStripped, (String)suffix);
            topStrippedTexs[i2] = TextureMapping.getBlockTexture((Block)BotaniaBlocks.dreamwoodLogStripped, (String)"_top");
            sideGlimmeringTexs[i2] = TextureMapping.getBlockTexture((Block)BotaniaBlocks.dreamwoodLogGlimmering, (String)suffix);
            sideGlimmeringStrippedTexs[i2] = TextureMapping.getBlockTexture((Block)BotaniaBlocks.dreamwoodLogStrippedGlimmering, (String)suffix);
            logModels[i2] = ModelLocationUtils.getModelLocation((Block)BotaniaBlocks.dreamwood, (String)suffix);
            strippedLogModels[i2] = ModelLocationUtils.getModelLocation((Block)BotaniaBlocks.dreamwoodStripped, (String)suffix);
        }
        this.pillarWithVariants(remainingBlocks, BotaniaBlocks.dreamwoodLog, topTexs, sideTexs);
        this.pillarWithVariants(remainingBlocks, BotaniaBlocks.dreamwood, sideTexs, sideTexs);
        this.pillarWithVariants(remainingBlocks, BotaniaBlocks.dreamwoodLogStripped, topStrippedTexs, sideStrippedTexs);
        this.pillarWithVariants(remainingBlocks, BotaniaBlocks.dreamwoodStripped, sideStrippedTexs, sideStrippedTexs);
        this.pillarWithVariants(remainingBlocks, BotaniaBlocks.dreamwoodLogGlimmering, topTexs, sideGlimmeringTexs);
        this.pillarWithVariants(remainingBlocks, BotaniaBlocks.dreamwoodGlimmering, sideGlimmeringTexs, sideGlimmeringTexs);
        this.pillarWithVariants(remainingBlocks, BotaniaBlocks.dreamwoodLogStrippedGlimmering, topStrippedTexs, sideGlimmeringStrippedTexs);
        this.pillarWithVariants(remainingBlocks, BotaniaBlocks.dreamwoodStrippedGlimmering, sideGlimmeringStrippedTexs, sideGlimmeringStrippedTexs);
        this.stairsBlockWithVariants(remainingBlocks, BotaniaBlocks.dreamwoodStairs, sideTexs, sideTexs, sideTexs);
        this.stairsBlockWithVariants(remainingBlocks, BotaniaBlocks.dreamwoodStrippedStairs, sideStrippedTexs, sideStrippedTexs, sideStrippedTexs);
        this.slabBlockWithVariants(remainingBlocks, BotaniaBlocks.dreamwoodSlab, logModels, sideTexs, sideTexs, sideTexs);
        this.slabBlockWithVariants(remainingBlocks, BotaniaBlocks.dreamwoodStrippedSlab, strippedLogModels, sideStrippedTexs, sideStrippedTexs, sideStrippedTexs);
        this.wallBlockWithVariants(remainingBlocks, BotaniaBlocks.dreamwoodWall, sideTexs);
        this.wallBlockWithVariants(remainingBlocks, BotaniaBlocks.dreamwoodStrippedWall, sideStrippedTexs);
        this.pillar(remainingBlocks, BotaniaBlocks.livingwoodLog, TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodLog, (String)"_top"), TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodLog));
        this.pillar(remainingBlocks, BotaniaBlocks.livingwood, TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodLog), TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodLog));
        this.pillar(remainingBlocks, BotaniaBlocks.livingwoodLogStripped, TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodLogStripped, (String)"_top"), TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodLogStripped));
        this.pillar(remainingBlocks, BotaniaBlocks.livingwoodStripped, TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodLogStripped), TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodLogStripped));
        this.pillar(remainingBlocks, BotaniaBlocks.livingwoodLogGlimmering, TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodLog, (String)"_top"), TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodLogGlimmering));
        this.pillar(remainingBlocks, BotaniaBlocks.livingwoodGlimmering, TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodLogGlimmering), TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodLogGlimmering));
        this.pillar(remainingBlocks, BotaniaBlocks.livingwoodLogStrippedGlimmering, TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodLogStripped, (String)"_top"), TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodLogStrippedGlimmering));
        this.pillar(remainingBlocks, BotaniaBlocks.livingwoodStrippedGlimmering, TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodLogStrippedGlimmering), TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodLogStrippedGlimmering));
        this.pillarAlt(remainingBlocks, BotaniaBlocks.livingwoodFramed, TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodPatternFramed), TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodFramed));
        this.pillarAlt(remainingBlocks, BotaniaBlocks.dreamwoodFramed, TextureMapping.getBlockTexture((Block)BotaniaBlocks.dreamwoodPatternFramed), TextureMapping.getBlockTexture((Block)BotaniaBlocks.dreamwoodFramed));
        this.stairsBlock(remainingBlocks, BotaniaBlocks.livingwoodStairs, TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodLog), TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodLog), TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodLog));
        this.stairsBlock(remainingBlocks, BotaniaBlocks.livingwoodStrippedStairs, TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodLogStripped), TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodLogStripped), TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodLogStripped));
        this.slabBlock(remainingBlocks, BotaniaBlocks.livingwoodSlab, ModelLocationUtils.getModelLocation((Block)BotaniaBlocks.livingwood), TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodLog), TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodLog), TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodLog));
        this.slabBlock(remainingBlocks, BotaniaBlocks.livingwoodStrippedSlab, ModelLocationUtils.getModelLocation((Block)BotaniaBlocks.livingwoodStripped), TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodLogStripped), TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodLogStripped), TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodLogStripped));
        this.wallBlock(remainingBlocks, BotaniaBlocks.livingwoodWall, TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodLog));
        this.wallBlock(remainingBlocks, BotaniaBlocks.livingwoodStrippedWall, TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodLogStripped));
        this.fenceBlock(remainingBlocks, BotaniaBlocks.dreamwoodFence, TextureMapping.getBlockTexture((Block)BotaniaBlocks.dreamwoodPlanks));
        this.fenceGateBlock(remainingBlocks, BotaniaBlocks.dreamwoodFenceGate, TextureMapping.getBlockTexture((Block)BotaniaBlocks.dreamwoodPlanks));
        this.fenceBlock(remainingBlocks, BotaniaBlocks.livingwoodFence, TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodPlanks));
        this.fenceGateBlock(remainingBlocks, BotaniaBlocks.livingwoodFenceGate, TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodPlanks));
        this.rotatedMirrored(remainingBlocks, BotaniaBlocks.livingrock, TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingrock));
        ResourceLocation polishedLivingrockTexture = TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingrockPolished);
        ResourceLocation polishedLivingrockSlabSideTexture = TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingrockPolishedSlab);
        ResourceLocation polishedLivingrockSlabDoubleModel = ModelTemplates.CUBE_COLUMN.create(ModelLocationUtils.getModelLocation((Block)BotaniaBlocks.livingrockPolishedSlab, (String)"_double"), new TextureMapping().put(TextureSlot.SIDE, polishedLivingrockSlabSideTexture).put(TextureSlot.END, polishedLivingrockTexture), this.modelOutput);
        this.slabBlock(remainingBlocks, BotaniaBlocks.livingrockPolishedSlab, polishedLivingrockSlabDoubleModel, polishedLivingrockSlabSideTexture, polishedLivingrockTexture, polishedLivingrockTexture);
        ResourceLocation conjurationTexture = TextureMapping.getBlockTexture((Block)BotaniaBlocks.conjurationCatalyst);
        ResourceLocation conjurationMirrored = TextureMapping.getBlockTexture((Block)BotaniaBlocks.conjurationCatalyst, (String)"_mirrored");
        this.checkeredBlockWithBlockstate(remainingBlocks, BotaniaBlocks.conjurationCatalyst, conjurationTexture, conjurationMirrored);
        this.particleOnly(remainingBlocks, BotaniaBlocks.animatedTorch, TextureMapping.getBlockTexture((Block)Blocks.REDSTONE_TORCH));
        this.particleOnly(remainingBlocks, BotaniaBlocks.avatar, TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodLog));
        this.particleOnly(remainingBlocks, BotaniaBlocks.bellows, TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodLog));
        this.particleOnly(remainingBlocks, BotaniaBlocks.brewery, TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingrock));
        this.particleOnly(remainingBlocks, BotaniaBlocks.corporeaIndex, TextureMapping.getBlockTexture((Block)BotaniaBlocks.corporeaBlock));
        this.particleOnly(remainingBlocks, BotaniaBlocks.lightRelayDetector, TextureMapping.getBlockTexture((Block)BotaniaBlocks.lightRelayDetector));
        this.singleVariantBlockState(BotaniaBlocks.fakeAir, new ModelTemplate(Optional.empty(), Optional.empty(), new TextureSlot[0]).create(BotaniaBlocks.fakeAir, new TextureMapping(), this.modelOutput));
        remainingBlocks.remove(BotaniaBlocks.fakeAir);
        this.particleOnly(remainingBlocks, BotaniaBlocks.lightRelayFork, TextureMapping.getBlockTexture((Block)BotaniaBlocks.lightRelayFork));
        this.particleOnly(remainingBlocks, BotaniaBlocks.gaiaHead, TextureMapping.getBlockTexture((Block)Blocks.SOUL_SAND));
        this.particleOnly(remainingBlocks, BotaniaBlocks.gaiaHeadWall, TextureMapping.getBlockTexture((Block)Blocks.SOUL_SAND));
        this.particleOnly(remainingBlocks, BotaniaBlocks.gaiaPylon, TextureMapping.getBlockTexture((Block)BotaniaBlocks.elementiumBlock));
        this.particleOnly(remainingBlocks, BotaniaBlocks.hourglass, TextureMapping.getBlockTexture((Block)BotaniaBlocks.manaGlass));
        this.particleOnly(remainingBlocks, BotaniaBlocks.lightRelayDefault, TextureMapping.getBlockTexture((Block)BotaniaBlocks.lightRelayDefault));
        this.particleOnly(remainingBlocks, BotaniaBlocks.manaFlame, new ResourceLocation("block/fire_0"));
        this.particleOnly(remainingBlocks, BotaniaBlocks.manaPylon, TextureMapping.getBlockTexture((Block)BotaniaBlocks.manasteelBlock));
        this.particleOnly(remainingBlocks, BotaniaBlocks.naturaPylon, TextureMapping.getBlockTexture((Block)BotaniaBlocks.terrasteelBlock));
        this.particleOnly(remainingBlocks, BotaniaBlocks.teruTeruBozu, TextureMapping.getBlockTexture((Block)Blocks.WHITE_WOOL));
        this.particleOnly(remainingBlocks, BotaniaBlocks.lightRelayToggle, TextureMapping.getBlockTexture((Block)BotaniaBlocks.lightRelayToggle));
        Predicate<Block> flowers = b -> XplatAbstractions.INSTANCE.isSpecialFlowerBlock((Block)b) || b instanceof BotaniaMushroomBlock || b instanceof BotaniaFlowerBlock;
        ModelTemplate crossTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/cross")), Optional.empty(), new TextureSlot[]{TextureSlot.CROSS});
        this.takeAll(remainingBlocks, flowers).forEach(b -> this.singleVariantBlockState((Block)b, crossTemplate.create(b, TextureMapping.cross((Block)b), this.modelOutput)));
        this.takeAll(remainingBlocks, b -> b instanceof FlowerMotifBlock).forEach(b -> {
            String name = BuiltInRegistries.BLOCK.getKey(b).getPath().replace("_motif", "");
            this.singleVariantBlockState((Block)b, crossTemplate.create(b, new TextureMapping().put(TextureSlot.CROSS, ResourceLocationHelper.prefix("block/" + name)), this.modelOutput));
        });
        this.takeAll(remainingBlocks, BotaniaBlocks.corporeaFunnel, BotaniaBlocks.corporeaInterceptor, BotaniaBlocks.corporeaRetainer).forEach(b -> this.singleVariantBlockState((Block)b, ModelTemplates.CUBE_COLUMN.create(b, TextureMapping.column((ResourceLocation)TextureMapping.getBlockTexture((Block)b, (String)"_side"), (ResourceLocation)TextureMapping.getBlockTexture((Block)b, (String)"_end")), this.modelOutput)));
        ModelTemplate drumModelTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/drum")), Optional.empty(), new TextureSlot[]{TextureSlot.TOP, TextureSlot.SIDE});
        this.takeAll(remainingBlocks, BotaniaBlocks.gatheringDrum, BotaniaBlocks.canopyDrum, BotaniaBlocks.wildDrum).forEach(b -> this.singleVariantBlockState((Block)b, drumModelTemplate.create(b, new TextureMapping().put(TextureSlot.TOP, ResourceLocationHelper.prefix("block/drum_top")).put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)b)), this.modelOutput)));
        TextureSlot outsideSlot = TextureSlotAccessor.make("outside");
        TextureSlot coreSlot = TextureSlotAccessor.make("core");
        ModelTemplate spreaderTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/spreader")), Optional.empty(), new TextureSlot[]{TextureSlot.SIDE, TextureSlot.BACK, TextureSlot.INSIDE, outsideSlot});
        ModelTemplate spreaderCoreTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/spreader_core")), Optional.of("_core"), new TextureSlot[]{coreSlot});
        ModelTemplate spreaderPaddingTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/spreader_padding")), Optional.empty(), new TextureSlot[]{TextureSlot.FRONT, TextureSlot.BACK, TextureSlot.SIDE});
        ModelTemplate spreaderScaffoldingTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/spreader_scaffolding")), Optional.of("_scaffolding"), new TextureSlot[]{TextureSlot.TOP, TextureSlot.SIDE, TextureSlot.BOTTOM});
        this.takeAll(remainingBlocks, BotaniaBlocks.manaSpreader, BotaniaBlocks.redstoneSpreader, BotaniaBlocks.gaiaSpreader, BotaniaBlocks.elvenSpreader).forEach(b -> {
            ResourceLocation outside = b == BotaniaBlocks.redstoneSpreader || b == BotaniaBlocks.manaSpreader ? TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodLog) : (b == BotaniaBlocks.elvenSpreader ? TextureMapping.getBlockTexture((Block)BotaniaBlocks.dreamwoodLog, (String)"_3") : TextureMapping.getBlockTexture((Block)b, (String)"_outside"));
            ResourceLocation inside = b == BotaniaBlocks.redstoneSpreader || b == BotaniaBlocks.manaSpreader ? TextureMapping.getBlockTexture((Block)BotaniaBlocks.livingwoodLogStripped) : (b == BotaniaBlocks.elvenSpreader ? TextureMapping.getBlockTexture((Block)BotaniaBlocks.dreamwoodLogStripped, (String)"_3") : TextureMapping.getBlockTexture((Block)b, (String)"_inside"));
            this.singleVariantBlockState((Block)b, spreaderTemplate.create(b, new TextureMapping().put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)b, (String)"_side")).put(TextureSlot.BACK, TextureMapping.getBlockTexture((Block)b, (String)"_back")).put(TextureSlot.INSIDE, inside).put(outsideSlot, outside), this.modelOutput));
            spreaderCoreTemplate.create(b, new TextureMapping().put(coreSlot, TextureMapping.getBlockTexture((Block)b, (String)"_core")), this.modelOutput);
            if (b != BotaniaBlocks.redstoneSpreader) {
                spreaderScaffoldingTemplate.create(b, new TextureMapping().put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)b, (String)"_scaffolding_top")).put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)b, (String)"_scaffolding_side")).put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)b, (String)"_scaffolding_bottom")), this.modelOutput);
            }
        });
        ColorHelper.supportedColors().forEach(color -> {
            Block wool = ColorHelper.WOOL_MAP.apply((DyeColor)color);
            spreaderPaddingTemplate.create(ResourceLocationHelper.prefix("block/" + color.getName() + "_spreader_padding"), new TextureMapping().put(TextureSlot.FRONT, TextureMapping.getBlockTexture((Block)wool)).put(TextureSlot.BACK, TextureMapping.getBlockTexture((Block)wool)).put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)wool)), this.modelOutput);
        });
        TextureSlot manaSlot = TextureSlotAccessor.make("mana");
        TextureSlot[] manaPoolSlots = new TextureSlot[]{TextureSlot.SIDE, TextureSlot.TOP, TextureSlot.BOTTOM, TextureSlot.INSIDE};
        TextureSlot[] manaPoolFullSlots = new TextureSlot[]{TextureSlot.SIDE, TextureSlot.TOP, TextureSlot.BOTTOM, TextureSlot.INSIDE, manaSlot};
        ModelTemplate poolTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/mana_pool")), Optional.empty(), manaPoolSlots);
        ModelTemplate dilutedPoolTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/diluted_mana_pool")), Optional.empty(), manaPoolSlots);
        ModelTemplate creativePoolTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/creative_mana_pool")), Optional.empty(), manaPoolSlots);
        ModelTemplate poolFullTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/mana_pool_full")), Optional.of("_full"), manaPoolFullSlots);
        ModelTemplate dilutedPoolFullTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/diluted_mana_pool_full")), Optional.of("_full"), manaPoolFullSlots);
        ModelTemplate creativePoolFullTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/creative_mana_pool_full")), Optional.of("_full"), manaPoolFullSlots);
        this.takeAll(remainingBlocks, BotaniaBlocks.manaPool, BotaniaBlocks.dilutedPool, BotaniaBlocks.fabulousPool, BotaniaBlocks.creativePool).forEach(b -> {
            ModelTemplate template;
            Block blockForTexture = b == BotaniaBlocks.fabulousPool ? BotaniaBlocks.manaPool : b;
            ResourceLocation side = TextureMapping.getBlockTexture((Block)blockForTexture, (String)"_side");
            ResourceLocation top = TextureMapping.getBlockTexture((Block)blockForTexture, (String)"_top");
            ResourceLocation bottom = b == BotaniaBlocks.dilutedPool ? TextureMapping.getBlockTexture((Block)BotaniaBlocks.manaPool, (String)"_bottom") : TextureMapping.getBlockTexture((Block)blockForTexture, (String)"_bottom");
            ResourceLocation inside = TextureMapping.getBlockTexture((Block)blockForTexture, (String)"_inside");
            ModelTemplate modelTemplate = b == BotaniaBlocks.dilutedPool ? dilutedPoolTemplate : (template = b == BotaniaBlocks.creativePool ? creativePoolTemplate : poolTemplate);
            ModelTemplate fullTemplate = b == BotaniaBlocks.dilutedPool ? dilutedPoolFullTemplate : (b == BotaniaBlocks.creativePool ? creativePoolFullTemplate : poolFullTemplate);
            TextureMapping mapping = new TextureMapping().put(TextureSlot.SIDE, side).put(TextureSlot.TOP, top).put(TextureSlot.BOTTOM, bottom).put(TextureSlot.INSIDE, inside);
            this.singleVariantBlockState((Block)b, template.create(b, mapping, this.modelOutput));
            fullTemplate.create(b, mapping.put(manaSlot, ResourceLocationHelper.prefix("block/mana_water")), this.modelOutput);
        });
        this.takeAll(remainingBlocks, BotaniaBlocks.pump, BotaniaBlocks.tinyPotato).forEach(b -> this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)b, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)ModelLocationUtils.getModelLocation((Block)b))).with(BlockModelGeneratorsAccessor.horizontalDispatch())));
        this.takeAll(remainingBlocks, BotaniaBlocks.enderEye, BotaniaBlocks.manaDetector).forEach(b -> {
            ResourceLocation offModel = ModelTemplates.CUBE_ALL.create(b, TextureMapping.cube((Block)b), this.modelOutput);
            ResourceLocation onModel = ModelTemplates.CUBE_ALL.create(ModelLocationUtils.getModelLocation((Block)b, (String)"_powered"), TextureMapping.cube((ResourceLocation)TextureMapping.getBlockTexture((Block)b, (String)"_powered")), this.modelOutput);
            this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)b).with((PropertyDispatch)PropertyDispatch.property((Property)BlockStateProperties.POWERED).select((Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)offModel)).select((Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)onModel))));
        });
        ResourceLocation petalBlockModel = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/cube_all_tinted")), Optional.empty(), new TextureSlot[]{TextureSlot.ALL}).create(ResourceLocationHelper.prefix("block/petal_block"), new TextureMapping().put(TextureSlot.ALL, ResourceLocationHelper.prefix("block/petal_block")), this.modelOutput);
        this.takeAll(remainingBlocks, b -> b instanceof PetalBlock).forEach(b -> this.singleVariantBlockState((Block)b, petalBlockModel));
        this.takeAll(remainingBlocks, b -> b instanceof BotaniaGrassBlock).forEach(b -> {
            ResourceLocation model = ModelTemplates.CUBE_BOTTOM_TOP.create(b, new TextureMapping().put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)b, (String)"_side")).put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)Blocks.DIRT)).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)b, (String)"_top")), this.modelOutput);
            this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)b, (Variant[])BlockModelGeneratorsAccessor.createRotatedVariants(model)));
        });
        this.takeAll(remainingBlocks, b -> b instanceof RedStringBlock).forEach(this::redStringBlock);
        this.takeAll(remainingBlocks, b -> b instanceof BotaniaDoubleFlowerBlock).forEach(b -> {
            ResourceLocation bottom = ModelTemplates.CROSS.create(b, TextureMapping.cross((Block)b), this.modelOutput);
            ResourceLocation top = ModelTemplates.CROSS.create(ModelLocationUtils.getModelLocation((Block)b, (String)"_top"), TextureMapping.cross((ResourceLocation)TextureMapping.getBlockTexture((Block)b, (String)"_top")), this.modelOutput);
            this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)b).with((PropertyDispatch)PropertyDispatch.property((Property)TallFlowerBlock.HALF).select((Comparable)DoubleBlockHalf.LOWER, Variant.variant().with(VariantProperties.MODEL, (Object)bottom)).select((Comparable)DoubleBlockHalf.UPPER, Variant.variant().with(VariantProperties.MODEL, (Object)top))));
        });
        ResourceLocation[] mountainTextures = new ResourceLocation[]{TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeStoneMountain), TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeStoneMountain, (String)"_1")};
        ResourceLocation[] mountainModels = new ResourceLocation[]{ModelLocationUtils.getModelLocation((Block)BotaniaBlocks.biomeStoneMountain), ModelLocationUtils.getModelLocation((Block)BotaniaBlocks.biomeStoneMountain, (String)"_1")};
        Integer[] mountainWeights = new Integer[]{5, 1};
        this.rotatedMirroredWithVariants(remainingBlocks, BotaniaBlocks.biomeStoneMountain, mountainTextures, mountainWeights);
        this.stairsBlockWithVariants(remainingBlocks, BotaniaBlocks.biomeStoneMountainStairs, mountainTextures, mountainTextures, mountainTextures, mountainWeights);
        this.slabBlockWithVariants(remainingBlocks, BotaniaBlocks.biomeStoneMountainSlab, mountainModels, mountainTextures, mountainTextures, mountainTextures, mountainWeights);
        this.wallBlockWithVariants(remainingBlocks, BotaniaBlocks.biomeStoneMountainWall, mountainTextures, mountainWeights);
        ResourceLocation[] mountainBrickTextures = new ResourceLocation[]{TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeBrickMountain), TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeBrickMountain, (String)"_1"), TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeBrickMountain, (String)"_2"), TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeBrickMountain, (String)"_3"), TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeBrickMountain, (String)"_4"), TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeBrickMountain, (String)"_5")};
        ResourceLocation[] mountainBrickModels = new ResourceLocation[]{ModelLocationUtils.getModelLocation((Block)BotaniaBlocks.biomeBrickMountain), ModelLocationUtils.getModelLocation((Block)BotaniaBlocks.biomeBrickMountain, (String)"_1"), ModelLocationUtils.getModelLocation((Block)BotaniaBlocks.biomeBrickMountain, (String)"_2"), ModelLocationUtils.getModelLocation((Block)BotaniaBlocks.biomeBrickMountain, (String)"_3"), ModelLocationUtils.getModelLocation((Block)BotaniaBlocks.biomeBrickMountain, (String)"_4"), ModelLocationUtils.getModelLocation((Block)BotaniaBlocks.biomeBrickMountain, (String)"_5")};
        this.cubeAllWithVariants(remainingBlocks, BotaniaBlocks.biomeBrickMountain, mountainBrickTextures);
        this.stairsBlockWithVariants(remainingBlocks, BotaniaBlocks.biomeBrickMountainStairs, mountainBrickTextures, mountainBrickTextures, mountainBrickTextures);
        this.slabBlockWithVariants(remainingBlocks, BotaniaBlocks.biomeBrickMountainSlab, mountainBrickModels, mountainBrickTextures, mountainBrickTextures, mountainBrickTextures);
        this.wallBlockWithVariants(remainingBlocks, BotaniaBlocks.biomeBrickMountainWall, mountainBrickTextures);
        ResourceLocation[] taigaTextures = new ResourceLocation[]{TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeStoneTaiga), TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeStoneTaiga, (String)"_1")};
        ResourceLocation[] taigaModels = new ResourceLocation[]{ModelLocationUtils.getModelLocation((Block)BotaniaBlocks.biomeStoneTaiga), ModelLocationUtils.getModelLocation((Block)BotaniaBlocks.biomeStoneTaiga, (String)"_1")};
        this.rotatedMirroredWithVariants(remainingBlocks, BotaniaBlocks.biomeStoneTaiga, taigaTextures);
        this.stairsBlockWithVariants(remainingBlocks, BotaniaBlocks.biomeStoneTaigaStairs, taigaTextures, taigaTextures, taigaTextures);
        this.slabBlockWithVariants(remainingBlocks, BotaniaBlocks.biomeStoneTaigaSlab, taigaModels, taigaTextures, taigaTextures, taigaTextures);
        this.wallBlockWithVariants(remainingBlocks, BotaniaBlocks.biomeStoneTaigaWall, taigaTextures);
        ResourceLocation plainsBrickSide = TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeBrickPlains);
        ResourceLocation plainsBrickTop = TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeBrickPlains, (String)"_top");
        this.pillarAlt(remainingBlocks, BotaniaBlocks.biomeBrickPlains, plainsBrickTop, plainsBrickSide);
        this.stairsBlock(remainingBlocks, BotaniaBlocks.biomeBrickPlainsStairs, plainsBrickSide, plainsBrickTop, plainsBrickTop);
        this.slabBlock(remainingBlocks, BotaniaBlocks.biomeBrickPlainsSlab, ModelLocationUtils.getModelLocation((Block)BotaniaBlocks.biomeBrickPlains), plainsBrickSide, plainsBrickTop, plainsBrickTop);
        this.wallBlock(remainingBlocks, BotaniaBlocks.biomeBrickPlainsWall, plainsBrickSide, plainsBrickTop, plainsBrickTop);
        ResourceLocation[] forestBrickTextures = new ResourceLocation[]{TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeBrickForest), TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeBrickForest, (String)"_1")};
        ResourceLocation[] forestBrickModels = new ResourceLocation[]{ModelLocationUtils.getModelLocation((Block)BotaniaBlocks.biomeBrickForest), ModelLocationUtils.getModelLocation((Block)BotaniaBlocks.biomeBrickForest, (String)"_1")};
        Integer[] forestBrickWeights = new Integer[]{2, 1};
        this.cubeAllWithVariants(remainingBlocks, BotaniaBlocks.biomeBrickForest, forestBrickTextures, forestBrickWeights);
        this.stairsBlockWithVariants(remainingBlocks, BotaniaBlocks.biomeBrickForestStairs, forestBrickTextures, forestBrickTextures, forestBrickTextures, forestBrickWeights);
        this.slabBlockWithVariants(remainingBlocks, BotaniaBlocks.biomeBrickForestSlab, forestBrickModels, forestBrickTextures, forestBrickTextures, forestBrickTextures, forestBrickWeights);
        this.wallBlockWithVariants(remainingBlocks, BotaniaBlocks.biomeBrickForestWall, forestBrickTextures, forestBrickWeights);
        ResourceLocation[] fungalBrickTextures = new ResourceLocation[]{TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeBrickFungal), TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeBrickFungal, (String)"_1")};
        ResourceLocation[] fungalBrickModels = new ResourceLocation[]{ModelLocationUtils.getModelLocation((Block)BotaniaBlocks.biomeBrickFungal), ModelLocationUtils.getModelLocation((Block)BotaniaBlocks.biomeBrickFungal, (String)"_1")};
        this.cubeAllWithVariants(remainingBlocks, BotaniaBlocks.biomeBrickFungal, fungalBrickTextures);
        this.stairsBlockWithVariants(remainingBlocks, BotaniaBlocks.biomeBrickFungalStairs, fungalBrickTextures, fungalBrickTextures, fungalBrickTextures);
        this.slabBlockWithVariants(remainingBlocks, BotaniaBlocks.biomeBrickFungalSlab, fungalBrickModels, fungalBrickTextures, fungalBrickTextures, fungalBrickTextures);
        this.wallBlockWithVariants(remainingBlocks, BotaniaBlocks.biomeBrickFungalWall, fungalBrickTextures);
        ResourceLocation[] swampBrickTopTextures = new ResourceLocation[]{TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeBrickSwamp, (String)"_top"), TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeBrickSwamp, (String)"_top_1")};
        ResourceLocation[] swampBrickBottomTextures = new ResourceLocation[]{TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeBrickSwamp, (String)"_bottom"), TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeBrickSwamp, (String)"_bottom")};
        ResourceLocation[] swampBrickSideTextures = new ResourceLocation[]{TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeBrickSwamp), TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeBrickSwamp)};
        ResourceLocation[] swampBrickModels = new ResourceLocation[]{ModelLocationUtils.getModelLocation((Block)BotaniaBlocks.biomeBrickSwamp), ModelLocationUtils.getModelLocation((Block)BotaniaBlocks.biomeBrickSwamp, (String)"_1")};
        this.directionalPillarWithVariants(remainingBlocks, BotaniaBlocks.biomeBrickSwamp, swampBrickTopTextures, swampBrickBottomTextures, swampBrickSideTextures);
        this.stairsBlockWithVariants(remainingBlocks, BotaniaBlocks.biomeBrickSwampStairs, swampBrickSideTextures, swampBrickBottomTextures, swampBrickTopTextures);
        this.slabBlockWithVariants(remainingBlocks, BotaniaBlocks.biomeBrickSwampSlab, swampBrickModels, swampBrickSideTextures, swampBrickBottomTextures, swampBrickTopTextures);
        this.wallBlockWithVariants(remainingBlocks, BotaniaBlocks.biomeBrickSwampWall, swampBrickSideTextures, swampBrickBottomTextures, swampBrickTopTextures);
        ResourceLocation[] swampChiseledBrickTopTextures = new ResourceLocation[]{TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeChiseledBrickSwamp, (String)"_top"), TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeChiseledBrickSwamp, (String)"_top_1")};
        ResourceLocation[] swampChiseledBrickBottomTextures = new ResourceLocation[]{TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeChiseledBrickSwamp, (String)"_bottom"), TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeChiseledBrickSwamp, (String)"_bottom")};
        ResourceLocation[] swampChiseledBrickSideTextures = new ResourceLocation[]{TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeChiseledBrickSwamp), TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeChiseledBrickSwamp)};
        this.directionalPillarWithVariants(remainingBlocks, BotaniaBlocks.biomeChiseledBrickSwamp, swampChiseledBrickTopTextures, swampChiseledBrickBottomTextures, swampChiseledBrickSideTextures);
        ResourceLocation[] swampCobblestoneTextures = new ResourceLocation[]{TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeCobblestoneSwamp), TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeCobblestoneSwamp, (String)"_1")};
        ResourceLocation[] swampCobblestoneModels = new ResourceLocation[]{ModelLocationUtils.getModelLocation((Block)BotaniaBlocks.biomeCobblestoneSwamp), ModelLocationUtils.getModelLocation((Block)BotaniaBlocks.biomeCobblestoneSwamp, (String)"_1")};
        this.cubeAllWithVariants(remainingBlocks, BotaniaBlocks.biomeCobblestoneSwamp, swampCobblestoneTextures);
        this.stairsBlockWithVariants(remainingBlocks, BotaniaBlocks.biomeCobblestoneSwampStairs, swampCobblestoneTextures, swampCobblestoneTextures, swampCobblestoneTextures);
        this.slabBlockWithVariants(remainingBlocks, BotaniaBlocks.biomeCobblestoneSwampSlab, swampCobblestoneModels, swampCobblestoneTextures, swampCobblestoneTextures, swampCobblestoneTextures);
        this.wallBlockWithVariants(remainingBlocks, BotaniaBlocks.biomeCobblestoneSwampWall, swampCobblestoneTextures);
        ResourceLocation mesaBrick = TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeBrickMesa);
        ResourceLocation mesaBrickMirrored = TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeBrickMesa, (String)"_mirrored");
        ResourceLocation mesaBrickModel = this.checkeredBlockWithBlockstate(remainingBlocks, BotaniaBlocks.biomeBrickMesa, mesaBrick, mesaBrickMirrored);
        this.checkeredSlabBlock(remainingBlocks, BotaniaBlocks.biomeBrickMesaSlab, mesaBrickModel, mesaBrick, mesaBrickMirrored);
        this.checkeredStairsBlock(remainingBlocks, BotaniaBlocks.biomeBrickMesaStairs, mesaBrick, mesaBrickMirrored);
        this.checkeredWallBlock(remainingBlocks, BotaniaBlocks.biomeBrickMesaWall, mesaBrick, mesaBrickMirrored);
        ResourceLocation mesaChiseledBrickSide = TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeChiseledBrickMesa);
        ResourceLocation mesaChiseledBrickTop = TextureMapping.getBlockTexture((Block)BotaniaBlocks.biomeChiseledBrickMesa, (String)"_top");
        this.pillarAlt(remainingBlocks, BotaniaBlocks.biomeChiseledBrickMesa, mesaChiseledBrickTop, mesaChiseledBrickSide);
        for (Block block : new Block[]{BotaniaBlocks.biomeStoneDesert, BotaniaBlocks.biomeStoneForest, BotaniaBlocks.biomeStoneFungal, BotaniaBlocks.biomeStoneMesa, BotaniaBlocks.biomeStonePlains, BotaniaBlocks.biomeStoneSwamp}) {
            this.rotatedMirrored(remainingBlocks, block, TextureMapping.getBlockTexture((Block)block));
        }
        for (String string : new String[]{"dark", "mana", "blaze", "lavender", "red", "elf", "sunny"}) {
            ResourceLocation quartzId = ResourceLocationHelper.prefix(string + "_quartz");
            Block quartz = (Block)BuiltInRegistries.BLOCK.get(quartzId);
            this.singleVariantBlockState(quartz, ModelTemplates.CUBE_BOTTOM_TOP.create(quartz, TextureMapping.cubeBottomTop((Block)quartz), this.modelOutput));
            ResourceLocation pillarId = ResourceLocationHelper.prefix(string + "_quartz_pillar");
            Block pillar = (Block)BuiltInRegistries.BLOCK.get(pillarId);
            ResourceLocation pillarModel = ModelTemplates.CUBE_COLUMN.create(pillar, TextureMapping.column((ResourceLocation)TextureMapping.getBlockTexture((Block)pillar, (String)"_side"), (ResourceLocation)TextureMapping.getBlockTexture((Block)pillar, (String)"_end")), this.modelOutput);
            this.blockstates.add(BlockModelGeneratorsAccessor.createAxisAlignedPillarBlock(pillar, pillarModel));
            ResourceLocation chiseledId = ResourceLocationHelper.prefix("chiseled_" + string + "_quartz");
            Block chiseled = (Block)BuiltInRegistries.BLOCK.get(chiseledId);
            this.singleVariantBlockState(chiseled, ModelTemplates.CUBE_COLUMN.create(chiseled, new TextureMapping().put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)chiseled, (String)"_side")).put(TextureSlot.END, TextureMapping.getBlockTexture((Block)chiseled, (String)"_end")), this.modelOutput));
            remainingBlocks.remove(quartz);
            remainingBlocks.remove(pillar);
            remainingBlocks.remove(chiseled);
        }
        this.takeAll(remainingBlocks, b -> b instanceof BuriedPetalBlock).forEach(b -> {
            DyeColor color = ((BuriedPetalBlock)b).color;
            ResourceLocation wool = new ResourceLocation("block/" + color.getSerializedName() + "_wool");
            this.particleOnly(remainingBlocks, (Block)b, wool);
        });
        ModelTemplate modelTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/petal_apothecary")), Optional.empty(), new TextureSlot[]{TextureSlot.SIDE, TextureSlot.TOP, TextureSlot.BOTTOM});
        this.takeAll(remainingBlocks, b -> b instanceof PetalApothecaryBlock).forEach(b -> this.singleVariantBlockState((Block)b, apothecaryTemplate.create(b, new TextureMapping().put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)b, (String)"_side")).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)b, (String)"_top")).put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)b, (String)"_bottom")), this.modelOutput)));
        this.takeAll(remainingBlocks, b -> b instanceof FloatingFlowerBlock || b instanceof FlowerPotBlock).forEach(b -> this.singleVariantBlockState((Block)b, ModelLocationUtils.getModelLocation((Block)b)));
        this.takeAll(remainingBlocks, b -> b instanceof BotaniaPaneBlock).forEach(b -> {
            String name = BuiltInRegistries.BLOCK.getKey(b).getPath();
            TextureMapping mapping = new TextureMapping().put(TextureSlot.EDGE, TextureMapping.getBlockTexture((Block)b)).put(TextureSlot.PANE, ResourceLocationHelper.prefix("block/" + name.substring(0, name.length() - "_pane".length())));
            ResourceLocation postModel = ModelTemplates.STAINED_GLASS_PANE_POST.create(b, mapping, this.modelOutput);
            ResourceLocation sideModel = ModelTemplates.STAINED_GLASS_PANE_SIDE.create(b, mapping, this.modelOutput);
            ResourceLocation sideAltModel = ModelTemplates.STAINED_GLASS_PANE_SIDE_ALT.create(b, mapping, this.modelOutput);
            ResourceLocation noSideModel = ModelTemplates.STAINED_GLASS_PANE_NOSIDE.create(b, mapping, this.modelOutput);
            ResourceLocation noSideAltModel = ModelTemplates.STAINED_GLASS_PANE_NOSIDE_ALT.create(b, mapping, this.modelOutput);
            this.blockstates.add((BlockStateGenerator)MultiPartGenerator.multiPart((Block)b).with(Variant.variant().with(VariantProperties.MODEL, (Object)postModel)).with((Condition)Condition.condition().term((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(true)), Variant.variant().with(VariantProperties.MODEL, (Object)sideModel)).with((Condition)Condition.condition().term((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(true)), Variant.variant().with(VariantProperties.MODEL, (Object)sideModel).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).with((Condition)Condition.condition().term((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(true)), Variant.variant().with(VariantProperties.MODEL, (Object)sideAltModel)).with((Condition)Condition.condition().term((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(true)), Variant.variant().with(VariantProperties.MODEL, (Object)sideAltModel).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).with((Condition)Condition.condition().term((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(false)), Variant.variant().with(VariantProperties.MODEL, (Object)noSideModel)).with((Condition)Condition.condition().term((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(false)), Variant.variant().with(VariantProperties.MODEL, (Object)noSideAltModel)).with((Condition)Condition.condition().term((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(false)), Variant.variant().with(VariantProperties.MODEL, (Object)noSideAltModel).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).with((Condition)Condition.condition().term((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(false)), Variant.variant().with(VariantProperties.MODEL, (Object)noSideModel).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)));
        });
        this.takeAll(remainingBlocks, b -> b instanceof StairBlock).forEach(b -> {
            String name = BuiltInRegistries.BLOCK.getKey(b).getPath();
            String baseName = name.substring(0, name.length() - "_stairs".length());
            boolean quartz = name.contains("quartz");
            if (quartz) {
                ResourceLocation side = ResourceLocationHelper.prefix("block/" + baseName + "_side");
                ResourceLocation bottom = ResourceLocationHelper.prefix("block/" + baseName + "_bottom");
                ResourceLocation top = ResourceLocationHelper.prefix("block/" + baseName + "_top");
                this.stairsBlock((Set<Block>)new HashSet<Block>(), (Block)b, side, bottom, top);
            } else {
                ResourceLocation tex = ResourceLocationHelper.prefix("block/" + baseName);
                this.stairsBlock((Set<Block>)new HashSet<Block>(), (Block)b, tex, tex, tex);
            }
        });
        this.takeAll(remainingBlocks, b -> b instanceof SlabBlock).forEach(slabBlock -> {
            String name = BuiltInRegistries.BLOCK.getKey(slabBlock).getPath();
            String baseName = name.substring(0, name.length() - "_slab".length());
            Block base = (Block)BuiltInRegistries.BLOCK.get(ResourceLocationHelper.prefix(baseName));
            boolean quartz = name.contains("quartz");
            if (quartz) {
                ResourceLocation side = TextureMapping.getBlockTexture((Block)base, (String)"_side");
                ResourceLocation bottom = TextureMapping.getBlockTexture((Block)base, (String)"_bottom");
                ResourceLocation top = TextureMapping.getBlockTexture((Block)base, (String)"_top");
                ResourceLocation doubleModel = ModelLocationUtils.getModelLocation((Block)base);
                this.slabBlock((Set<Block>)new HashSet<Block>(), (Block)slabBlock, doubleModel, side, bottom, top);
            } else {
                ResourceLocation baseTex = TextureMapping.getBlockTexture((Block)base);
                ResourceLocation doubleModel = ModelLocationUtils.getModelLocation((Block)base);
                this.slabBlock((Set<Block>)new HashSet<Block>(), (Block)slabBlock, doubleModel, baseTex, baseTex, baseTex);
            }
        });
        this.takeAll(remainingBlocks, b -> b instanceof WallBlock).forEach(wallBlock -> {
            String name = BuiltInRegistries.BLOCK.getKey(wallBlock).getPath();
            String baseName = name.substring(0, name.length() - "_wall".length());
            Block base = (Block)BuiltInRegistries.BLOCK.get(ResourceLocationHelper.prefix(baseName));
            ResourceLocation baseTexture = TextureMapping.getBlockTexture((Block)base);
            this.wallBlock((Set<Block>)new HashSet<Block>(), (Block)wallBlock, baseTexture);
        });
        remainingBlocks.forEach(this::cubeAllNoRemove);
    }

    protected void particleOnly(Set<Block> blocks, Block b, ResourceLocation particle) {
        this.singleVariantBlockState(b, ModelTemplates.PARTICLE_ONLY.create(b, TextureMapping.particle((ResourceLocation)particle), this.modelOutput));
        blocks.remove(b);
    }

    protected void manualModel(Set<Block> blocks, Block b) {
        this.singleVariantBlockState(b, ModelLocationUtils.getModelLocation((Block)b));
        blocks.remove(b);
    }

    protected void stairsBlock(Set<Block> blocks, Block block, ResourceLocation sideTex, ResourceLocation bottomTex, ResourceLocation topTex) {
        this.stairsBlockWithVariants(blocks, block, new ResourceLocation[]{sideTex}, new ResourceLocation[]{bottomTex}, new ResourceLocation[]{topTex});
    }

    protected void checkeredStairsBlock(Set<Block> blocks, Block block, ResourceLocation texture, ResourceLocation mirroredTexture) {
        BiFunction<String, Optional, ModelTemplate> checkeredTemplate = (model, suffix) -> new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/" + model)), suffix, new TextureSlot[]{TextureSlot.SIDE, TextureSlot.NORTH});
        TextureMapping checkeredMapping = new TextureMapping().put(TextureSlot.SIDE, texture).put(TextureSlot.NORTH, mirroredTexture);
        ResourceLocation checkeredStairsModel = checkeredTemplate.apply("stairs_checkered", Optional.empty()).create(BotaniaBlocks.biomeBrickMesaStairs, checkeredMapping, this.modelOutput);
        ResourceLocation checkeredStairsModelRot90 = checkeredTemplate.apply("stairs_checkered_90deg", Optional.of("_90deg")).create(BotaniaBlocks.biomeBrickMesaStairs, checkeredMapping, this.modelOutput);
        ResourceLocation checkeredStairsOuterModel = checkeredTemplate.apply("stairs_outer_checkered", Optional.of("_outer")).create(BotaniaBlocks.biomeBrickMesaStairs, checkeredMapping, this.modelOutput);
        ResourceLocation checkeredStairsOuterModelRot90 = checkeredTemplate.apply("stairs_outer_checkered_90deg", Optional.of("_outer_90deg")).create(BotaniaBlocks.biomeBrickMesaStairs, checkeredMapping, this.modelOutput);
        ResourceLocation checkeredStairsInnerModel = checkeredTemplate.apply("stairs_inner_checkered", Optional.of("_inner")).create(BotaniaBlocks.biomeBrickMesaStairs, checkeredMapping, this.modelOutput);
        ResourceLocation checkeredStairsInnerModelRot90 = checkeredTemplate.apply("stairs_inner_checkered_90deg", Optional.of("_inner_90deg")).create(BotaniaBlocks.biomeBrickMesaStairs, checkeredMapping, this.modelOutput);
        this.stairsBlockWithModels(blocks, block, checkeredStairsInnerModel, checkeredStairsInnerModelRot90, checkeredStairsModel, checkeredStairsModelRot90, checkeredStairsOuterModel, checkeredStairsOuterModelRot90);
    }

    protected void stairsBlockWithVariants(Set<Block> blocks, Block block, ResourceLocation[] sideTextures, ResourceLocation[] bottomTextures, ResourceLocation[] topTextures) {
        Object[] weights = new Integer[sideTextures.length];
        Arrays.fill(weights, (Object)1);
        this.stairsBlockWithVariants(blocks, block, sideTextures, bottomTextures, topTextures, (Integer[])weights);
    }

    protected void stairsBlockWithVariants(Set<Block> blocks, Block block, ResourceLocation[] sideTextures, ResourceLocation[] bottomTextures, ResourceLocation[] topTextures, Integer[] weights) {
        int length = sideTextures.length;
        if (length != topTextures.length || length != bottomTextures.length || length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        ResourceLocation[] innerModels = new ResourceLocation[length];
        ResourceLocation[] straightModels = new ResourceLocation[length];
        ResourceLocation[] outerModels = new ResourceLocation[length];
        for (int i = 0; i < length; ++i) {
            Object suffix = i == 0 ? "" : "_" + i;
            TextureMapping mapping = new TextureMapping().put(TextureSlot.SIDE, sideTextures[i]).put(TextureSlot.BOTTOM, bottomTextures[i]).put(TextureSlot.TOP, topTextures[i]);
            ResourceLocation modelIdInner = ModelLocationUtils.getModelLocation((Block)block, (String)("_inner" + (String)suffix));
            ResourceLocation modelIdStraight = ModelLocationUtils.getModelLocation((Block)block, (String)suffix);
            ResourceLocation modelIdOuter = ModelLocationUtils.getModelLocation((Block)block, (String)("_outer" + (String)suffix));
            innerModels[i] = ModelTemplates.STAIRS_INNER.create(modelIdInner, mapping, this.modelOutput);
            straightModels[i] = ModelTemplates.STAIRS_STRAIGHT.create(modelIdStraight, mapping, this.modelOutput);
            outerModels[i] = ModelTemplates.STAIRS_OUTER.create(modelIdOuter, mapping, this.modelOutput);
        }
        this.stairsBlockWithModels(blocks, block, innerModels, straightModels, outerModels, weights);
    }

    protected void stairsBlockWithModels(Set<Block> blocks, Block block, ResourceLocation[] innerModels, ResourceLocation[] straightModels, ResourceLocation[] outerModels, Integer[] weights) {
        this.stairsBlockWithModels(blocks, block, innerModels, straightModels, outerModels, weights, true);
    }

    protected void stairsBlockWithModels(Set<Block> blocks, Block block, ResourceLocation innerModel, ResourceLocation innerModelRot90, ResourceLocation straightModel, ResourceLocation straightModelRot90, ResourceLocation outerModel, ResourceLocation outerModelRot90) {
        this.stairsBlockWithModels(blocks, block, new ResourceLocation[]{innerModel}, new ResourceLocation[]{innerModelRot90}, new ResourceLocation[]{straightModel}, new ResourceLocation[]{straightModelRot90}, new ResourceLocation[]{outerModel}, new ResourceLocation[]{outerModelRot90}, new Integer[]{1}, true);
    }

    protected void stairsBlockWithModels(Set<Block> blocks, Block block, ResourceLocation[] innerModels, ResourceLocation[] straightModels, ResourceLocation[] outerModels, Integer[] weights, Boolean uvlock) {
        this.stairsBlockWithModels(blocks, block, innerModels, innerModels, straightModels, straightModels, outerModels, outerModels, weights, uvlock);
    }

    protected void stairsBlockWithModels(Set<Block> blocks, Block block, ResourceLocation[] innerModels, ResourceLocation[] innerModelsRot90, ResourceLocation[] straightModels, ResourceLocation[] straightModelsRot90, ResourceLocation[] outerModels, ResourceLocation[] outerModelsRot90, Integer[] weights, Boolean uvlock) {
        int length = innerModels.length;
        if (length != straightModels.length || length != outerModels.length || length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        PropertyDispatch.C3 propertyDispatch = PropertyDispatch.properties((Property)BlockStateProperties.HORIZONTAL_FACING, (Property)BlockStateProperties.HALF, (Property)BlockStateProperties.STAIRS_SHAPE);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            for (Half half : Half.values()) {
                for (StairsShape stairsShape : StairsShape.values()) {
                    boolean isRight;
                    boolean isLeft = stairsShape == StairsShape.INNER_LEFT || stairsShape == StairsShape.OUTER_LEFT;
                    boolean bl = isRight = stairsShape == StairsShape.INNER_RIGHT || stairsShape == StairsShape.OUTER_RIGHT;
                    int rotationOffset = isLeft && half == Half.BOTTOM ? -1 : (isRight && half == Half.TOP ? 1 : 0);
                    VariantProperties.Rotation[] rotations = VariantProperties.Rotation.values();
                    VariantProperties.Rotation yRot = switch (direction) {
                        case Direction.EAST -> rotations[(4 + rotationOffset) % 4];
                        case Direction.WEST -> rotations[(2 + rotationOffset) % 4];
                        case Direction.SOUTH -> rotations[(1 + rotationOffset) % 4];
                        case Direction.NORTH -> rotations[(3 + rotationOffset) % 4];
                        default -> throw new IllegalStateException();
                    };
                    VariantProperties.Rotation xRot = switch (half) {
                        default -> throw new IncompatibleClassChangeError();
                        case Half.BOTTOM -> VariantProperties.Rotation.R0;
                        case Half.TOP -> VariantProperties.Rotation.R180;
                    };
                    boolean rotatedModel = yRot == VariantProperties.Rotation.R90 || yRot == VariantProperties.Rotation.R270;
                    ResourceLocation[] models = switch (stairsShape) {
                        default -> throw new IncompatibleClassChangeError();
                        case StairsShape.STRAIGHT -> {
                            if (rotatedModel) {
                                yield straightModelsRot90;
                            }
                            yield straightModels;
                        }
                        case StairsShape.OUTER_RIGHT, StairsShape.OUTER_LEFT -> {
                            if (rotatedModel) {
                                yield outerModelsRot90;
                            }
                            yield outerModels;
                        }
                        case StairsShape.INNER_RIGHT, StairsShape.INNER_LEFT -> rotatedModel ? innerModelsRot90 : innerModels;
                    };
                    Stream<Integer> indices = IntStream.range(0, length).boxed();
                    propertyDispatch.select((Comparable)direction, (Comparable)half, (Comparable)stairsShape, indices.map(i -> this.maybeUVLock(uvlock, this.maybeWeight(weights[i], this.maybeYRot(yRot, this.maybeXRot(xRot, Variant.variant().with(VariantProperties.MODEL, (Object)models[i])))))).toList());
                }
            }
        }
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)block).with((PropertyDispatch)propertyDispatch));
        blocks.remove(block);
    }

    protected void slabBlock(Set<Block> blocks, Block block, ResourceLocation doubleModel, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        this.slabBlockWithVariants(blocks, block, new ResourceLocation[]{doubleModel}, new ResourceLocation[]{side}, new ResourceLocation[]{bottom}, new ResourceLocation[]{top});
    }

    protected void checkeredSlabBlock(Set<Block> blocks, Block block, ResourceLocation doubleModel, ResourceLocation texture, ResourceLocation mirroredTexture) {
        BiFunction<String, Optional, ModelTemplate> checkeredTemplate = (model, suffix) -> new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/" + model)), suffix, new TextureSlot[]{TextureSlot.SIDE, TextureSlot.NORTH});
        TextureMapping checkeredMapping = new TextureMapping().put(TextureSlot.SIDE, texture).put(TextureSlot.NORTH, mirroredTexture);
        ResourceLocation slabModel = checkeredTemplate.apply("slab_checkered", Optional.empty()).create(BotaniaBlocks.biomeBrickMesaSlab, checkeredMapping, this.modelOutput);
        ResourceLocation slabTopModel = checkeredTemplate.apply("slab_top_checkered", Optional.of("_top")).create(BotaniaBlocks.biomeBrickMesaSlab, checkeredMapping, this.modelOutput);
        this.slabBlockWithModels(blocks, block, slabModel, slabTopModel, doubleModel);
    }

    protected void slabBlockWithVariants(Set<Block> blocks, Block block, ResourceLocation[] doubleModels, ResourceLocation[] sideTextures, ResourceLocation[] bottomTextures, ResourceLocation[] topTextures) {
        Object[] weights = new Integer[sideTextures.length];
        Arrays.fill(weights, (Object)1);
        this.slabBlockWithVariants(blocks, block, doubleModels, sideTextures, bottomTextures, topTextures, (Integer[])weights);
    }

    protected void slabBlockWithVariants(Set<Block> blocks, Block block, ResourceLocation[] doubleModels, ResourceLocation[] sideTextures, ResourceLocation[] bottomTextures, ResourceLocation[] topTextures, Integer[] weights) {
        int length = sideTextures.length;
        if (length != topTextures.length || length != bottomTextures.length || length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        ResourceLocation[] bottomModels = new ResourceLocation[length];
        ResourceLocation[] topModels = new ResourceLocation[length];
        for (int i = 0; i < length; ++i) {
            Object suffix = i == 0 ? "" : "_" + i;
            TextureMapping mapping = new TextureMapping().put(TextureSlot.SIDE, sideTextures[i]).put(TextureSlot.BOTTOM, bottomTextures[i]).put(TextureSlot.TOP, topTextures[i]);
            ResourceLocation modelIdBottom = ModelLocationUtils.getModelLocation((Block)block, (String)suffix);
            ResourceLocation modelIdTop = ModelLocationUtils.getModelLocation((Block)block, (String)("_top" + (String)suffix));
            bottomModels[i] = ModelTemplates.SLAB_BOTTOM.create(modelIdBottom, mapping, this.modelOutput);
            topModels[i] = ModelTemplates.SLAB_TOP.create(modelIdTop, mapping, this.modelOutput);
        }
        this.slabBlockWithModels(blocks, block, bottomModels, topModels, doubleModels, weights);
    }

    protected void slabBlockWithModels(Set<Block> blocks, Block block, ResourceLocation bottomModel, ResourceLocation topModel, ResourceLocation doubleModel) {
        this.slabBlockWithModels(blocks, block, new ResourceLocation[]{bottomModel}, new ResourceLocation[]{topModel}, new ResourceLocation[]{doubleModel}, new Integer[]{1});
    }

    protected void slabBlockWithModels(Set<Block> blocks, Block block, ResourceLocation[] bottomModels, ResourceLocation[] topModels, ResourceLocation[] doubleModels, Integer[] weights) {
        int length = doubleModels.length;
        if (length != topModels.length || length != bottomModels.length || length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        Stream<Integer> indicesBottom = IntStream.range(0, length).boxed();
        Stream<Integer> indicesTop = IntStream.range(0, length).boxed();
        Stream<Integer> indicesDouble = IntStream.range(0, length).boxed();
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)block).with((PropertyDispatch)PropertyDispatch.property((Property)BlockStateProperties.SLAB_TYPE).select((Comparable)SlabType.BOTTOM, indicesBottom.map(i -> this.maybeWeight(weights[i], Variant.variant().with(VariantProperties.MODEL, (Object)bottomModels[i]))).toList()).select((Comparable)SlabType.TOP, indicesTop.map(i -> this.maybeWeight(weights[i], Variant.variant().with(VariantProperties.MODEL, (Object)topModels[i]))).toList()).select((Comparable)SlabType.DOUBLE, indicesDouble.map(i -> this.maybeWeight(weights[i], Variant.variant().with(VariantProperties.MODEL, (Object)doubleModels[i]))).toList())));
        blocks.remove(block);
    }

    protected void wallBlock(Set<Block> blocks, Block block, ResourceLocation texture) {
        this.wallBlock(blocks, block, texture, texture, texture);
    }

    protected void wallBlock(Set<Block> blocks, Block block, ResourceLocation sideTexture, ResourceLocation bottomTexture, ResourceLocation topTexture) {
        this.wallBlockWithVariants(blocks, block, new ResourceLocation[]{sideTexture}, new ResourceLocation[]{bottomTexture}, new ResourceLocation[]{topTexture});
    }

    protected void checkeredWallBlock(Set<Block> blocks, Block block, ResourceLocation texture, ResourceLocation mirroredTexture) {
        BiFunction<String, Optional, ModelTemplate> checkeredTemplate = (model, suffix) -> new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/" + model)), suffix, new TextureSlot[]{TextureSlot.SIDE, TextureSlot.NORTH});
        TextureMapping checkeredMapping = new TextureMapping().put(TextureSlot.SIDE, texture).put(TextureSlot.NORTH, mirroredTexture);
        ResourceLocation checkeredWallPostModel = checkeredTemplate.apply("wall_post_checkered", Optional.of("_post")).create(BotaniaBlocks.biomeBrickMesaWall, checkeredMapping, this.modelOutput);
        ResourceLocation checkeredWallSideModel = checkeredTemplate.apply("wall_side_checkered", Optional.of("_side")).create(BotaniaBlocks.biomeBrickMesaWall, checkeredMapping, this.modelOutput);
        ResourceLocation checkeredWallSideModelRot90 = checkeredTemplate.apply("wall_side_checkered_90deg", Optional.of("_side_90deg")).create(BotaniaBlocks.biomeBrickMesaWall, checkeredMapping, this.modelOutput);
        ResourceLocation checkeredWallSideTallModel = checkeredTemplate.apply("wall_side_tall_checkered", Optional.of("_side_tall")).create(BotaniaBlocks.biomeBrickMesaWall, checkeredMapping, this.modelOutput);
        ResourceLocation checkeredWallSideTallModelRot90 = checkeredTemplate.apply("wall_side_tall_checkered_90deg", Optional.of("_side_tall_90deg")).create(BotaniaBlocks.biomeBrickMesaWall, checkeredMapping, this.modelOutput);
        this.wallBlockWithModels(blocks, block, checkeredWallPostModel, checkeredWallSideModel, checkeredWallSideModelRot90, checkeredWallSideTallModel, checkeredWallSideTallModelRot90);
    }

    protected void wallBlockWithVariants(Set<Block> blocks, Block block, ResourceLocation[] textures) {
        this.wallBlockWithVariants(blocks, block, textures, textures, textures);
    }

    protected void wallBlockWithVariants(Set<Block> blocks, Block block, ResourceLocation[] textures, Integer[] weights) {
        this.wallBlockWithVariants(blocks, block, textures, textures, textures, weights);
    }

    protected void wallBlockWithVariants(Set<Block> blocks, Block block, ResourceLocation[] sideTextures, ResourceLocation[] bottomTextures, ResourceLocation[] topTextures) {
        Object[] weights = new Integer[sideTextures.length];
        Arrays.fill(weights, (Object)1);
        this.wallBlockWithVariants(blocks, block, sideTextures, bottomTextures, topTextures, (Integer[])weights);
    }

    protected void wallBlockWithVariants(Set<Block> blocks, Block block, ResourceLocation[] sideTextures, ResourceLocation[] bottomTextures, ResourceLocation[] topTextures, Integer[] weights) {
        int length = sideTextures.length;
        if (length != bottomTextures.length && length != topTextures.length && length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        ResourceLocation[] postModels = new ResourceLocation[length];
        ResourceLocation[] lowModels = new ResourceLocation[length];
        ResourceLocation[] tallModels = new ResourceLocation[length];
        for (int i = 0; i < length; ++i) {
            Object suffix = i == 0 ? "" : "_" + i;
            TextureMapping mapping = new TextureMapping().put(TextureSlot.WALL, sideTextures[i]).put(TextureSlot.BOTTOM, bottomTextures[i]).put(TextureSlot.TOP, topTextures[i]);
            ResourceLocation modelIdPost = ModelLocationUtils.getModelLocation((Block)block, (String)("_post" + (String)suffix));
            ResourceLocation modelIdLow = ModelLocationUtils.getModelLocation((Block)block, (String)("_side" + (String)suffix));
            ResourceLocation modelIdTall = ModelLocationUtils.getModelLocation((Block)block, (String)("_side_tall" + (String)suffix));
            ModelTemplate postTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/wall_post")), Optional.of("_post"), new TextureSlot[]{TextureSlot.WALL, TextureSlot.BOTTOM, TextureSlot.TOP});
            ModelTemplate sideTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/wall_side")), Optional.of("_side"), new TextureSlot[]{TextureSlot.WALL, TextureSlot.BOTTOM, TextureSlot.TOP});
            ModelTemplate sideTallTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/wall_side_tall")), Optional.of("_side_tall"), new TextureSlot[]{TextureSlot.WALL, TextureSlot.BOTTOM, TextureSlot.TOP});
            postModels[i] = postTemplate.create(modelIdPost, mapping, this.modelOutput);
            lowModels[i] = sideTemplate.create(modelIdLow, mapping, this.modelOutput);
            tallModels[i] = sideTallTemplate.create(modelIdTall, mapping, this.modelOutput);
        }
        this.wallBlockWithModels(blocks, block, postModels, lowModels, tallModels, weights);
    }

    protected void wallBlockWithModels(Set<Block> blocks, Block block, ResourceLocation[] postModels, ResourceLocation[] lowModels, ResourceLocation[] tallModels, Integer[] weights) {
        this.wallBlockWithModels(blocks, block, postModels, lowModels, tallModels, weights, true);
    }

    protected void wallBlockWithModels(Set<Block> blocks, Block block, ResourceLocation postModel, ResourceLocation lowModel, ResourceLocation lowModelRot90, ResourceLocation tallModel, ResourceLocation tallodelRot90) {
        this.wallBlockWithModels(blocks, block, new ResourceLocation[]{postModel}, new ResourceLocation[]{lowModel}, new ResourceLocation[]{lowModelRot90}, new ResourceLocation[]{tallModel}, new ResourceLocation[]{tallodelRot90}, new Integer[]{1}, true);
    }

    protected void wallBlockWithModels(Set<Block> blocks, Block block, ResourceLocation[] postModels, ResourceLocation[] lowModels, ResourceLocation[] tallModels, Integer[] weights, Boolean uvlock) {
        this.wallBlockWithModels(blocks, block, postModels, lowModels, lowModels, tallModels, tallModels, weights, uvlock);
    }

    protected void wallBlockWithModels(Set<Block> blocks, Block block, ResourceLocation[] postModels, ResourceLocation[] lowModels, ResourceLocation[] lowModelsRot90, ResourceLocation[] tallModels, ResourceLocation[] tallodelsRot90, Integer[] weights, Boolean uvlock) {
        int length = postModels.length;
        if (length != lowModels.length || length != tallModels.length || length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        MultiPartGenerator multiPartGenerator = MultiPartGenerator.multiPart((Block)block);
        Stream<Integer> indicesPost = IntStream.range(0, length).boxed();
        multiPartGenerator.with((Condition)Condition.condition().term((Property)BlockStateProperties.UP, (Comparable)Boolean.valueOf(true)), (Variant[])indicesPost.map(i -> this.maybeWeight(weights[i], Variant.variant().with(VariantProperties.MODEL, (Object)postModels[i]))).toArray(Variant[]::new));
        List<EnumProperty> wallSides = List.of(BlockStateProperties.EAST_WALL, BlockStateProperties.WEST_WALL, BlockStateProperties.SOUTH_WALL, BlockStateProperties.NORTH_WALL);
        for (EnumProperty wallSide : wallSides) {
            VariantProperties.Rotation yRot = wallSide == BlockStateProperties.EAST_WALL ? VariantProperties.Rotation.R90 : (wallSide == BlockStateProperties.WEST_WALL ? VariantProperties.Rotation.R270 : (wallSide == BlockStateProperties.SOUTH_WALL ? VariantProperties.Rotation.R180 : VariantProperties.Rotation.R0));
            boolean rotatedModel = yRot == VariantProperties.Rotation.R90 || yRot == VariantProperties.Rotation.R270;
            Stream<Integer> indicesLow = IntStream.range(0, length).boxed();
            Stream<Integer> indicesTall = IntStream.range(0, length).boxed();
            multiPartGenerator.with((Condition)Condition.condition().term((Property)wallSide, (Comparable)WallSide.LOW), (Variant[])indicesLow.map(i -> this.maybeUVLock(uvlock, this.maybeWeight(weights[i], this.maybeYRot(yRot, Variant.variant().with(VariantProperties.MODEL, (Object)(rotatedModel ? lowModelsRot90[i] : lowModels[i])))))).toArray(Variant[]::new)).with((Condition)Condition.condition().term((Property)wallSide, (Comparable)WallSide.TALL), (Variant[])indicesTall.map(i -> this.maybeUVLock(uvlock, this.maybeWeight(weights[i], this.maybeYRot(yRot, Variant.variant().with(VariantProperties.MODEL, (Object)(rotatedModel ? tallodelsRot90[i] : tallModels[i])))))).toArray(Variant[]::new));
        }
        this.blockstates.add((BlockStateGenerator)multiPartGenerator);
        blocks.remove(block);
    }

    protected void fenceBlock(Set<Block> blocks, Block block, ResourceLocation tex) {
        TextureMapping mapping = TextureMapping.defaultTexture((ResourceLocation)tex);
        ResourceLocation postModel = ModelTemplates.FENCE_POST.create(block, mapping, this.modelOutput);
        ResourceLocation sideModel = ModelTemplates.FENCE_SIDE.create(block, mapping, this.modelOutput);
        this.blockstates.add(BlockModelGeneratorsAccessor.makeFenceState(block, postModel, sideModel));
        blocks.remove(block);
    }

    protected void fenceGateBlock(Set<Block> blocks, Block block, ResourceLocation tex) {
        TextureMapping mapping = TextureMapping.defaultTexture((ResourceLocation)tex);
        ResourceLocation openModel = ModelTemplates.FENCE_GATE_OPEN.create(block, mapping, this.modelOutput);
        ResourceLocation closedModel = ModelTemplates.FENCE_GATE_CLOSED.create(block, mapping, this.modelOutput);
        ResourceLocation openWallModel = ModelTemplates.FENCE_GATE_WALL_OPEN.create(block, mapping, this.modelOutput);
        ResourceLocation closedWallModel = ModelTemplates.FENCE_GATE_WALL_CLOSED.create(block, mapping, this.modelOutput);
        this.blockstates.add(BlockModelGeneratorsAccessor.makeFenceGateState(block, openModel, closedModel, openWallModel, closedWallModel, false));
        blocks.remove(block);
    }

    protected void cubeAllNoRemove(Block block) {
        this.cubeAll(new HashSet<Block>(), block);
    }

    protected void cubeAll(Set<Block> blocks, Block block) {
        ResourceLocation texture = TextureMapping.getBlockTexture((Block)block);
        this.cubeAllWithVariants(blocks, block, new ResourceLocation[]{texture});
    }

    protected ResourceLocation checkeredBlockWithBlockstate(Set<Block> blocks, Block block, ResourceLocation texture, ResourceLocation mirroredTexture) {
        BiFunction<String, Optional, ModelTemplate> checkeredTemplate = (model, suffix) -> new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/" + model)), suffix, new TextureSlot[]{TextureSlot.SIDE, TextureSlot.NORTH});
        TextureMapping checkeredMapping = new TextureMapping().put(TextureSlot.SIDE, texture).put(TextureSlot.NORTH, mirroredTexture);
        ResourceLocation blockModel = checkeredTemplate.apply("cube_checkered", Optional.empty()).create(block, checkeredMapping, this.modelOutput);
        this.cubeAllWithModels(blocks, block, new ResourceLocation[]{blockModel}, new Integer[]{1});
        return blockModel;
    }

    protected void cubeAllWithVariants(Set<Block> blocks, Block block, ResourceLocation[] textures) {
        Object[] weights = new Integer[textures.length];
        Arrays.fill(weights, (Object)1);
        this.cubeAllWithVariants(blocks, block, textures, (Integer[])weights);
    }

    protected void cubeAllWithVariants(Set<Block> blocks, Block block, ResourceLocation[] textures, Integer[] weights) {
        int length = textures.length;
        if (length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        ResourceLocation[] models = new ResourceLocation[length];
        for (int i = 0; i < length; ++i) {
            Object suffix = i == 0 ? "" : "_" + i;
            ResourceLocation modelId = ModelLocationUtils.getModelLocation((Block)block, (String)suffix);
            models[i] = ModelTemplates.CUBE_ALL.create(modelId, TextureMapping.cube((ResourceLocation)textures[i]), this.modelOutput);
        }
        this.cubeAllWithModels(blocks, block, models, weights);
    }

    protected void cubeAllWithModels(Set<Block> blocks, Block block, ResourceLocation[] models, Integer[] weights) {
        int length = models.length;
        if (length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        Stream<Integer> indices = IntStream.range(0, length).boxed();
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)block, (Variant[])((Variant[])indices.map(i -> this.maybeWeight(weights[i], Variant.variant().with(VariantProperties.MODEL, (Object)models[i]))).toArray(Variant[]::new))));
        blocks.remove(block);
    }

    protected void singleVariantBlockState(Block b, ResourceLocation model) {
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)b, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)model)));
    }

    protected void rotatedMirrored(Set<Block> blocks, Block block, ResourceLocation texture) {
        this.rotatedMirroredWithVariants(blocks, block, new ResourceLocation[]{texture});
    }

    protected void rotatedMirroredWithVariants(Set<Block> blocks, Block block, ResourceLocation[] textures) {
        Object[] weights = new Integer[textures.length];
        Arrays.fill(weights, (Object)1);
        this.rotatedMirroredWithVariants(blocks, block, textures, (Integer[])weights);
    }

    protected void rotatedMirroredWithVariants(Set<Block> blocks, Block block, ResourceLocation[] textures, Integer[] weights) {
        int length = textures.length;
        if (length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        ResourceLocation[] models = new ResourceLocation[length];
        ResourceLocation[] mirroredModels = new ResourceLocation[length];
        for (int i = 0; i < length; ++i) {
            Object suffix = i == 0 ? "" : "_" + i;
            ResourceLocation modelId = ModelLocationUtils.getModelLocation((Block)block, (String)suffix);
            ResourceLocation mirriredModelId = ModelLocationUtils.getModelLocation((Block)block, (String)("_mirrored" + (String)suffix));
            models[i] = ModelTemplates.CUBE_ALL.create(modelId, TextureMapping.cube((ResourceLocation)textures[i]), this.modelOutput);
            mirroredModels[i] = ModelTemplates.CUBE_MIRRORED_ALL.create(mirriredModelId, TextureMapping.cube((ResourceLocation)textures[i]), this.modelOutput);
        }
        this.rotatedMirroredWithModels(blocks, block, models, mirroredModels, weights);
    }

    protected void rotatedMirroredWithModels(Set<Block> blocks, Block block, ResourceLocation[] models, ResourceLocation[] mirroredModels, Integer[] weights) {
        int length = models.length;
        if (length != mirroredModels.length || length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        Stream<Integer> indices = IntStream.range(0, length).boxed();
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)block, (Variant[])((Variant[])indices.flatMap(i -> Stream.of(this.maybeWeight(weights[i], Variant.variant().with(VariantProperties.MODEL, (Object)models[i])), this.maybeWeight(weights[i], Variant.variant().with(VariantProperties.MODEL, (Object)mirroredModels[i])), this.maybeWeight(weights[i], Variant.variant().with(VariantProperties.MODEL, (Object)models[i]).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)), this.maybeWeight(weights[i], Variant.variant().with(VariantProperties.MODEL, (Object)mirroredModels[i]).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)))).toArray(Variant[]::new))));
        blocks.remove(block);
    }

    protected void pillar(Set<Block> blocks, Block block, ResourceLocation top, ResourceLocation side) {
        this.pillarWithVariants(blocks, block, new ResourceLocation[]{top}, new ResourceLocation[]{side});
    }

    protected void pillarWithVariants(Set<Block> blocks, Block block, ResourceLocation[] topTextures, ResourceLocation[] sideTextures) {
        Object[] weights = new Integer[topTextures.length];
        Arrays.fill(weights, (Object)1);
        this.pillarWithVariants(blocks, block, topTextures, sideTextures, (Integer[])weights);
    }

    protected void pillarWithVariants(Set<Block> blocks, Block block, ResourceLocation[] topTextures, ResourceLocation[] sideTextures, Integer[] weights) {
        int length = topTextures.length;
        if (length != sideTextures.length || length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        ResourceLocation[] topModels = new ResourceLocation[length];
        ResourceLocation[] horizontalModels = new ResourceLocation[length];
        for (int i = 0; i < length; ++i) {
            Object suffix = i == 0 ? "" : "_" + i;
            ResourceLocation modelIdTop = ModelLocationUtils.getModelLocation((Block)block, (String)suffix);
            ResourceLocation modelIdHorizontal = ModelLocationUtils.getModelLocation((Block)block, (String)("_horizontal" + (String)suffix));
            topModels[i] = ModelTemplates.CUBE_COLUMN.create(modelIdTop, TextureMapping.column((ResourceLocation)sideTextures[i], (ResourceLocation)topTextures[i]), this.modelOutput);
            horizontalModels[i] = ModelTemplates.CUBE_COLUMN_HORIZONTAL.create(modelIdHorizontal, TextureMapping.column((ResourceLocation)sideTextures[i], (ResourceLocation)topTextures[i]), this.modelOutput);
        }
        this.pillarWithModels(blocks, block, topModels, horizontalModels, weights);
    }

    protected void pillarWithModels(Set<Block> blocks, Block block, ResourceLocation[] topModels, ResourceLocation[] horizontalModels, Integer[] weights) {
        int length = topModels.length;
        if (length != horizontalModels.length || length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        Stream<Integer> indicesX = IntStream.range(0, length).boxed();
        Stream<Integer> indicesY = IntStream.range(0, length).boxed();
        Stream<Integer> indicesZ = IntStream.range(0, length).boxed();
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)block).with((PropertyDispatch)PropertyDispatch.property((Property)BlockStateProperties.AXIS).select((Comparable)Direction.Axis.Y, indicesX.map(i -> this.maybeWeight(weights[i], Variant.variant().with(VariantProperties.MODEL, (Object)topModels[i]))).toList()).select((Comparable)Direction.Axis.Z, indicesY.map(i -> this.maybeWeight(weights[i], Variant.variant().with(VariantProperties.MODEL, (Object)horizontalModels[i]).with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90))).toList()).select((Comparable)Direction.Axis.X, indicesZ.map(i -> this.maybeWeight(weights[i], Variant.variant().with(VariantProperties.MODEL, (Object)horizontalModels[i]).with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90))).toList())));
        blocks.remove(block);
    }

    protected void pillarAlt(Set<Block> blocks, Block block, ResourceLocation top, ResourceLocation side) {
        this.pillarAltWithVariants(blocks, block, new ResourceLocation[]{top}, new ResourceLocation[]{side});
    }

    protected void pillarAltWithVariants(Set<Block> blocks, Block block, ResourceLocation[] topTextures, ResourceLocation[] sideTextures) {
        int length = topTextures.length;
        if (length != sideTextures.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        ResourceLocation[] topModels = new ResourceLocation[length];
        ResourceLocation[] horizontalXModels = new ResourceLocation[length];
        ResourceLocation[] horizontalZModels = new ResourceLocation[length];
        ModelTemplate horizontalXTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/cube_column_horizontal_x")), Optional.of("_horizontal_x"), new TextureSlot[]{TextureSlot.END, TextureSlot.SIDE});
        ModelTemplate horizontalZTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/cube_column_horizontal_z")), Optional.of("_horizontal_z"), new TextureSlot[]{TextureSlot.END, TextureSlot.SIDE});
        for (int i = 0; i < length; ++i) {
            Object suffix = i == 0 ? "" : "_" + i;
            ResourceLocation modelIdTop = ModelLocationUtils.getModelLocation((Block)block, (String)suffix);
            ResourceLocation modelIdHorizontalX = ModelLocationUtils.getModelLocation((Block)block, (String)("_horizontal_x" + (String)suffix));
            ResourceLocation modelIdHorizontalZ = ModelLocationUtils.getModelLocation((Block)block, (String)("_horizontal_z" + (String)suffix));
            topModels[i] = ModelTemplates.CUBE_COLUMN.create(modelIdTop, TextureMapping.column((ResourceLocation)sideTextures[i], (ResourceLocation)topTextures[i]), this.modelOutput);
            horizontalXModels[i] = horizontalXTemplate.create(modelIdHorizontalX, TextureMapping.column((ResourceLocation)sideTextures[i], (ResourceLocation)topTextures[i]), this.modelOutput);
            horizontalZModels[i] = horizontalZTemplate.create(modelIdHorizontalZ, TextureMapping.column((ResourceLocation)sideTextures[i], (ResourceLocation)topTextures[i]), this.modelOutput);
        }
        this.pillarAltWithModels(blocks, block, topModels, horizontalXModels, horizontalZModels);
    }

    protected void pillarAltWithModels(Set<Block> blocks, Block block, ResourceLocation[] yModels, ResourceLocation[] xModels, ResourceLocation[] zModels) {
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)block).with((PropertyDispatch)PropertyDispatch.property((Property)BlockStateProperties.AXIS).select((Comparable)Direction.Axis.Y, Stream.of(yModels).map(rl -> Variant.variant().with(VariantProperties.MODEL, rl)).toList()).select((Comparable)Direction.Axis.X, Stream.of(xModels).map(rl -> Variant.variant().with(VariantProperties.MODEL, rl)).toList()).select((Comparable)Direction.Axis.Z, Stream.of(zModels).map(rl -> Variant.variant().with(VariantProperties.MODEL, rl)).toList())));
        blocks.remove(block);
    }

    protected void directionalPillar(Set<Block> blocks, Block block, ResourceLocation top, ResourceLocation bottom, ResourceLocation side) {
        this.directionalPillarWithVariants(blocks, block, new ResourceLocation[]{top}, new ResourceLocation[]{top}, new ResourceLocation[]{side});
    }

    protected void directionalPillarWithVariants(Set<Block> blocks, Block block, ResourceLocation[] topTextures, ResourceLocation[] bottomTextures, ResourceLocation[] sideTextures) {
        Object[] weights = new Integer[topTextures.length];
        Arrays.fill(weights, (Object)1);
        this.directionalPillarWithVariants(blocks, block, topTextures, bottomTextures, sideTextures, (Integer[])weights);
    }

    protected void directionalPillarWithVariants(Set<Block> blocks, Block block, ResourceLocation[] topTextures, ResourceLocation[] bottomTextures, ResourceLocation[] sideTextures, Integer[] weights) {
        int length = topTextures.length;
        if (length != bottomTextures.length || length != sideTextures.length || length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        ResourceLocation[] topModels = new ResourceLocation[length];
        ResourceLocation[] horizontalModels = new ResourceLocation[length];
        ModelTemplate topTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/cube_column_directional")), Optional.empty(), new TextureSlot[]{TextureSlot.TOP, TextureSlot.BOTTOM, TextureSlot.SIDE});
        ModelTemplate horizontalTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/cube_column_directional_horizontal")), Optional.of("_horizontal"), new TextureSlot[]{TextureSlot.TOP, TextureSlot.BOTTOM, TextureSlot.SIDE});
        for (int i = 0; i < length; ++i) {
            TextureMapping mapping = new TextureMapping().put(TextureSlot.SIDE, sideTextures[i]).put(TextureSlot.TOP, topTextures[i]).put(TextureSlot.BOTTOM, bottomTextures[i]);
            Object suffix = i == 0 ? "" : "_" + i;
            ResourceLocation modelIdTop = ModelLocationUtils.getModelLocation((Block)block, (String)suffix);
            ResourceLocation modelIdHorizontal = ModelLocationUtils.getModelLocation((Block)block, (String)("_horizontal" + (String)suffix));
            topModels[i] = topTemplate.create(modelIdTop, mapping, this.modelOutput);
            horizontalModels[i] = horizontalTemplate.create(modelIdHorizontal, mapping, this.modelOutput);
        }
        this.directionalPillarWithModels(blocks, block, topModels, horizontalModels, weights);
    }

    protected void directionalPillarWithModels(Set<Block> blocks, Block block, ResourceLocation[] topModels, ResourceLocation[] horizontalModels, Integer[] weights) {
        int length = topModels.length;
        if (length != horizontalModels.length || length != weights.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        Stream<Integer> indicesUp = IntStream.range(0, length).boxed();
        Stream<Integer> indicesDown = IntStream.range(0, length).boxed();
        Stream<Integer> indicesNorth = IntStream.range(0, length).boxed();
        Stream<Integer> indicesSouth = IntStream.range(0, length).boxed();
        Stream<Integer> indicesEast = IntStream.range(0, length).boxed();
        Stream<Integer> indicesWest = IntStream.range(0, length).boxed();
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)block).with((PropertyDispatch)PropertyDispatch.property((Property)BlockStateProperties.FACING).select((Comparable)Direction.UP, indicesUp.map(i -> this.maybeWeight(weights[i], Variant.variant().with(VariantProperties.MODEL, (Object)topModels[i]))).toList()).select((Comparable)Direction.DOWN, indicesDown.map(i -> this.maybeWeight(weights[i], Variant.variant().with(VariantProperties.MODEL, (Object)topModels[i]).with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R180))).toList()).select((Comparable)Direction.NORTH, indicesNorth.map(i -> this.maybeWeight(weights[i], Variant.variant().with(VariantProperties.MODEL, (Object)horizontalModels[i]))).toList()).select((Comparable)Direction.SOUTH, indicesSouth.map(i -> this.maybeWeight(weights[i], Variant.variant().with(VariantProperties.MODEL, (Object)horizontalModels[i]).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180))).toList()).select((Comparable)Direction.EAST, indicesEast.map(i -> this.maybeWeight(weights[i], Variant.variant().with(VariantProperties.MODEL, (Object)horizontalModels[i]).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90))).toList()).select((Comparable)Direction.WEST, indicesWest.map(i -> this.maybeWeight(weights[i], Variant.variant().with(VariantProperties.MODEL, (Object)horizontalModels[i]).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270))).toList())));
        blocks.remove(block);
    }

    protected <T> Variant withMaybe(VariantProperty<T> property, T value, boolean shouldAdd, Variant variant) {
        if (shouldAdd) {
            variant.with(property, value);
        }
        return variant;
    }

    protected Variant maybeUVLock(Boolean uvlock, Variant variant) {
        return this.withMaybe(VariantProperties.UV_LOCK, uvlock, uvlock, variant);
    }

    protected Variant maybeWeight(int weight, Variant variant) {
        return this.withMaybe(VariantProperties.WEIGHT, weight, weight != 1, variant);
    }

    protected Variant maybeXRot(VariantProperties.Rotation rotation, Variant variant) {
        return this.withMaybe(VariantProperties.X_ROT, rotation, rotation != VariantProperties.Rotation.R0, variant);
    }

    protected Variant maybeYRot(VariantProperties.Rotation rotation, Variant variant) {
        return this.withMaybe(VariantProperties.Y_ROT, rotation, rotation != VariantProperties.Rotation.R0, variant);
    }

    @SafeVarargs
    public final <T> Collection<T> takeAll(Set<T> src, T ... items) {
        List<T> ret = Arrays.asList(items);
        for (T item : items) {
            if (src.contains(item)) continue;
            this.getLogger().warn("Item {} not found in set", item);
        }
        if (!src.removeAll(ret)) {
            this.getLogger().warn("takeAll array didn't yield anything ({})", (Object)Arrays.toString(items));
        }
        return ret;
    }

    public final <T> Collection<T> takeAll(Set<T> src, Predicate<T> pred) {
        ArrayList<T> ret = new ArrayList<T>();
        Iterator<T> iter = src.iterator();
        while (iter.hasNext()) {
            T item = iter.next();
            if (!pred.test(item)) continue;
            iter.remove();
            ret.add(item);
        }
        if (ret.isEmpty()) {
            this.getLogger().warn("takeAll predicate yielded nothing", new Throwable());
        }
        return ret;
    }

    protected void redStringBlock(Block b) {
        ResourceLocation selfName = TextureMapping.getBlockTexture((Block)b);
        ResourceLocation front = ResourceLocationHelper.prefix("block/red_string_sender");
        ResourceLocation model = ModelTemplates.CUBE_ORIENTABLE.create(b, new TextureMapping().put(TextureSlot.TOP, selfName).put(TextureSlot.FRONT, front).put(TextureSlot.SIDE, selfName), this.modelOutput);
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)b, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)model)).with(BlockModelGeneratorsAccessor.facingDispatch()));
    }
}

