/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool.bow;

import java.util.function.Consumer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.equipment.tool.bow.LivingwoodBowItem;

public class CrystalBowItem
extends LivingwoodBowItem {
    private static final int ARROW_COST = 200;

    public CrystalBowItem(Item.Properties builder) {
        super(builder);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level worldIn, Player playerIn, @NotNull InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        boolean canMaterializeArrow = this.canFire(itemstack, playerIn);
        if (!playerIn.getAbilities().instabuild && !canMaterializeArrow) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        playerIn.startUsingItem(handIn);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public void releaseUsing(@NotNull ItemStack stack, @NotNull Level level, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            boolean canMaterializeArrow = this.canFire(stack, player);
            ItemStack arrowStack = player.getProjectile(stack);
            int i = (int)((float)(this.getUseDuration(stack) - timeLeft) * this.chargeVelocityMultiplier());
            if (i < 0) {
                return;
            }
            if (!arrowStack.isEmpty() || canMaterializeArrow) {
                float power;
                if (arrowStack.isEmpty()) {
                    arrowStack = new ItemStack((ItemLike)Items.ARROW);
                }
                if (!((double)(power = CrystalBowItem.getPowerForTime((int)i)) < 0.1)) {
                    boolean markUnpickable;
                    boolean bl = markUnpickable = player.getAbilities().instabuild || arrowStack.is(Items.ARROW);
                    if (!level.isClientSide) {
                        int knockback;
                        int powerEnch;
                        ArrowItem arrowItem = (ArrowItem)(arrowStack.getItem() instanceof ArrowItem ? arrowStack.getItem() : Items.ARROW);
                        AbstractArrow arrow = arrowItem.createArrow(level, arrowStack, (LivingEntity)player);
                        arrow.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, power * 3.0f, 1.0f);
                        if (power == 1.0f) {
                            arrow.setCritArrow(true);
                        }
                        if ((powerEnch = EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.POWER_ARROWS, (ItemStack)stack)) > 0) {
                            arrow.setBaseDamage(arrow.getBaseDamage() + (double)powerEnch * 0.5 + 0.5);
                        }
                        if ((knockback = EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.PUNCH_ARROWS, (ItemStack)stack)) > 0) {
                            arrow.setKnockback(knockback);
                        }
                        if (EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.FLAMING_ARROWS, (ItemStack)stack) > 0) {
                            arrow.setSecondsOnFire(100);
                        }
                        stack.hurtAndBreak(1, (LivingEntity)player, p -> p.broadcastBreakEvent(player.getUsedItemHand()));
                        if (markUnpickable || player.getAbilities().instabuild && (arrowStack.is(Items.SPECTRAL_ARROW) || arrowStack.is(Items.TIPPED_ARROW))) {
                            arrow.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                        }
                        level.addFreshEntity((Entity)arrow);
                    }
                    level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (player.getRandom().nextFloat() * 0.4f + 1.2f) + power * 0.5f);
                    if (!markUnpickable && !player.getAbilities().instabuild) {
                        arrowStack.shrink(1);
                        if (arrowStack.isEmpty()) {
                            player.getInventory().removeItem(arrowStack);
                        }
                    }
                    player.awardStat(Stats.ITEM_USED.get((Object)this));
                }
            }
        }
    }

    @Override
    public float chargeVelocityMultiplier() {
        return 2.0f;
    }

    private boolean canFire(ItemStack stack, Player player) {
        boolean infinity;
        boolean bl = infinity = EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.INFINITY_ARROWS, (ItemStack)stack) > 0;
        return player.getAbilities().instabuild || ManaItemHandler.instance().requestManaExactForTool(stack, player, 200 / (infinity ? 2 : 1), false);
    }

    @Override
    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        boolean infinity = EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.INFINITY_ARROWS, (ItemStack)stack) > 0;
        return ToolCommons.damageItemIfPossible(stack, amount, entity, 200 / (infinity ? 2 : 1));
    }
}

