/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.item.CosmeticAttachable;
import vazkii.botania.api.item.CosmeticBauble;
import vazkii.botania.common.crafting.recipe.NoOpRecipeSerializer;
import vazkii.botania.common.crafting.recipe.RecipeUtils;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;

public class CosmeticRemoveRecipe
extends CustomRecipe {
    public static final NoOpRecipeSerializer<CosmeticRemoveRecipe> SERIALIZER = new NoOpRecipeSerializer<CosmeticRemoveRecipe>(CosmeticRemoveRecipe::new);

    public CosmeticRemoveRecipe(ResourceLocation id) {
        super(id, CraftingBookCategory.EQUIPMENT);
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level world) {
        boolean foundAttachable = false;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            Item item = stack.getItem();
            if (item instanceof CosmeticAttachable) {
                CosmeticAttachable attachable = (CosmeticAttachable)item;
                if (!(stack.getItem() instanceof CosmeticBauble) && !attachable.getCosmeticItem(stack).isEmpty()) {
                    foundAttachable = true;
                    continue;
                }
            }
            return false;
        }
        return foundAttachable;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess registries) {
        ItemStack attachableItem = ItemStack.EMPTY;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            attachableItem = stack;
        }
        CosmeticAttachable attachable = (CosmeticAttachable)attachableItem.getItem();
        if (attachable.getCosmeticItem(attachableItem).isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack copy = attachableItem.copyWithCount(1);
        attachable.setCosmeticItem(copy, ItemStack.EMPTY);
        return copy;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height > 0;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull CraftingContainer inv) {
        return RecipeUtils.getRemainingItemsSub((Container)inv, s -> {
            Item patt2744$temp = s.getItem();
            if (patt2744$temp instanceof BaubleItem) {
                BaubleItem bauble = (BaubleItem)patt2744$temp;
                ItemStack stack = bauble.getCosmeticItem((ItemStack)s);
                stack.setCount(1);
                return stack;
            }
            return null;
        });
    }
}

