/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool.elementium;

import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.item.equipment.tool.manasteel.ManasteelAxeItem;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class ElementiumAxeItem
extends ManasteelAxeItem {
    public static final ResourceLocation BEHEADING_LOOT_TABLE = ResourceLocationHelper.prefix("elementium_axe_beheading");

    public ElementiumAxeItem(Item.Properties props) {
        super(BotaniaAPI.instance().getElementiumItemTier(), 6.0f, -3.1f, props);
    }

    public static void onEntityDrops(boolean hitRecently, DamageSource source, LivingEntity target, Consumer<ItemStack> consumer) {
        LivingEntity livingEntity;
        LootParams.Builder ctx = new LootParams.Builder((ServerLevel)target.level()).withParameter(LootContextParams.THIS_ENTITY, (Object)target).withParameter(LootContextParams.ORIGIN, (Object)target.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)source).withOptionalParameter(LootContextParams.KILLER_ENTITY, (Object)source.getEntity()).withOptionalParameter(LootContextParams.DIRECT_KILLER_ENTITY, (Object)source.getDirectEntity());
        if (hitRecently && target.getKillCredit() != null && (livingEntity = target.getKillCredit()) instanceof Player) {
            Player p = (Player)livingEntity;
            ctx = ctx.withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)p).withLuck(p.getLuck());
        }
        target.level().getServer().getLootData().getLootTable(BEHEADING_LOOT_TABLE).getRandomItems(ctx.create(LootContextParamSets.ENTITY), target.getLootTableSeed(), consumer);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.MOB_LOOTING) {
            return true;
        }
        return enchantment.category.canEnchant((Item)this);
    }

    public boolean hurtEnemy(ItemStack stack, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, living -> living.broadcastBreakEvent(EquipmentSlot.MAINHAND));
        return true;
    }
}

