/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.lens;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.ManaFlameBlockEntity;
import vazkii.botania.common.item.lens.Lens;

public class FlashLens
extends Lens {
    @Override
    public boolean collideBurst(ManaBurst burst, HitResult pos, boolean isManaBlock, boolean shouldKill, ItemStack stack) {
        ThrowableProjectile entity = burst.entity();
        if (!(entity.level().isClientSide || pos.getType() != HitResult.Type.BLOCK || burst.isFake() || isManaBlock)) {
            BlockHitResult rtr = (BlockHitResult)pos;
            BlockPos neighborPos = rtr.getBlockPos().relative(rtr.getDirection());
            BlockState stateAt = entity.level().getBlockState(rtr.getBlockPos());
            BlockState neighbor = entity.level().getBlockState(neighborPos);
            if (stateAt.is(BotaniaBlocks.manaFlame)) {
                entity.level().removeBlock(rtr.getBlockPos(), false);
            } else if (neighbor.isAir() || neighbor.canBeReplaced()) {
                FluidState fluid = entity.level().getFluidState(neighborPos);
                boolean water = fluid.isSource() && fluid.is(FluidTags.WATER);
                entity.level().setBlockAndUpdate(neighborPos, (BlockState)BotaniaBlocks.manaFlame.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(water)));
                BlockEntity blockEntity = entity.level().getBlockEntity(neighborPos);
                if (blockEntity instanceof ManaFlameBlockEntity) {
                    ManaFlameBlockEntity manaFlame = (ManaFlameBlockEntity)blockEntity;
                    manaFlame.setColor(burst.getColor());
                }
            }
        }
        return shouldKill;
    }
}

