/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.mana.spark.SparkAttachable;
import vazkii.botania.common.entity.ManaSparkEntity;
import vazkii.botania.xplat.XplatAbstractions;

public class ManaSparkItem
extends Item {
    public ManaSparkItem(Item.Properties builder) {
        super(builder);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        return ManaSparkItem.attachSpark(ctx.getLevel(), ctx.getClickedPos(), ctx.getItemInHand()) ? InteractionResult.sidedSuccess((boolean)ctx.getLevel().isClientSide) : InteractionResult.PASS;
    }

    public static boolean attachSpark(Level world, BlockPos pos, ItemStack stack) {
        SparkAttachable attach = XplatAbstractions.INSTANCE.findSparkAttachable(world, pos, world.getBlockState(pos), world.getBlockEntity(pos), Direction.UP);
        if (attach != null && attach.canAttachSpark(stack) && attach.getAttachedSpark() == null) {
            if (!world.isClientSide) {
                stack.shrink(1);
                ManaSparkEntity spark = new ManaSparkEntity(world);
                spark.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.25, (double)pos.getZ() + 0.5);
                world.addFreshEntity((Entity)spark);
                attach.attachSpark(spark);
            }
            return true;
        }
        return false;
    }
}

