/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2389;
import net.minecraft.class_2405;
import net.minecraft.class_2544;
import net.minecraft.class_2960;
import net.minecraft.class_4940;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaDoubleFlowerBlock;
import vazkii.botania.common.block.BotaniaFlowerBlock;
import vazkii.botania.common.block.LuminizerBlock;
import vazkii.botania.common.block.decor.BotaniaMushroomBlock;
import vazkii.botania.common.block.decor.FloatingFlowerBlock;
import vazkii.botania.common.block.decor.FlowerMotifBlock;
import vazkii.botania.common.block.decor.PetalBlock;
import vazkii.botania.common.block.mana.ManaPoolBlock;
import vazkii.botania.common.block.mana.ManaSpreaderBlock;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.brew.BaseBrewItem;
import vazkii.botania.common.item.lens.LensItem;
import vazkii.botania.common.item.material.MysticalPetalItem;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.data.util.ModelWithOverrides;
import vazkii.botania.data.util.OverrideHolder;
import vazkii.botania.data.util.SimpleModelSupplierWithOverrides;
import vazkii.botania.mixin.TextureSlotAccessor;
import vazkii.botania.xplat.XplatAbstractions;

public class ItemModelProvider
implements class_2405 {
    private static final class_4945 LAYER1 = TextureSlotAccessor.make("layer1");
    private static final class_4945 LAYER2 = TextureSlotAccessor.make("layer2");
    private static final class_4945 LAYER3 = TextureSlotAccessor.make("layer3");
    private static final class_4942 GENERATED_1 = new class_4942(Optional.of(new class_2960("item/generated")), Optional.empty(), new class_4945[]{class_4945.field_23006, LAYER1});
    private static final class_4942 GENERATED_2 = new class_4942(Optional.of(new class_2960("item/generated")), Optional.empty(), new class_4945[]{class_4945.field_23006, LAYER1, LAYER2});
    private static final class_4942 HANDHELD_1 = new class_4942(Optional.of(new class_2960("item/handheld")), Optional.empty(), new class_4945[]{class_4945.field_23006, LAYER1});
    private static final class_4942 HANDHELD_3 = new class_4942(Optional.of(new class_2960("item/handheld")), Optional.empty(), new class_4945[]{class_4945.field_23006, LAYER1, LAYER2, LAYER3});
    private static final class_4942 WALL_INVENTORY = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/wall_inventory")), Optional.empty(), new class_4945[]{class_4945.field_23015, class_4945.field_23014, class_4945.field_23027});
    private static final class_4942 WALL_INVENTORY_CHECKERED = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/wall_inventory_checkered")), Optional.empty(), new class_4945[]{class_4945.field_23019, class_4945.field_23018});
    private static final class_4945 OUTSIDE = TextureSlotAccessor.make("outside");
    private static final class_4945 CORE = TextureSlotAccessor.make("core");
    private static final class_4942 SPREADER = new class_4942(Optional.of(ResourceLocationHelper.prefix("block/shapes/spreader_item")), Optional.empty(), new class_4945[]{class_4945.field_23018, class_4945.field_23017, class_4945.field_27791, OUTSIDE, CORE});
    private static final ModelWithOverrides GENERATED_OVERRIDES = new ModelWithOverrides(new class_2960("item/generated"), class_4945.field_23006);
    private static final ModelWithOverrides GENERATED_OVERRIDES_1 = new ModelWithOverrides(new class_2960("item/generated"), class_4945.field_23006, LAYER1);
    private static final ModelWithOverrides HANDHELD_OVERRIDES = new ModelWithOverrides(new class_2960("item/handheld"), class_4945.field_23006);
    private static final ModelWithOverrides HANDHELD_OVERRIDES_2 = new ModelWithOverrides(new class_2960("item/handheld"), class_4945.field_23006, LAYER1, LAYER2);
    private final class_7784 packOutput;
    private static final String BUILTIN_ENTITY_DISPLAY_STR = "{\n\t\"gui\": {\n\t\t\"rotation\": [30, 45, 0],\n\t\t\"translation\": [0, 0, 0],\n\t\t\"scale\": [0.625, 0.625, 0.625]\n\t},\n\t\"ground\": {\n\t\t\"rotation\": [0, 0, 0],\n\t\t\"translation\": [0, 3, 0],\n\t\t\"scale\": [0.25, 0.25, 0.25]\n\t},\n\t\"head\": {\n\t\t\"rotation\": [0, 180, 0],\n\t\t\"translation\": [0, 0, 0],\n\t\t\"scale\": [1, 1, 1]\n\t},\n\t\"fixed\": {\n\t\t\"rotation\": [0, 180, 0],\n\t\t\"translation\": [0, 0, 0],\n\t\t\"scale\": [0.5, 0.5, 0.5]\n\t},\n\t\"thirdperson_righthand\": {\n\t\t\"rotation\": [75, 315, 0],\n\t\t\"translation\": [0, 2.5, 0],\n\t\t\"scale\": [0.375, 0.375, 0.375]\n\t},\n\t\"firstperson_righthand\": {\n\t\t\"rotation\": [0, 315, 0],\n\t\t\"translation\": [0, 0, 0],\n\t\t\"scale\": [0.4, 0.4, 0.4]\n\t}\n}";
    private static final JsonElement BUILTIN_ENTITY_DISPLAY = (JsonElement)new Gson().fromJson("{\n\t\"gui\": {\n\t\t\"rotation\": [30, 45, 0],\n\t\t\"translation\": [0, 0, 0],\n\t\t\"scale\": [0.625, 0.625, 0.625]\n\t},\n\t\"ground\": {\n\t\t\"rotation\": [0, 0, 0],\n\t\t\"translation\": [0, 3, 0],\n\t\t\"scale\": [0.25, 0.25, 0.25]\n\t},\n\t\"head\": {\n\t\t\"rotation\": [0, 180, 0],\n\t\t\"translation\": [0, 0, 0],\n\t\t\"scale\": [1, 1, 1]\n\t},\n\t\"fixed\": {\n\t\t\"rotation\": [0, 180, 0],\n\t\t\"translation\": [0, 0, 0],\n\t\t\"scale\": [0.5, 0.5, 0.5]\n\t},\n\t\"thirdperson_righthand\": {\n\t\t\"rotation\": [75, 315, 0],\n\t\t\"translation\": [0, 2.5, 0],\n\t\t\"scale\": [0.375, 0.375, 0.375]\n\t},\n\t\"firstperson_righthand\": {\n\t\t\"rotation\": [0, 315, 0],\n\t\t\"translation\": [0, 0, 0],\n\t\t\"scale\": [0.4, 0.4, 0.4]\n\t}\n}", JsonElement.class);

    public ItemModelProvider(class_7784 packOutput) {
        this.packOutput = packOutput;
    }

    public CompletableFuture<?> method_10319(class_7403 cache) {
        Set<class_1792> items = class_7923.field_41178.method_10220().filter(i -> "botania".equals(class_7923.field_41178.method_10221(i).method_12836())).collect(Collectors.toSet());
        HashMap map = new HashMap();
        this.registerItemBlocks(ItemModelProvider.takeAll(items, i -> i instanceof class_1747).stream().map(i -> (class_1747)i).collect(Collectors.toSet()), map::put);
        ItemModelProvider.registerItemOverrides(items, map::put);
        ItemModelProvider.registerItems(items, map::put);
        class_7784.class_7489 modelPathProvider = this.packOutput.method_45973(class_7784.class_7490.field_39368, "models");
        ArrayList<CompletableFuture> output = new ArrayList<CompletableFuture>();
        for (Map.Entry e : map.entrySet()) {
            class_2960 id = (class_2960)e.getKey();
            output.add(class_2405.method_10320((class_7403)cache, (JsonElement)((JsonElement)((Supplier)e.getValue()).get()), (Path)modelPathProvider.method_44107(id)));
        }
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    private static void registerItems(Set<class_1792> items, BiConsumer<class_2960, Supplier<JsonElement>> consumer) {
        items.remove(BotaniaItems.manaGun);
        ItemModelProvider.takeAll(items, i -> i instanceof LensItem).forEach(i -> {
            class_2960 lens = i == BotaniaItems.lensTime || i == BotaniaItems.lensWarp || i == BotaniaItems.lensFire || i == BotaniaItems.lensTripwire ? ResourceLocationHelper.prefix("item/lens_small") : ResourceLocationHelper.prefix("item/lens");
            GENERATED_1.method_25852(class_4941.method_25840((class_1792)i), class_4944.method_25895((class_2960)lens).method_25868(LAYER1, class_4944.method_25876((class_1792)i)), consumer);
        });
        GENERATED_1.method_25852(class_4941.method_25840((class_1792)BotaniaItems.bloodPendant), class_4944.method_25895((class_2960)class_4944.method_25876((class_1792)BotaniaItems.bloodPendant)).method_25868(LAYER1, class_4944.method_25863((class_1792)BotaniaItems.bloodPendant, (String)"_overlay")), consumer);
        items.remove(BotaniaItems.bloodPendant);
        HANDHELD_1.method_25852(class_4941.method_25840((class_1792)BotaniaItems.enderDagger), class_4944.method_25895((class_2960)class_4944.method_25876((class_1792)BotaniaItems.enderDagger)).method_25868(LAYER1, class_4944.method_25863((class_1792)BotaniaItems.enderDagger, (String)"_overlay")), consumer);
        items.remove(BotaniaItems.enderDagger);
        GENERATED_1.method_25852(class_4941.method_25840((class_1792)BotaniaItems.incenseStick), class_4944.method_25895((class_2960)class_4944.method_25876((class_1792)BotaniaItems.incenseStick)).method_25868(LAYER1, class_4944.method_25863((class_1792)BotaniaItems.incenseStick, (String)"_overlay")), consumer);
        items.remove(BotaniaItems.incenseStick);
        GENERATED_1.method_25852(class_4941.method_25840((class_1792)BotaniaItems.manaMirror), class_4944.method_25895((class_2960)class_4944.method_25876((class_1792)BotaniaItems.manaMirror)).method_25868(LAYER1, class_4944.method_25863((class_1792)BotaniaItems.manaMirror, (String)"_overlay")), consumer);
        items.remove(BotaniaItems.manaMirror);
        GENERATED_1.method_25852(class_4941.method_25840((class_1792)BotaniaItems.manaTablet), class_4944.method_25895((class_2960)class_4944.method_25876((class_1792)BotaniaItems.manaTablet)).method_25868(LAYER1, class_4944.method_25863((class_1792)BotaniaItems.manaTablet, (String)"_overlay")), consumer);
        items.remove(BotaniaItems.manaTablet);
        GENERATED_2.method_25852(class_4941.method_25840((class_1792)BotaniaItems.thirdEye), new class_4944().method_25868(class_4945.field_23006, class_4944.method_25863((class_1792)BotaniaItems.thirdEye, (String)"_0")).method_25868(LAYER1, class_4944.method_25863((class_1792)BotaniaItems.thirdEye, (String)"_1")).method_25868(LAYER2, class_4944.method_25863((class_1792)BotaniaItems.thirdEye, (String)"_2")), consumer);
        items.remove(BotaniaItems.thirdEye);
        ItemModelProvider.takeAll(items, BotaniaItems.cobbleRod, BotaniaItems.dirtRod, BotaniaItems.diviningRod, BotaniaItems.elementiumAxe, BotaniaItems.elementiumPick, BotaniaItems.elementiumShovel, BotaniaItems.elementiumHoe, BotaniaItems.elementiumSword, BotaniaItems.exchangeRod, BotaniaItems.fireRod, BotaniaItems.glassPick, BotaniaItems.gravityRod, BotaniaItems.manasteelAxe, BotaniaItems.manasteelPick, BotaniaItems.manasteelShears, BotaniaItems.manasteelShovel, BotaniaItems.manasteelHoe, BotaniaItems.missileRod, BotaniaItems.obedienceStick, BotaniaItems.rainbowRod, BotaniaItems.smeltRod, BotaniaItems.starSword, BotaniaItems.terraSword, BotaniaItems.terraformRod, BotaniaItems.thunderSword, BotaniaItems.waterRod, BotaniaItems.kingKey, BotaniaItems.skyDirtRod).forEach(i -> class_4943.field_22939.method_25852(class_4941.method_25840((class_1792)i), class_4944.method_25871((class_1792)i), consumer));
        ItemModelProvider.takeAll(items, i -> true).forEach(i -> class_4943.field_22938.method_25852(class_4941.method_25840((class_1792)i), class_4944.method_25871((class_1792)i), consumer));
    }

    private static void singleGeneratedOverride(class_1792 item, class_2960 overrideModel, class_2960 predicate, double value, BiConsumer<class_2960, Supplier<JsonElement>> consumer) {
        class_4943.field_22938.method_25852(overrideModel, class_4944.method_25895((class_2960)overrideModel), consumer);
        GENERATED_OVERRIDES.create(class_4941.method_25840((class_1792)item), class_4944.method_25871((class_1792)item), new OverrideHolder().add(overrideModel, Pair.of((Object)predicate, (Object)value)), consumer);
    }

    private static void singleGeneratedSuffixOverride(class_1792 item, String suffix, class_2960 predicate, double value, BiConsumer<class_2960, Supplier<JsonElement>> consumer) {
        ItemModelProvider.singleGeneratedOverride(item, class_4941.method_25841((class_1792)item, (String)suffix), predicate, value, consumer);
    }

    private static void singleHandheldOverride(class_1792 item, class_2960 overrideModel, class_2960 predicate, double value, BiConsumer<class_2960, Supplier<JsonElement>> consumer) {
        class_4943.field_22939.method_25852(overrideModel, class_4944.method_25895((class_2960)overrideModel), consumer);
        HANDHELD_OVERRIDES.create(class_4941.method_25840((class_1792)item), class_4944.method_25871((class_1792)item), new OverrideHolder().add(overrideModel, Pair.of((Object)predicate, (Object)value)), consumer);
    }

    private static void singleHandheldSuffixOverride(class_1792 item, String suffix, class_2960 predicate, double value, BiConsumer<class_2960, Supplier<JsonElement>> consumer) {
        ItemModelProvider.singleHandheldOverride(item, class_4941.method_25841((class_1792)item, (String)suffix), predicate, value, consumer);
    }

    private static void registerItemOverrides(Set<class_1792> items, BiConsumer<class_2960, Supplier<JsonElement>> consumer) {
        items.remove(BotaniaItems.livingwoodBow);
        items.remove(BotaniaItems.crystalBow);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.baubleBox, "_open", ResourceLocationHelper.prefix("open"), 1.0, consumer);
        items.remove(BotaniaItems.baubleBox);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.blackHoleTalisman, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(BotaniaItems.blackHoleTalisman);
        ItemModelProvider.registerBrewContainerOverrides((BaseBrewItem)BotaniaItems.brewFlask, BotaniaItems.flask, consumer);
        items.remove(BotaniaItems.brewFlask);
        ItemModelProvider.registerBrewContainerOverrides((BaseBrewItem)BotaniaItems.brewVial, BotaniaItems.vial, consumer);
        items.remove(BotaniaItems.brewVial);
        ItemModelProvider.singleHandheldOverride(BotaniaItems.elementiumShears, ResourceLocationHelper.prefix("item/dammitreddit"), ResourceLocationHelper.prefix("reddit"), 1.0, consumer);
        items.remove(BotaniaItems.elementiumShears);
        class_2960 vuvuzela = ResourceLocationHelper.prefix("item/vuvuzela");
        class_4943.field_22939.method_25852(vuvuzela, class_4944.method_25895((class_2960)vuvuzela), consumer);
        for (class_1792 i : new class_1792[]{BotaniaItems.grassHorn, BotaniaItems.leavesHorn, BotaniaItems.snowHorn}) {
            GENERATED_OVERRIDES.create(class_4941.method_25840((class_1792)i), class_4944.method_25871((class_1792)i), new OverrideHolder().add(vuvuzela, Pair.of((Object)ResourceLocationHelper.prefix("vuvuzela"), (Object)1.0)), consumer);
        }
        items.remove(BotaniaItems.grassHorn);
        items.remove(BotaniaItems.leavesHorn);
        items.remove(BotaniaItems.snowHorn);
        ItemModelProvider.singleGeneratedOverride(BotaniaItems.infiniteFruit, ResourceLocationHelper.prefix("item/dasboot"), ResourceLocationHelper.prefix("boot"), 1.0, consumer);
        items.remove(BotaniaItems.infiniteFruit);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.lexicon, "_elven", ResourceLocationHelper.prefix("elven"), 1.0, consumer);
        items.remove(BotaniaItems.lexicon);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.magnetRing, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(BotaniaItems.magnetRing);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.magnetRingGreater, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(BotaniaItems.magnetRingGreater);
        OverrideHolder bottleOverrides = new OverrideHolder();
        for (int i = 1; i < 6; ++i) {
            class_2960 overrideModel = class_4941.method_25841((class_1792)BotaniaItems.manaBottle, (String)("_" + i));
            class_4943.field_22938.method_25852(overrideModel, class_4944.method_25895((class_2960)overrideModel), consumer);
            bottleOverrides.add(overrideModel, Pair.of((Object)ResourceLocationHelper.prefix("swigs_taken"), (Object)((double)i / 5.0)));
        }
        GENERATED_OVERRIDES.create(class_4941.method_25840((class_1792)BotaniaItems.manaBottle), class_4944.method_25871((class_1792)BotaniaItems.manaBottle), bottleOverrides, consumer);
        items.remove(BotaniaItems.manaBottle);
        ItemModelProvider.singleGeneratedOverride(BotaniaItems.manaCookie, ResourceLocationHelper.prefix("item/totalbiscuit"), ResourceLocationHelper.prefix("totalbiscuit"), 1.0, consumer);
        items.remove(BotaniaItems.manaCookie);
        ItemModelProvider.singleHandheldOverride(BotaniaItems.manasteelSword, ResourceLocationHelper.prefix("item/elucidator"), ResourceLocationHelper.prefix("elucidator"), 1.0, consumer);
        items.remove(BotaniaItems.manasteelSword);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.manaweaveHelm, "_holiday", ResourceLocationHelper.prefix("holiday"), 1.0, consumer);
        items.remove(BotaniaItems.manaweaveHelm);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.manaweaveChest, "_holiday", ResourceLocationHelper.prefix("holiday"), 1.0, consumer);
        items.remove(BotaniaItems.manaweaveChest);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.manaweaveLegs, "_holiday", ResourceLocationHelper.prefix("holiday"), 1.0, consumer);
        items.remove(BotaniaItems.manaweaveLegs);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.manaweaveBoots, "_holiday", ResourceLocationHelper.prefix("holiday"), 1.0, consumer);
        items.remove(BotaniaItems.manaweaveBoots);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.slimeBottle, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(BotaniaItems.slimeBottle);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.spawnerMover, "_full", ResourceLocationHelper.prefix("full"), 1.0, consumer);
        items.remove(BotaniaItems.spawnerMover);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.temperanceStone, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(BotaniaItems.temperanceStone);
        ItemModelProvider.singleHandheldSuffixOverride(BotaniaItems.terraAxe, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(BotaniaItems.terraAxe);
        ItemModelProvider.singleGeneratedSuffixOverride(BotaniaItems.autocraftingHalo, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(BotaniaItems.autocraftingHalo);
        class_2960 enabledModel = class_4941.method_25841((class_1792)BotaniaItems.terraPick, (String)"_active");
        class_4943.field_22939.method_25852(enabledModel, class_4944.method_25895((class_2960)enabledModel), consumer);
        class_2960 tippedModel = class_4941.method_25841((class_1792)BotaniaItems.terraPick, (String)"_tipped");
        class_4943.field_22939.method_25852(tippedModel, class_4944.method_25895((class_2960)tippedModel), consumer);
        class_2960 tippedEnabledModel = class_4941.method_25841((class_1792)BotaniaItems.terraPick, (String)"_tipped_active");
        class_4943.field_22939.method_25852(tippedEnabledModel, class_4944.method_25895((class_2960)tippedEnabledModel), consumer);
        HANDHELD_OVERRIDES.create(class_4941.method_25840((class_1792)BotaniaItems.terraPick), class_4944.method_25871((class_1792)BotaniaItems.terraPick), new OverrideHolder().add(enabledModel, Pair.of((Object)ResourceLocationHelper.prefix("active"), (Object)1.0)).add(tippedModel, Pair.of((Object)ResourceLocationHelper.prefix("tipped"), (Object)1.0)).add(tippedEnabledModel, Pair.of((Object)ResourceLocationHelper.prefix("tipped"), (Object)1.0), Pair.of((Object)ResourceLocationHelper.prefix("active"), (Object)1.0)), consumer);
        items.remove(BotaniaItems.terraPick);
        ItemModelProvider.singleHandheldSuffixOverride(BotaniaItems.tornadoRod, "_active", ResourceLocationHelper.prefix("active"), 1.0, consumer);
        items.remove(BotaniaItems.tornadoRod);
        class_4944 twigWandTextures = class_4944.method_25871((class_1792)BotaniaItems.twigWand).method_25868(LAYER1, class_4944.method_25863((class_1792)BotaniaItems.twigWand, (String)"_top")).method_25868(LAYER2, class_4944.method_25863((class_1792)BotaniaItems.twigWand, (String)"_bottom"));
        class_2960 twigWandBind = class_4941.method_25841((class_1792)BotaniaItems.twigWand, (String)"_bind");
        HANDHELD_3.method_25852(twigWandBind, twigWandTextures.method_25879(LAYER3, class_4944.method_25863((class_1792)BotaniaItems.twigWand, (String)"_bind")), consumer);
        HANDHELD_OVERRIDES_2.create(class_4941.method_25840((class_1792)BotaniaItems.twigWand), twigWandTextures, new OverrideHolder().add(twigWandBind, Pair.of((Object)ResourceLocationHelper.prefix("bindmode"), (Object)1.0)), consumer);
        items.remove(BotaniaItems.twigWand);
        class_4944 dreamwoodWandTextures = class_4944.method_25871((class_1792)BotaniaItems.dreamwoodWand).method_25868(LAYER1, class_4944.method_25863((class_1792)BotaniaItems.dreamwoodWand, (String)"_top")).method_25868(LAYER2, class_4944.method_25863((class_1792)BotaniaItems.dreamwoodWand, (String)"_bottom"));
        class_2960 dreamwoodWandBind = class_4941.method_25841((class_1792)BotaniaItems.dreamwoodWand, (String)"_bind");
        HANDHELD_3.method_25852(dreamwoodWandBind, dreamwoodWandTextures.method_25879(LAYER3, class_4944.method_25863((class_1792)BotaniaItems.dreamwoodWand, (String)"_bind")), consumer);
        HANDHELD_OVERRIDES_2.create(class_4941.method_25840((class_1792)BotaniaItems.dreamwoodWand), dreamwoodWandTextures, new OverrideHolder().add(dreamwoodWandBind, Pair.of((Object)ResourceLocationHelper.prefix("bindmode"), (Object)1.0)), consumer);
        items.remove(BotaniaItems.dreamwoodWand);
    }

    private static void registerBrewContainerOverrides(BaseBrewItem brewItem, class_1792 emptyItem, BiConsumer<class_2960, Supplier<JsonElement>> consumer) {
        OverrideHolder flaskOverrides = new OverrideHolder();
        for (int i = 1; i < brewItem.getSwigs(); ++i) {
            class_2960 overrideModel = class_4941.method_25841((class_1792)brewItem, (String)("_" + i));
            GENERATED_1.method_25852(overrideModel, class_4944.method_25871((class_1792)emptyItem).method_25868(LAYER1, overrideModel), consumer);
            flaskOverrides.add(overrideModel, Pair.of((Object)ResourceLocationHelper.prefix("swigs_taken"), (Object)((double)i / (double)(brewItem.getSwigs() - 1))));
        }
        GENERATED_OVERRIDES_1.create(class_4941.method_25840((class_1792)brewItem), class_4944.method_25871((class_1792)emptyItem).method_25868(LAYER1, class_4944.method_25863((class_1792)brewItem, (String)"_0")), flaskOverrides, consumer);
    }

    private void registerItemBlocks(Set<class_1747> itemBlocks, BiConsumer<class_2960, Supplier<JsonElement>> consumer) {
        itemBlocks.remove(BotaniaBlocks.corporeaCrystalCube.method_8389());
        itemBlocks.removeIf(i -> {
            class_2960 id = class_7923.field_41175.method_10221((Object)i.method_7711());
            return id.method_12836().equals("botania") && i.method_7711() instanceof FloatingFlowerBlock;
        });
        GENERATED_1.method_25852(class_4941.method_25840((class_1792)BotaniaBlocks.animatedTorch.method_8389()), class_4944.method_25911((class_2248)class_2246.field_10523).method_25868(LAYER1, ResourceLocationHelper.prefix("block/animated_torch_glimmer")), consumer);
        itemBlocks.remove(BotaniaBlocks.animatedTorch.method_8389());
        class_4943.field_22945.method_25852(class_4941.method_25840((class_1792)BotaniaBlocks.gaiaHead.method_8389()), new class_4944(), consumer);
        itemBlocks.remove(BotaniaBlocks.gaiaHead.method_8389());
        ItemModelProvider.takeAll(itemBlocks, i -> i.method_7711() instanceof BotaniaDoubleFlowerBlock).forEach(i -> class_4943.field_22938.method_25852(class_4941.method_25840((class_1792)i), class_4944.method_25895((class_2960)class_4944.method_25866((class_2248)i.method_7711(), (String)"_top")), consumer));
        ItemModelProvider.takeAll(itemBlocks, i -> i.method_7711() instanceof PetalBlock).forEach(i -> consumer.accept(class_4941.method_25840((class_1792)i), (Supplier<JsonElement>)new class_4940(ResourceLocationHelper.prefix("block/petal_block"))));
        ItemModelProvider.takeAll(itemBlocks, BotaniaBlocks.livingwoodFramed.method_8389(), BotaniaBlocks.dreamwoodFramed.method_8389()).forEach(i -> {
            String name = i == BotaniaBlocks.livingwoodFramed.method_8389() ? "livingwood" : "dreamwood";
            consumer.accept(class_4941.method_25840((class_1792)i), (Supplier<JsonElement>)new class_4940(ResourceLocationHelper.prefix("block/framed_" + name + "_horizontal_z")));
        });
        consumer.accept(class_4941.method_25840((class_1792)BotaniaBlocks.livingwoodFramed.method_8389()), (Supplier<JsonElement>)new class_4940(ResourceLocationHelper.prefix("block/framed_livingwood_horizontal_z")));
        consumer.accept(class_4941.method_25840((class_1792)BotaniaBlocks.dreamwoodFramed.method_8389()), (Supplier<JsonElement>)new class_4940(ResourceLocationHelper.prefix("block/framed_dreamwood_horizontal_z")));
        itemBlocks.remove(BotaniaBlocks.livingwoodFramed.method_8389());
        itemBlocks.remove(BotaniaBlocks.dreamwoodFramed.method_8389());
        ItemModelProvider.takeAll(itemBlocks, i -> i.method_7711() instanceof class_2389).forEach(i -> {
            String name = class_7923.field_41178.method_10221(i).method_12832();
            String baseName = name.substring(0, name.length() - "_pane".length());
            class_4943.field_22938.method_25852(class_4941.method_25840((class_1792)i), class_4944.method_25895((class_2960)ResourceLocationHelper.prefix("block/" + baseName)), consumer);
        });
        Predicate<class_1747> defaultGenerated = i -> {
            class_2248 b = i.method_7711();
            return XplatAbstractions.INSTANCE.isSpecialFlowerBlock(b) || b instanceof BotaniaMushroomBlock || b instanceof LuminizerBlock || b instanceof BotaniaFlowerBlock || b == BotaniaBlocks.ghostRail;
        };
        ItemModelProvider.takeAll(itemBlocks, defaultGenerated).forEach(i -> class_4943.field_22938.method_25852(class_4941.method_25840((class_1792)i), class_4944.method_25911((class_2248)i.method_7711()), consumer));
        ItemModelProvider.takeAll(itemBlocks, b -> b.method_7711() instanceof FlowerMotifBlock).forEach(i -> {
            String name = class_7923.field_41178.method_10221(i).method_12832();
            class_2960 texName = ResourceLocationHelper.prefix("block/" + name.replace("_motif", ""));
            class_4943.field_22938.method_25852(class_4941.method_25840((class_1792)i), class_4944.method_25895((class_2960)texName), consumer);
        });
        ItemModelProvider.takeAll(itemBlocks, i -> i.method_7711() instanceof ManaPoolBlock).forEach(i -> {
            class_2960 fullModel = class_4941.method_25843((class_2248)i.method_7711(), (String)"_full");
            OverrideHolder overrides = new OverrideHolder().add(fullModel, Pair.of((Object)ResourceLocationHelper.prefix("full"), (Object)1.0));
            consumer.accept(class_4941.method_25840((class_1792)i), (Supplier<JsonElement>)((Object)new SimpleModelSupplierWithOverrides(class_4941.method_25842((class_2248)i.method_7711()), overrides)));
        });
        ItemModelProvider.takeAll(itemBlocks, (class_1747[])Stream.of(BotaniaBlocks.livingwoodWall, BotaniaBlocks.livingwoodStrippedWall, BotaniaBlocks.dreamwoodWall, BotaniaBlocks.dreamwoodStrippedWall).map(b -> (class_1747)b.method_8389()).toArray(class_1747[]::new)).forEach(i -> {
            String name = class_7923.field_41178.method_10221(i).method_12832();
            String baseName = name.substring(0, name.length() - "_wall".length()) + "_log";
            class_4943.field_22994.method_25852(class_4941.method_25840((class_1792)i), new class_4944().method_25868(class_4945.field_23027, ResourceLocationHelper.prefix("block/" + baseName)), consumer);
        });
        ItemModelProvider.takeAll(itemBlocks, i -> i.method_7711() instanceof class_2544).forEach(i -> {
            String name = class_7923.field_41178.method_10221(i).method_12832();
            String baseName = name.substring(0, name.length() - "_wall".length());
            class_4943.field_22994.method_25852(class_4941.method_25840((class_1792)i), new class_4944().method_25868(class_4945.field_23027, ResourceLocationHelper.prefix("block/" + baseName)), consumer);
        });
        ItemModelProvider.takeAll(itemBlocks, i -> i.method_7711() instanceof ManaSpreaderBlock).forEach(i -> {
            String name = class_7923.field_41178.method_10221(i).method_12832();
            Object outside = i.method_7711() == BotaniaBlocks.elvenSpreader ? "dreamwood_log_3" : (i.method_7711() == BotaniaBlocks.gaiaSpreader ? name + "_outside" : "livingwood_log");
            Object inside = i.method_7711() == BotaniaBlocks.elvenSpreader ? "stripped_dreamwood_log_3" : (i.method_7711() == BotaniaBlocks.gaiaSpreader ? name + "_inside" : "stripped_livingwood_log");
            SPREADER.method_25852(class_4941.method_25840((class_1792)i), new class_4944().method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)i.method_7711(), (String)"_side")).method_25868(OUTSIDE, ResourceLocationHelper.prefix("block/" + (String)outside)).method_25868(class_4945.field_23017, class_4944.method_25866((class_2248)i.method_7711(), (String)"_back")).method_25868(class_4945.field_27791, ResourceLocationHelper.prefix("block/" + (String)inside)).method_25868(CORE, class_4944.method_25866((class_2248)i.method_7711(), (String)"_core")), consumer);
        });
        ItemModelProvider.takeAll(itemBlocks, BotaniaBlocks.avatar.method_8389(), BotaniaBlocks.bellows.method_8389(), BotaniaBlocks.brewery.method_8389(), BotaniaBlocks.corporeaIndex.method_8389(), BotaniaBlocks.gaiaPylon.method_8389(), BotaniaBlocks.hourglass.method_8389(), BotaniaBlocks.manaPylon.method_8389(), BotaniaBlocks.naturaPylon.method_8389()).forEach(i -> this.builtinEntity((class_1792)i, consumer));
        ItemModelProvider.takeAll(itemBlocks, BotaniaBlocks.teruTeruBozu.method_8389()).forEach(i -> this.builtinEntity((class_1792)i, consumer, 2.5));
        ItemModelProvider.takeAll(itemBlocks, i -> i instanceof MysticalPetalItem).forEach(i -> class_4943.field_22938.method_25852(class_4941.method_25840((class_1792)i), class_4944.method_25895((class_2960)class_4944.method_25876((class_1792)i)), consumer));
        class_4943.field_22990.method_25852(class_4941.method_25840((class_1792)BotaniaBlocks.dreamwoodFence.method_8389()), class_4944.method_25872((class_2248)BotaniaBlocks.dreamwoodPlanks), consumer);
        itemBlocks.remove(BotaniaBlocks.dreamwoodFence.method_8389());
        class_4943.field_22990.method_25852(class_4941.method_25840((class_1792)BotaniaBlocks.livingwoodFence.method_8389()), class_4944.method_25872((class_2248)BotaniaBlocks.livingwoodPlanks), consumer);
        itemBlocks.remove(BotaniaBlocks.livingwoodFence.method_8389());
        consumer.accept(class_4941.method_25840((class_1792)BotaniaBlocks.elfGlass.method_8389()), (Supplier<JsonElement>)new class_4940(ResourceLocationHelper.prefix("block/elf_glass_0")));
        itemBlocks.remove(BotaniaBlocks.elfGlass.method_8389());
        WALL_INVENTORY.method_25852(class_4941.method_25840((class_1792)BotaniaBlocks.biomeBrickPlainsWall.method_8389()), new class_4944().method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)BotaniaBlocks.biomeBrickPlains, (String)"_top")).method_25868(class_4945.field_23014, class_4944.method_25866((class_2248)BotaniaBlocks.biomeBrickPlains, (String)"_top")).method_25868(class_4945.field_23027, class_4944.method_25860((class_2248)BotaniaBlocks.biomeBrickPlains)), consumer);
        itemBlocks.remove(BotaniaBlocks.biomeBrickPlainsWall.method_8389());
        WALL_INVENTORY_CHECKERED.method_25852(class_4941.method_25840((class_1792)BotaniaBlocks.biomeBrickMesaWall.method_8389()), new class_4944().method_25868(class_4945.field_23018, class_4944.method_25860((class_2248)BotaniaBlocks.biomeBrickMesa)).method_25868(class_4945.field_23019, class_4944.method_25866((class_2248)BotaniaBlocks.biomeBrickMesa, (String)"_mirrored")), consumer);
        itemBlocks.remove(BotaniaBlocks.biomeBrickMesaWall.method_8389());
        itemBlocks.forEach(i -> consumer.accept(class_4941.method_25840((class_1792)i), (Supplier<JsonElement>)new class_4940(class_4941.method_25842((class_2248)i.method_7711()))));
    }

    protected void builtinEntity(class_1792 i, BiConsumer<class_2960, Supplier<JsonElement>> consumer) {
        this.builtinEntity(i, consumer, 0.0);
    }

    protected void builtinEntity(class_1792 i, BiConsumer<class_2960, Supplier<JsonElement>> consumer, double handYOffset) {
        JsonElement display;
        if (handYOffset == 0.0) {
            display = BUILTIN_ENTITY_DISPLAY;
        } else {
            display = BUILTIN_ENTITY_DISPLAY.deepCopy();
            display.getAsJsonObject().getAsJsonObject("firstperson_righthand").getAsJsonArray("translation").set(1, (JsonElement)new JsonPrimitive((Number)handYOffset));
        }
        consumer.accept(class_4941.method_25840((class_1792)i), () -> {
            JsonObject json = new JsonObject();
            json.addProperty("parent", "minecraft:builtin/entity");
            json.add("display", display);
            return json;
        });
    }

    @SafeVarargs
    public static <T> Collection<T> takeAll(Set<? extends T> src, T ... items) {
        List<T> ret = Arrays.asList(items);
        for (T item : items) {
            if (src.contains(item)) continue;
            BotaniaAPI.LOGGER.warn("Item {} not found in set", item);
        }
        if (!src.removeAll(ret)) {
            BotaniaAPI.LOGGER.warn("takeAll array didn't yield anything ({})", (Object)Arrays.toString(items));
        }
        return ret;
    }

    public static <T> Collection<T> takeAll(Set<T> src, Predicate<T> pred) {
        ArrayList<T> ret = new ArrayList<T>();
        Iterator<T> iter = src.iterator();
        while (iter.hasNext()) {
            T item = iter.next();
            if (!pred.test(item)) continue;
            iter.remove();
            ret.add(item);
        }
        if (ret.isEmpty()) {
            BotaniaAPI.LOGGER.warn("takeAll predicate yielded nothing", new Throwable());
        }
        return ret;
    }

    @NotNull
    public String method_10321() {
        return "Botania item models";
    }
}

