/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.mana.BasicLensItem;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.common.block.BotaniaWaterloggedBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.mana.ManaSpreaderBlockEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.item.WandOfTheForestItem;

public class ManaSpreaderBlock
extends BotaniaWaterloggedBlock
implements class_2343 {
    private static final class_265 SHAPE = ManaSpreaderBlock.method_9541((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
    private static final class_265 SHAPE_PADDING = ManaSpreaderBlock.method_9541((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    private static final class_265 SHAPE_SCAFFOLDING = ManaSpreaderBlock.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public final Variant variant;

    public ManaSpreaderBlock(Variant v, class_4970.class_2251 builder) {
        super(builder);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)BotaniaStateProperties.HAS_SCAFFOLDING, (Comparable)Boolean.valueOf(false)));
        this.variant = v;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{BotaniaStateProperties.HAS_SCAFFOLDING});
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public class_265 method_9530(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 collisionContext) {
        class_265 class_2652;
        if (((Boolean)blockState.method_11654((class_2769)BotaniaStateProperties.HAS_SCAFFOLDING)).booleanValue()) {
            return SHAPE_SCAFFOLDING;
        }
        class_2586 be = blockGetter.method_8321(blockPos);
        if (be instanceof ManaSpreaderBlockEntity) {
            ManaSpreaderBlockEntity spreader = (ManaSpreaderBlockEntity)be;
            if (spreader.paddingColor != null) {
                class_2652 = SHAPE_PADDING;
                return class_2652;
            }
        }
        class_2652 = SHAPE;
        return class_2652;
    }

    @NotNull
    public class_265 method_9571(class_2680 state, @NotNull class_1922 world, @NotNull class_2338 pos) {
        return SHAPE;
    }

    public float method_9575(class_2680 state, class_1922 level, class_2338 pos) {
        return 1.0f;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        class_2350 orientation = placer == null ? class_2350.field_11039 : class_2350.method_10159((class_1297)placer)[0].method_10153();
        ManaSpreaderBlockEntity spreader = (ManaSpreaderBlockEntity)world.method_8321(pos);
        switch (orientation) {
            case field_11033: {
                spreader.rotationY = -90.0f;
                break;
            }
            case field_11036: {
                spreader.rotationY = 90.0f;
                break;
            }
            case field_11043: {
                spreader.rotationX = 270.0f;
                break;
            }
            case field_11035: {
                spreader.rotationX = 90.0f;
                break;
            }
            case field_11039: {
                break;
            }
            case field_11034: {
                spreader.rotationX = 180.0f;
            }
        }
    }

    @NotNull
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        boolean shouldInsert;
        class_2586 tile = world.method_8321(pos);
        if (!(tile instanceof ManaSpreaderBlockEntity)) {
            return class_1269.field_5811;
        }
        ManaSpreaderBlockEntity spreader = (ManaSpreaderBlockEntity)tile;
        class_1799 heldItem = player.method_5998(hand);
        if (heldItem.method_7909() instanceof WandOfTheForestItem) {
            return class_1269.field_5811;
        }
        boolean mainHandEmpty = player.method_6047().method_7960();
        class_1799 lens = spreader.getItemHandler().method_5438(0);
        boolean playerHasLens = heldItem.method_7909() instanceof BasicLensItem;
        boolean lensIsSame = playerHasLens && class_1799.method_31577((class_1799)heldItem, (class_1799)lens);
        class_1799 wool = spreader.paddingColor != null ? new class_1799((class_1935)ColorHelper.WOOL_MAP.apply(spreader.paddingColor)) : class_1799.field_8037;
        boolean playerHasWool = ColorHelper.isWool(class_2248.method_9503((class_1792)heldItem.method_7909()));
        boolean woolIsSame = playerHasWool && class_1799.method_31577((class_1799)heldItem, (class_1799)wool);
        boolean playerHasScaffolding = !heldItem.method_7960() && heldItem.method_31574(class_1802.field_16482);
        boolean bl = shouldInsert = playerHasLens && !lensIsSame || playerHasWool && !woolIsSame || playerHasScaffolding && (Boolean)state.method_11654((class_2769)BotaniaStateProperties.HAS_SCAFFOLDING) == false;
        if (shouldInsert) {
            if (playerHasLens) {
                class_1799 toInsert = heldItem.method_7971(1);
                if (!lens.method_7960()) {
                    player.method_31548().method_7398(lens);
                }
                spreader.getItemHandler().method_5447(0, toInsert);
                world.method_8396(player, pos, BotaniaSounds.spreaderAddLens, class_3419.field_15245, 1.0f, 1.0f);
            } else if (playerHasWool) {
                class_2248 woolBlock = class_2248.method_9503((class_1792)heldItem.method_7909());
                heldItem.method_7934(1);
                if (spreader.paddingColor != null) {
                    class_1799 spreaderWool = new class_1799((class_1935)ColorHelper.WOOL_MAP.apply(spreader.paddingColor));
                    player.method_31548().method_7398(spreaderWool);
                }
                spreader.paddingColor = ColorHelper.getWoolColor(woolBlock);
                spreader.method_5431();
                world.method_8396(player, pos, BotaniaSounds.spreaderCover, class_3419.field_15245, 1.0f, 1.0f);
            } else {
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)BotaniaStateProperties.HAS_SCAFFOLDING, (Comparable)Boolean.valueOf(true)));
                world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
                if (!player.method_31549().field_7477) {
                    heldItem.method_7934(1);
                }
                world.method_8396(player, pos, BotaniaSounds.spreaderScaffold, class_3419.field_15245, 1.0f, 1.0f);
            }
            return class_1269.method_29236((boolean)world.method_8608());
        }
        if (((Boolean)state.method_11654((class_2769)BotaniaStateProperties.HAS_SCAFFOLDING)).booleanValue() && player.method_21823()) {
            if (!player.method_31549().field_7477) {
                class_1799 scaffolding = new class_1799((class_1935)class_1802.field_16482);
                player.method_31548().method_7398(scaffolding);
            }
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)BotaniaStateProperties.HAS_SCAFFOLDING, (Comparable)Boolean.valueOf(false)));
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
            world.method_8396(player, pos, BotaniaSounds.spreaderUnScaffold, class_3419.field_15245, 1.0f, 1.0f);
            return class_1269.method_29236((boolean)world.method_8608());
        }
        if (!lens.method_7960() && (mainHandEmpty || lensIsSame)) {
            player.method_31548().method_7398(lens);
            spreader.getItemHandler().method_5447(0, class_1799.field_8037);
            world.method_8396(player, pos, BotaniaSounds.spreaderRemoveLens, class_3419.field_15245, 1.0f, 1.0f);
            return class_1269.method_29236((boolean)world.method_8608());
        }
        if (spreader.paddingColor != null && (mainHandEmpty || woolIsSame)) {
            player.method_31548().method_7398(wool);
            spreader.paddingColor = null;
            spreader.method_5431();
            world.method_8396(player, pos, BotaniaSounds.spreaderUncover, class_3419.field_15245, 1.0f, 1.0f);
            return class_1269.method_29236((boolean)world.method_8608());
        }
        return class_1269.field_5811;
    }

    public void method_9536(@NotNull class_2680 state, @NotNull class_1937 world, @NotNull class_2338 pos, @NotNull class_2680 newState, boolean isMoving) {
        if (!state.method_27852(newState.method_26204())) {
            class_2586 tile = world.method_8321(pos);
            if (!(tile instanceof ManaSpreaderBlockEntity)) {
                return;
            }
            ManaSpreaderBlockEntity spreader = (ManaSpreaderBlockEntity)tile;
            if (spreader.paddingColor != null) {
                class_1799 padding = new class_1799((class_1935)ColorHelper.WOOL_MAP.apply(spreader.paddingColor));
                class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)padding);
            }
            if (((Boolean)state.method_11654((class_2769)BotaniaStateProperties.HAS_SCAFFOLDING)).booleanValue()) {
                class_1799 scaffolding = new class_1799((class_1935)class_1802.field_16482);
                class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)scaffolding);
            }
            class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)spreader.getItemHandler());
            super.method_9536(state, world, pos, newState, isMoving);
        }
    }

    @NotNull
    public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
        return new ManaSpreaderBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        return ManaSpreaderBlock.createTickerHelper(type, BotaniaBlockEntities.SPREADER, ManaSpreaderBlockEntity::commonTick);
    }

    public static enum Variant {
        MANA(160, 1000, 0x20FF20, 65280, 60, 4.0f, 1.0f),
        REDSTONE(160, 1000, 0xFF2020, 0xFF0000, 60, 4.0f, 1.0f),
        ELVEN(240, 1000, 16729540, 16711854, 80, 4.0f, 1.25f),
        GAIA(640, 6400, 0x20FF20, 65280, 120, 20.0f, 2.0f);

        public final int burstMana;
        public final int manaCapacity;
        public final int color;
        public final int hudColor;
        public final int preLossTicks;
        public final float lossPerTick;
        public final float motionModifier;

        private Variant(int bm, int mc, int c, int hc, int plt, float lpt, float mm) {
            this.burstMana = bm;
            this.manaCapacity = mc;
            this.color = c;
            this.hudColor = hc;
            this.preLossTicks = plt;
            this.lossPerTick = lpt;
            this.motionModifier = mm;
        }
    }
}

