/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_1533;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.block_entity.BindableSpecialFlowerBlockEntity;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.flower.functional.SpectranthemumBlockEntity;
import vazkii.botania.common.helper.DelayHelper;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.common.helper.FilterHelper;
import vazkii.botania.common.helper.InventoryHelper;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.internal_caps.ItemFlagsComponent;
import vazkii.botania.xplat.XplatAbstractions;

public class HopperhockBlockEntity
extends FunctionalFlowerBlockEntity
implements Wandable {
    private static final String TAG_FILTER_TYPE = "filterType";
    private static final int RANGE_MANA = 10;
    private static final int RANGE = 6;
    private static final int RANGE_MANA_MINI = 2;
    private static final int RANGE_MINI = 1;
    private int filterType = 0;

    protected HopperhockBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public HopperhockBlockEntity(class_2338 pos, class_2680 state) {
        this(BotaniaFlowerBlocks.HOPPERHOCK, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.method_10997().field_9236 || this.redstoneSignal > 0) {
            return;
        }
        boolean pulledAny = false;
        int range = this.getRange();
        class_2338 inPos = this.method_11016();
        class_2338 outPos = this.getEffectivePos();
        Predicate<class_1542> shouldPickup = item -> {
            if (XplatAbstractions.INSTANCE.preventsRemoteMovement((class_1542)item)) {
                return false;
            }
            ItemFlagsComponent flags = XplatAbstractions.INSTANCE.itemFlagsComponent((class_1542)item);
            if (flags.spawnedByInWorldRecipe()) {
                return flags.timeCounter >= 5 + this.getModulatedDelay();
            }
            return DelayHelper.canInteractWith(this, item);
        };
        List items = this.method_10997().method_8390(class_1542.class, new class_238(inPos.method_10069(-range, -range, -range), inPos.method_10069(range + 1, range + 1, range + 1)), shouldPickup);
        for (class_1542 item2 : items) {
            class_1799 stack = item2.method_6983();
            boolean priorityInv = false;
            int amountToPutIn = 0;
            class_2350 direction = null;
            for (class_2350 dir : class_2350.values()) {
                boolean priority;
                class_2350 sideOfInventory;
                class_2338 inventoryPos = outPos.method_10093(dir);
                if (!XplatAbstractions.INSTANCE.hasInventory(this.field_11863, inventoryPos, sideOfInventory = dir.method_10153())) continue;
                List<class_1799> filter = HopperhockBlockEntity.getFilterForInventory(this.method_10997(), inventoryPos, true);
                boolean canAccept = HopperhockBlockEntity.canAcceptItem(stack, filter, this.filterType);
                class_1799 simulate = XplatAbstractions.INSTANCE.insertToInventory(this.field_11863, inventoryPos, sideOfInventory, stack, true);
                int inserted = stack.method_7947() - simulate.method_7947();
                boolean bl = canAccept = canAccept && inserted > 0;
                if (!canAccept) continue;
                boolean bl2 = priority = !filter.isEmpty();
                if (priorityInv && !priority) continue;
                priorityInv = priority;
                amountToPutIn = inserted;
                direction = dir;
            }
            if (direction == null || !item2.method_5805()) continue;
            SpectranthemumBlockEntity.spawnExplosionParticles((class_1297)item2, 3);
            InventoryHelper.checkEmpty(XplatAbstractions.INSTANCE.insertToInventory(this.field_11863, outPos.method_10093(direction), direction.method_10153(), stack.method_7971(amountToPutIn), false));
            EntityHelper.syncItem(item2);
            pulledAny = true;
        }
        if (pulledAny && this.getMana() > 0) {
            this.addMana(-1);
        }
    }

    public static boolean canAcceptItem(class_1799 stack, List<class_1799> filter, int filterType) {
        if (stack.method_7960()) {
            return false;
        }
        if (filter.isEmpty()) {
            return true;
        }
        switch (filterType) {
            case 0: {
                boolean anyFilter = false;
                for (class_1799 filterEntry : filter) {
                    if (filterEntry == null || filterEntry.method_7960()) continue;
                    anyFilter = true;
                    if (!ItemNBTHelper.matchTagAndManaFullness(stack, filterEntry)) continue;
                    return true;
                }
                return !anyFilter;
            }
            case 1: {
                return !HopperhockBlockEntity.canAcceptItem(stack, filter, 0);
            }
        }
        return true;
    }

    public static List<class_1799> getFilterForInventory(class_1937 level, class_2338 pos, boolean recursiveForDoubleChests) {
        class_2338 other;
        class_2745 type;
        class_2680 chest;
        ArrayList<class_1799> filter = new ArrayList<class_1799>();
        if (recursiveForDoubleChests && (chest = level.method_8320(pos)).method_28498((class_2769)class_2281.field_10770) && (type = (class_2745)chest.method_11654((class_2769)class_2281.field_10770)) != class_2745.field_12569 && level.method_8320(other = pos.method_10093(class_2281.method_9758((class_2680)chest))).method_27852(chest.method_26204())) {
            filter.addAll(HopperhockBlockEntity.getFilterForInventory(level, other, false));
        }
        for (class_2350 dir : class_2350.values()) {
            class_238 aabb = new class_238(pos.method_10093(dir));
            List frames = level.method_18467(class_1533.class, aabb);
            for (class_1533 frame : frames) {
                if (frame.method_5735() != dir) continue;
                filter.addAll(FilterHelper.getFilterItems(frame));
            }
        }
        return filter;
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public boolean onUsedByWand(@Nullable class_1657 player, class_1799 wand, class_2350 side) {
        if (player == null || player.method_5715()) {
            this.filterType = this.filterType == 2 ? 0 : this.filterType + 1;
            this.sync();
            return true;
        }
        return false;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), this.getRange());
    }

    @Override
    public RadiusDescriptor getSecondaryRadius() {
        return RadiusDescriptor.Rectangle.square(this.method_11016(), 1);
    }

    public int getRange() {
        return this.getMana() > 0 ? 10 : 6;
    }

    @Override
    public void writeToPacketNBT(class_2487 cmp) {
        super.writeToPacketNBT(cmp);
        cmp.method_10569(TAG_FILTER_TYPE, this.filterType);
    }

    @Override
    public void readFromPacketNBT(class_2487 cmp) {
        super.readFromPacketNBT(cmp);
        this.filterType = cmp.method_10550(TAG_FILTER_TYPE);
    }

    @Override
    public int getMaxMana() {
        return 20;
    }

    @Override
    public int getColor() {
        return 0x7F7F7F;
    }

    public static class Mini
    extends HopperhockBlockEntity {
        public Mini(class_2338 pos, class_2680 state) {
            super(BotaniaFlowerBlocks.HOPPERHOCK_CHIBI, pos, state);
        }

        @Override
        public int getRange() {
            return this.getMana() > 0 ? 2 : 1;
        }
    }

    public static class WandHud
    extends BindableSpecialFlowerBlockEntity.BindableFlowerWandHud<HopperhockBlockEntity> {
        public WandHud(HopperhockBlockEntity flower) {
            super(flower);
        }

        @Override
        public void renderHUD(class_332 gui, class_310 mc) {
            String filter = class_1074.method_4662((String)("botaniamisc.filter" + ((HopperhockBlockEntity)this.flower).filterType), (Object[])new Object[0]);
            int filterWidth = mc.field_1772.method_1727(filter);
            int filterTextStart = (mc.method_22683().method_4486() - filterWidth) / 2;
            int halfMinWidth = (filterWidth + 4) / 2;
            int centerY = mc.method_22683().method_4502() / 2;
            super.renderHUD(gui, mc, halfMinWidth, halfMinWidth, 40);
            gui.method_25303(mc.field_1772, filter, filterTextStart, centerY + 30, ((HopperhockBlockEntity)this.flower).getColor());
        }
    }
}

