/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.entity;

import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1688;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.annotations.SoftImplement;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.mana.ManaPoolBlockEntity;
import vazkii.botania.common.block.block_entity.mana.ManaPumpBlockEntity;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.xplat.XplatAbstractions;

public class ManaPoolMinecartEntity extends class_1688 {
	private static final int TRANSFER_RATE = 10000;
	private static final String TAG_MANA = "mana";
	private static final class_2940<Integer> MANA = class_2945.method_12791(ManaPoolMinecartEntity.class, class_2943.field_13327);

	public ManaPoolMinecartEntity(class_1299<ManaPoolMinecartEntity> type, class_1937 world) {
		super(type, world);
	}

	public ManaPoolMinecartEntity(class_1937 world, double x, double y, double z) {
		super(BotaniaEntities.POOL_MINECART, world, x, y, z);
	}

	@Override
	protected void method_5693() {
		super.method_5693();
		field_6011.method_12784(MANA, 0);
	}

	@NotNull
	@Override
	public class_2680 method_7519() {
		return BotaniaBlocks.manaPool.method_9564();
	}

	@NotNull
	@Override
	public class_1688.class_1689 method_7518() {
		return class_1689.field_7674;
	}

	@Override
	protected boolean method_5818(class_1297 passenger) {
		return false;
	}

	@Override
	protected void method_7525() {
		float f = 0.98F;
		this.method_18799(method_18798().method_18805(f, 0, f));
	}

	@NotNull
	@Override
	public class_1799 method_31480() {
		return new class_1799(BotaniaItems.poolMinecart);
	}

	@Override
	public int method_7526() {
		return 8;
	}

	@Override
	public void method_5773() {
		super.method_5773();

		if (method_37908().field_9236) {
			double particleChance = 1F - (double) getMana() / (double) ManaPoolBlockEntity.MAX_MANA * 0.1;
			int color = ManaPoolBlockEntity.PARTICLE_COLOR;
			float red = (color >> 16 & 0xFF) / 255F;
			float green = (color >> 8 & 0xFF) / 255F;
			float blue = (color & 0xFF) / 255F;
			double x = class_3532.method_15357(method_23317());
			double y = class_3532.method_15357(method_23318());
			double z = class_3532.method_15357(method_23321());
			if (Math.random() > particleChance) {
				WispParticleData data = WispParticleData.wisp((float) Math.random() / 3F, red, green, blue, 2F);
				method_37908().method_8406(data, x + 0.3 + Math.random() * 0.5, y + 0.85 + Math.random() * 0.25, z + Math.random(), 0, (float) Math.random() / 25F, 0);
			}
		}
	}

	@Override
	public void method_7513(class_2338 pos, class_2680 state) {
		super.method_7513(pos, state);

		for (class_2350 dir : class_2350.class_2353.field_11062) {
			class_2338 pumpPos = pos.method_10093(dir);
			class_2680 pumpState = method_37908().method_8320(pumpPos);
			if (pumpState.method_27852(BotaniaBlocks.pump)) {
				ManaPumpBlockEntity pump = (ManaPumpBlockEntity) method_37908().method_8321(pumpPos);
				class_2338 poolPos = pumpPos.method_10093(dir);
				var receiver = XplatAbstractions.INSTANCE.findManaReceiver(method_37908(), poolPos, dir.method_10153());

				if (receiver instanceof ManaPool pool) {
					class_2350 pumpDir = pumpState.method_11654(class_2741.field_12481);
					boolean did = false;
					boolean can = false;

					if (pumpDir == dir) { // Pool -> Cart
						can = true;

						if (!pump.hasRedstone) {
							int cartMana = getMana();
							int poolMana = pool.getCurrentMana();
							int transfer = Math.min(TRANSFER_RATE, poolMana);
							int actualTransfer = Math.min(ManaPoolBlockEntity.MAX_MANA - cartMana, transfer);
							if (actualTransfer > 0) {
								pool.receiveMana(-transfer);
								setMana(cartMana + actualTransfer);
								did = true;
							}
						}
					} else if (pumpDir == dir.method_10153()) { // Cart -> Pool
						can = true;

						if (!pump.hasRedstone && !pool.isFull()) {
							int cartMana = getMana();
							int transfer = Math.min(TRANSFER_RATE, cartMana);
							if (transfer > 0) {
								pool.receiveMana(transfer);
								setMana(cartMana - transfer);
								did = true;
							}
						}
					}

					if (did) {
						pump.hasCart = true;
						pump.setActive(true);
					}

					if (can) {
						pump.hasCartOnTop = true;
						pump.comparator = (int) ((double) getMana() / (double) ManaPoolBlockEntity.MAX_MANA * 15); // different from ManaPoolBlockEntity.calculateComparatorLevel, kept for compatibility
					}

				}
			}
		}
	}

	@Override
	protected void method_5652(@NotNull class_2487 cmp) {
		super.method_5652(cmp);
		cmp.method_10569(TAG_MANA, getMana());
	}

	@Override
	protected void method_5749(class_2487 cmp) {
		super.method_5749(cmp);
		setMana(cmp.method_10550(TAG_MANA));
	}

	@Override
	public class_1792 method_42670() {
		return BotaniaItems.poolMinecart;
	}

	@SoftImplement("IForgeMinecart")
	public int getComparatorLevel() {
		return ManaPoolBlockEntity.calculateComparatorLevel(getMana(), ManaPoolBlockEntity.MAX_MANA);
	}

	public int getMana() {
		return field_6011.method_12789(MANA);
	}

	public void setMana(int mana) {
		field_6011.method_12778(MANA, mana);
	}

}
