/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.flower.generating;

import I;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_5819;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.handler.BotaniaSounds;

public class ThermalilyBlockEntity extends FluidGeneratorBlockEntity {
	public static final int COOLDOWN_TICKS_MULTIPLER = 400;
	public static final String TAG_COOLDOWN_MAGNITUDE = "cooldownStrength";

	private int cooldownStrength = 15;
	public static final int[] COOLDOWN_ROLL_PDF = { 10, 5, 3, 2, 1, 1, 3, 3, 3, 2, 1, 1, 1, 2, 2 };
	public static final int COOLDOWN_ROLL_TOTAL;

	static {
		int acc = 0;
		for (var i : COOLDOWN_ROLL_PDF) {
			acc += i;
		}
		COOLDOWN_ROLL_TOTAL = acc;
	}

	public ThermalilyBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaFlowerBlocks.THERMALILY, pos, state, class_3486.field_15518, 600, 45);
	}

	@Override
	public int getCooldownTime(boolean finishedPrevious) {
		if (finishedPrevious) {
			cooldownStrength = rollNewCooldownStrength(method_10997().method_8409());
		}
		return COOLDOWN_TICKS_MULTIPLER * cooldownStrength;
	}

	public static int rollNewCooldownStrength(class_5819 random) {
		var total = random.method_43048(COOLDOWN_ROLL_TOTAL);
		var index = 0;
		while (total >= COOLDOWN_ROLL_PDF[index]) {
			total -= COOLDOWN_ROLL_PDF[index];
			index++;
		}
		return index + 1;
	}

	@Override
	public int getColor() {
		return 0xD03C00;
	}

	@Override
	public void doBurnParticles() {
		WispParticleData data = WispParticleData.wisp((float) Math.random() / 6, 0.7F, 0.05F, 0.05F, 1);
		emitParticle(data, 0.5 + Math.random() * 0.2 - 0.1, 0.9 + Math.random() * 0.2 - 0.1, 0.5 + Math.random() * 0.2 - 0.1, 0, (float) Math.random() / 60, 0);
	}

	@Override
	public void playSound() {
		method_10997().method_8396(null, getEffectivePos(), BotaniaSounds.thermalily, class_3419.field_15245, 1F, 1F);
	}

	@Override
	public int getComparatorSignal() {
		return burnTime > 0 ? 0 : cooldownStrength;
	}

	@Override
	public int getMaxMana() {
		return 750;
	}

	@Override
	public void writeToPacketNBT(class_2487 cmp) {
		super.writeToPacketNBT(cmp);

		cmp.method_10569(TAG_COOLDOWN_MAGNITUDE, cooldownStrength);
	}

	@Override
	public void readFromPacketNBT(class_2487 cmp) {
		super.readFromPacketNBT(cmp);

		cooldownStrength = cmp.method_10550(TAG_COOLDOWN_MAGNITUDE);
	}
}
