/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.dispenser;

import net.minecraft.class_1688;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2768;
import net.minecraft.class_3481;
import net.minecraft.class_6088;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.entity.ManaPoolMinecartEntity;

// [VanillaCopy] MinecartItem
public class ManaPoolMinecartBehavior extends class_2347 {
	private final class_2347 behaviourDefaultDispenseItem = new class_2347();

	@NotNull
	@Override
	public class_1799 method_10135(class_2342 source, class_1799 stack) {
		class_2350 direction = source.method_10120().method_11654(class_2315.field_10918);
		class_1937 world = source.method_10207();
		double x = source.method_10216() + (double) direction.method_10148() * 1.125;
		double y = Math.floor(source.method_10214()) + (double) direction.method_10164();
		double z = source.method_10215() + (double) direction.method_10165() * 1.125;
		class_2338 blockpos = source.method_10122().method_10093(direction);
		class_2680 blockState = world.method_8320(blockpos);
		class_2768 railShape = blockState.method_26204() instanceof class_2241
				? blockState.method_11654(((class_2241) blockState.method_26204()).method_9474())
				: class_2768.field_12665;
		double yOffset;
		if (blockState.method_26164(class_3481.field_15463)) {
			if (railShape.method_11897()) {
				yOffset = 0.6;
			} else {
				yOffset = 0.1;
			}
		} else {
			if (!blockState.method_26215() || !world.method_8320(blockpos.method_10074()).method_26164(class_3481.field_15463)) {
				return this.behaviourDefaultDispenseItem.dispense(source, stack);
			}

			class_2680 blockStateBelow = world.method_8320(blockpos.method_10074());
			class_2768 railShapeBelow = blockStateBelow.method_26204() instanceof class_2241
					? blockStateBelow.method_11654(((class_2241) blockStateBelow.method_26204()).method_9474())
					: class_2768.field_12665;
			if (direction != class_2350.field_11033 && railShapeBelow.method_11897()) {
				yOffset = -0.4;
			} else {
				yOffset = -0.9;
			}
		}

		// changed from vanilla, because it uses AbstractMinecart.Type enum to resolve the entity type
		class_1688 minecart = new ManaPoolMinecartEntity(world, x, y + yOffset, z);
		if (stack.method_7938()) {
			minecart.method_5665(stack.method_7964());
		}

		world.method_8649(minecart);
		stack.method_7934(1);
		return stack;
	}

	@Override
	protected void method_10136(class_2342 source) {
		source.method_10207().method_20290(class_6088.field_31140, source.method_10122(), 0);
	}

}
