/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.block_entity;

import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.api.state.enums.AlfheimPortalState;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaFlowerBlock;
import vazkii.botania.common.block.PylonBlock;
import vazkii.botania.common.block.mana.ManaPoolBlock;
import vazkii.botania.common.item.material.MysticalPetalItem;
import vazkii.botania.xplat.BotaniaConfig;

import java.util.Random;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public class PylonBlockEntity extends class_2586 {
	boolean activated = false;
	class_2338 centerPos;
	private int ticks = 0;

	public PylonBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaBlockEntities.PYLON, pos, state);
	}

	public static void commonTick(class_1937 level, class_2338 worldPosition, class_2680 state, PylonBlockEntity self) {
		++self.ticks;

		PylonBlock.Variant variant = ((PylonBlock) state.method_26204()).variant;

		if (self.activated && level.field_9236) {
			if (!level.method_8320(self.centerPos).method_27852(variant.getTargetBlock())
					|| variant == PylonBlock.Variant.NATURA && (self.portalOff() || !(level.method_8320(worldPosition.method_10074()).method_26204() instanceof ManaPoolBlock))) {
				self.activated = false;
				return;
			}

			class_243 centerBlock = new class_243(self.centerPos.method_10263() + 0.5, self.centerPos.method_10264() + 0.75 + (Math.random() - 0.5 * 0.25), self.centerPos.method_10260() + 0.5);

			if (variant == PylonBlock.Variant.NATURA) {
				if (BotaniaConfig.client().elfPortalParticlesEnabled()) {
					double worldTime = self.ticks;
					worldTime += new Random(worldPosition.hashCode()).nextInt(1000);
					worldTime /= 5;

					float r = 0.75F + (float) Math.random() * 0.05F;
					double x = worldPosition.method_10263() + 0.5 + Math.cos(worldTime) * r;
					double z = worldPosition.method_10260() + 0.5 + Math.sin(worldTime) * r;

					class_243 ourCoords = new class_243(x, worldPosition.method_10264() + 0.25, z);
					centerBlock = centerBlock.method_1023(0, 0.5, 0);
					class_243 movementVector = centerBlock.method_1020(ourCoords).method_1029().method_1021(0.2);

					WispParticleData data = WispParticleData.wisp(0.25F + (float) Math.random() * 0.1F, (float) Math.random() * 0.25F, 0.75F + (float) Math.random() * 0.25F, (float) Math.random() * 0.25F, 1);
					level.method_8406(data, x, worldPosition.method_10264() + 0.25, z, 0, -(-0.075F - (float) Math.random() * 0.015F), 0);
					if (level.field_9229.method_43048(3) == 0) {
						WispParticleData data1 = WispParticleData.wisp(0.25F + (float) Math.random() * 0.1F, (float) Math.random() * 0.25F, 0.75F + (float) Math.random() * 0.25F, (float) Math.random() * 0.25F);
						level.method_8406(data1, x, worldPosition.method_10264() + 0.25, z, (float) movementVector.field_1352, (float) movementVector.field_1351, (float) movementVector.field_1350);
					}
				}
			} else {
				class_243 ourCoords = class_243.method_24953(worldPosition).method_1031(0, 1 + (Math.random() - 0.5 * 0.25), 0);
				class_243 movementVector = centerBlock.method_1020(ourCoords).method_1029().method_1021(0.2);

				class_2248 block = level.method_8320(worldPosition.method_10074()).method_26204();
				if (block instanceof BotaniaFlowerBlock flower) {
					int hex = MysticalPetalItem.getPetalLikeColor(flower.color);
					int r = (hex & 0xFF0000) >> 16;
					int g = (hex & 0xFF00) >> 8;
					int b = hex & 0xFF;

					if (level.field_9229.method_43048(4) == 0) {
						SparkleParticleData data = SparkleParticleData.sparkle((float) Math.random(), r / 255F, g / 255F, b / 255F, 8);
						level.method_8406(data, centerBlock.field_1352 + (Math.random() - 0.5) * 0.5, centerBlock.field_1351, centerBlock.field_1350 + (Math.random() - 0.5) * 0.5, 0, 0, 0);
					}

					WispParticleData data1 = WispParticleData.wisp((float) Math.random() / 3F, r / 255F, g / 255F, b / 255F, 1);
					level.method_8406(data1, worldPosition.method_10263() + 0.5 + (Math.random() - 0.5) * 0.25, worldPosition.method_10264() - 0.5, worldPosition.method_10260() + 0.5 + (Math.random() - 0.5) * 0.25, 0, - -0.04F, 0);
					WispParticleData data = WispParticleData.wisp((float) Math.random() / 5F, r / 255F, g / 255F, b / 255F, 1);
					level.method_8406(data, worldPosition.method_10263() + 0.5 + (Math.random() - 0.5) * 0.125, worldPosition.method_10264() + 1.5, worldPosition.method_10260() + 0.5 + (Math.random() - 0.5) * 0.125, 0, - -0.001F, 0);
					WispParticleData data2 = WispParticleData.wisp((float) Math.random() / 8F, r / 255F, g / 255F, b / 255F);
					level.method_8406(data2, worldPosition.method_10263() + 0.5 + (Math.random() - 0.5) * 0.25, worldPosition.method_10264() + 1.5, worldPosition.method_10260() + 0.5 + (Math.random() - 0.5) * 0.25, (float) movementVector.field_1352, (float) movementVector.field_1351, (float) movementVector.field_1350);
				}
			}
		}

		if (level.field_9229.method_43056() && level.field_9236) {
			SparkleParticleData data = SparkleParticleData.sparkle((float) Math.random(), variant.r, variant.g, variant.b, 2);
			level.method_8406(data, worldPosition.method_10263() + Math.random(), worldPosition.method_10264() + Math.random() * 1.5, worldPosition.method_10260() + Math.random(), 0, 0, 0);
		}
	}

	private boolean portalOff() {
		return !field_11863.method_8320(centerPos).method_27852(BotaniaBlocks.alfPortal)
				|| field_11863.method_8320(centerPos).method_11654(BotaniaStateProperties.ALFPORTAL_STATE) == AlfheimPortalState.OFF;
	}

}
