package vazkii.botania.client.integration.emi;

import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.recipe.BotanicalBreweryRecipe;

import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class BotanicalBreweryEmiRecipe extends BotaniaEmiRecipe {
	private static final class_2960 TEXTURE = prefix("textures/gui/nei_brewery.png");
	private final List<EmiIngredient> ingredients;
	private final class_2960 id;

	public BotanicalBreweryEmiRecipe(BotanicalBreweryRecipe recipe, class_1799 container) {
		super(BotaniaEmiPlugin.BOTANICAL_BREWERY, recipe);
		this.ingredients = recipe.method_8117().stream().map(EmiIngredient::of).toList();
		this.input = Stream.concat(Stream.of(EmiStack.of(container)), ingredients.stream()).toList();
		this.output = List.of(EmiStack.of(recipe.getOutput(container.method_7972())));
		class_2960 id = recipe.method_8114();
		class_2960 itemId = class_7923.field_41178.method_10221(container.method_7909());
		this.id = new class_2960("emi", "botania/botanical_brewery/"
				+ id.method_12836() + "/" + id.method_12832() + "/"
				+ itemId.method_12836() + "/" + itemId.method_12832());
	}

	@Override
	public @Nullable class_2960 getId() {
		return id;
	}

	@Override
	public int getDisplayHeight() {
		return 65;
	}

	@Override
	public int getDisplayWidth() {
		return 120;
	}

	@Override
	public void addWidgets(WidgetHolder widgets) {
		widgets.add(new BlendTextureWidget(TEXTURE, 0, 0, 86, 55, 28, 6));
		widgets.addSlot(input.get(output.size() - 1), 10, 35);
		int sx = 58 - (ingredients.size() - 1) * 9;
		for (EmiIngredient stack : ingredients) {
			widgets.addSlot(stack, sx, 1).drawBack(false);
			sx += 18;
		}
		widgets.addSlot(output.get(0), 58, 35).recipeContext(this);
	}
}
