/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.block_entity;

import net.minecraft.class_2338;
import net.minecraft.class_238;

/**
 * This object describes the Radius of a BlockEntity. It can either be
 * a circle or rectangle.
 */
public sealed interface RadiusDescriptor permits RadiusDescriptor.Circle,RadiusDescriptor.Rectangle {
	record Circle(class_2338 subtileCoords, double radius) implements RadiusDescriptor {
	}

	record Rectangle(class_2338 subtileCoords, class_238 aabb) implements RadiusDescriptor {
		public static Rectangle square(class_2338 subtileCoords, int expand) {
			return new Rectangle(subtileCoords, new class_238(subtileCoords.method_10069(-expand, 0, -expand), subtileCoords.method_10069(expand + 1, 0, expand + 1)));
		}
	}
}
