/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.world;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_265;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_746;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.CoordBoundItem;
import vazkii.botania.api.item.WireframeCoordinateListProvider;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.mixin.client.LevelRendererAccessor;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.XplatAbstractions;

public final class BoundBlockRenderer {
    private static final class_4597.class_4598 LINE_BUFFERS = class_4597.method_22992((Map)((Map)class_156.method_656(() -> {
        IdentityHashMap<class_1921, class_287> ret = new IdentityHashMap<class_1921, class_287>();
        ret.put(RenderHelper.LINE_1_NO_DEPTH, new class_287(RenderHelper.LINE_1_NO_DEPTH.method_22722()));
        ret.put(RenderHelper.LINE_4_NO_DEPTH, new class_287(RenderHelper.LINE_4_NO_DEPTH.method_22722()));
        ret.put(RenderHelper.LINE_5_NO_DEPTH, new class_287(RenderHelper.LINE_5_NO_DEPTH.method_22722()));
        ret.put(RenderHelper.LINE_8_NO_DEPTH, new class_287(RenderHelper.LINE_8_NO_DEPTH.method_22722()));
        return ret;
    })), (class_287)class_289.method_1348().method_1349());

    private BoundBlockRenderer() {
    }

    public static void onWorldRenderLast(class_4184 camera, class_4587 ms, class_1937 level) {
        class_2338 coords;
        CoordBoundItem coordBoundItem;
        class_746 player = class_310.method_1551().field_1724;
        if (!BotaniaConfig.client().boundBlockWireframe() || player == null || player.method_37908() != level) {
            return;
        }
        ms.method_22903();
        int color = 0xFF000000 | class_3532.method_15369((float)((float)(ClientTickHandler.ticksInGame % 200) / 200.0f), (float)0.6f, (float)1.0f);
        if (!player.method_6047().method_7960() && (coordBoundItem = XplatAbstractions.INSTANCE.findCoordBoundItem(player.method_6047())) != null && (coords = coordBoundItem.getBinding(player.method_37908())) != null) {
            BoundBlockRenderer.renderBlockOutlineAt(camera, ms, (class_4597)LINE_BUFFERS, player.method_37908(), coords, color);
        }
        if (!player.method_6079().method_7960() && (coordBoundItem = XplatAbstractions.INSTANCE.findCoordBoundItem(player.method_6079())) != null && (coords = coordBoundItem.getBinding(player.method_37908())) != null) {
            BoundBlockRenderer.renderBlockOutlineAt(camera, ms, (class_4597)LINE_BUFFERS, player.method_37908(), coords, color);
        }
        BoundBlockRenderer.renderWireframeProviders(camera, (class_1263)player.method_31548(), (class_1657)player, ms, color);
        BoundBlockRenderer.renderWireframeProviders(camera, BotaniaAPI.instance().getAccessoriesInventory((class_1657)player), (class_1657)player, ms, color);
        ms.method_22909();
        RenderSystem.disableDepthTest();
        LINE_BUFFERS.method_22993();
    }

    private static void renderWireframeProviders(class_4184 camera, class_1263 inv, class_1657 player, class_4587 ms, int color) {
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1792 class_17922;
            class_1799 stackInSlot = inv.method_5438(i);
            if (stackInSlot.method_7960() || !((class_17922 = stackInSlot.method_7909()) instanceof WireframeCoordinateListProvider)) continue;
            WireframeCoordinateListProvider provider = (WireframeCoordinateListProvider)class_17922;
            List<class_2338> coordsList = provider.getWireframesToDraw(player, stackInSlot);
            for (class_2338 coords : coordsList) {
                BoundBlockRenderer.renderBlockOutlineAt(camera, ms, (class_4597)LINE_BUFFERS, player.method_37908(), coords, color);
            }
            class_2338 coords = provider.getSourceWireframe(player, stackInSlot);
            if (coords == null || coords.method_10264() == Integer.MIN_VALUE) continue;
            BoundBlockRenderer.renderBlockOutlineAt(camera, ms, (class_4597)LINE_BUFFERS, player.method_37908(), coords, color, true);
        }
    }

    private static void renderBlockOutlineAt(class_4184 camera, class_4587 ms, class_4597 buffers, class_1937 level, class_2338 pos, int color) {
        BoundBlockRenderer.renderBlockOutlineAt(camera, ms, buffers, level, pos, color, false);
    }

    private static void renderBlockOutlineAt(class_4184 camera, class_4587 ms, class_4597 buffers, class_1937 level, class_2338 pos, int color, boolean thick) {
        class_265 shape = level.method_8320(pos).method_26218((class_1922)level, pos);
        if (!shape.method_1110()) {
            double renderPosX = camera.method_19326().method_10216();
            double renderPosY = camera.method_19326().method_10214();
            double renderPosZ = camera.method_19326().method_10215();
            ms.method_22903();
            ms.method_22904((double)pos.method_10263() - renderPosX, (double)pos.method_10264() - renderPosY, (double)pos.method_10260() - renderPosZ);
            class_4588 buffer = buffers.getBuffer(thick ? RenderHelper.LINE_5_NO_DEPTH : RenderHelper.LINE_1_NO_DEPTH);
            BoundBlockRenderer.renderBlockOutline(ms, buffer, shape, color);
            buffer = buffers.getBuffer(thick ? RenderHelper.LINE_8_NO_DEPTH : RenderHelper.LINE_4_NO_DEPTH);
            int alpha = 64;
            color = color & 0xFFFFFF | alpha << 24;
            BoundBlockRenderer.renderBlockOutline(ms, buffer, shape, color);
            ms.method_22909();
        }
    }

    private static void renderBlockOutline(class_4587 pose, class_4588 buffer, class_265 shape, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        LevelRendererAccessor.renderShape(pose, buffer, shape, 0.0, 0.0, 0.0, r, g, b, a);
    }
}

