package vazkii.botania.test.block;

import java.util.List;
import net.minecraft.class_1533;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2472;
import net.minecraft.class_4516;
import net.minecraft.class_5544;
import net.minecraft.class_6302;
import vazkii.botania.common.block.flower.functional.RannuncarpusBlockEntity;
import vazkii.botania.common.helper.DelayHelper;
import vazkii.botania.test.TestingUtil;

public class RannuncarpusTest {
	private static final String TEMPLATE = "botania:block/rannuncarpus";
	private static final String TEMPLATE_CANDLES = "botania:block/rannuncarpus_candles";

	private static final class_2338 FLOWER_POS = new class_2338(2, 3, 2);
	private static final class_2338 FILTER_POS = FLOWER_POS.method_10074();

	private static final class_2338 EXPECTED_PLACE_POS = new class_2338(3, 2, 2);
	private static final class_2338 FILTERED_POS = EXPECTED_PLACE_POS.method_10074();

	private static final class_2338 MAGENTA_CANDLE_POS = new class_2338(3, 3, 3);
	private static final class_2338 EXPECTED_PLACE_POS1 = new class_2338(1, 3, 3);
	private static final class_2338 EXPECTED_PLACE_POS2 = new class_2338(3, 3, 1);
	private static final class_2338 SEA_PICKLE_POS = new class_2338(1, 2, 1);
	private static final class_2338 FLOATING_YELLOW_CANDLE_POS = new class_2338(1, 5, 2);

	@class_6302(method_35936 = TEMPLATE, method_35933 = "rannuncarpus1")
	public void testDestinationFilterPositive(class_4516 helper) {
		helper.method_36041().method_36085(() -> {
			helper.method_36001();
			helper.method_35968(class_2246.field_10340.method_8389(), FLOWER_POS.method_10263(), FLOWER_POS.method_10264() + 1, FLOWER_POS.method_10260());
		}).method_36079(() -> {
			helper.method_35972(class_2246.field_10340, EXPECTED_PLACE_POS);
		}).method_36075();
	}

	@class_6302(method_35936 = TEMPLATE, method_35933 = "rannuncarpus2")
	public void testDestinationFilterNegative(class_4516 helper) {
		helper.method_36041().method_36085(() -> {
			helper.method_36001();
			helper.method_35984(FILTERED_POS, class_2246.field_10093);
			helper.method_35968(class_2246.field_10340.method_8389(), FLOWER_POS.method_10263(), FLOWER_POS.method_10264() + 1, FLOWER_POS.method_10260());
		}).method_36084(DelayHelper.FUNCTIONAL_INHERENT_DELAY + 1, () -> {
			helper.method_36012(class_2246.field_10340, EXPECTED_PLACE_POS);
		}).method_36075();
	}

	@class_6302(method_35936 = TEMPLATE)
	public void testPickupFilterPositive(class_4516 helper) {
		helper.method_36041().method_36085(() -> {
			var frame = getItemFrame(helper);
			frame.method_6935(new class_1799(class_2246.field_10340));
			helper.method_35968(class_2246.field_10340.method_8389(), FLOWER_POS.method_10263(), FLOWER_POS.method_10264() + 1, FLOWER_POS.method_10260());
		}).method_36079(() -> {
			helper.method_35972(class_2246.field_10340, EXPECTED_PLACE_POS);
		}).method_36075();
	}

	@class_6302(method_35936 = TEMPLATE)
	public void testPickupFilterNegative(class_4516 helper) {
		helper.method_36041().method_36085(() -> {
			var frame = getItemFrame(helper);
			frame.method_6935(new class_1799(class_2246.field_10445));
			helper.method_35968(class_2246.field_10340.method_8389(), FLOWER_POS.method_10263(), FLOWER_POS.method_10264() + 1, FLOWER_POS.method_10260());
		}).method_36084(DelayHelper.FUNCTIONAL_INHERENT_DELAY + 1, () -> {
			helper.method_36012(class_2246.field_10340, EXPECTED_PLACE_POS);
		}).method_36075();
	}

	private static final int MULTI_PLACEMENT_TIMEOUT_TICKS =
			// 10 blocks to place, 1 interval where nothing should be placed, 1 interval leeway
			(10 + 1 + 1) * RannuncarpusBlockEntity.PLACE_INTERVAL_TICKS
					// new items are supplied twice during the test
					+ 2 * DelayHelper.FUNCTIONAL_INHERENT_DELAY;

	@class_6302(method_35936 = TEMPLATE_CANDLES, method_35932 = MULTI_PLACEMENT_TIMEOUT_TICKS, method_35933 = "rannuncarpus3")
	public void testMultiplePlacements(class_4516 helper) {
		final var yellowCandles = helper.method_35968(class_2246.field_27104.method_8389(), FLOWER_POS.method_10263(), FLOWER_POS.method_10264() + 1, FLOWER_POS.method_10260());
		helper.method_36041().method_36085(() -> {
			// phase 1: fill all free spots with yellow candles
			final var stack = yellowCandles.method_6983();
			stack.method_7939(10); // should have candles left over when done
			yellowCandles.method_6979(stack);
		}).method_36079(() -> {
			// should place 2x 4 candles in the free spaces, even though one of them is occupied by grass
			helper.method_35972(class_2246.field_27104, EXPECTED_PLACE_POS1);
			helper.method_35972(class_2246.field_27104, EXPECTED_PLACE_POS2);
			helper.method_35987(EXPECTED_PLACE_POS1, class_5544.field_27174, 4);
			helper.method_35987(EXPECTED_PLACE_POS2, class_5544.field_27174, 4);
		}).method_36077(RannuncarpusBlockEntity.PLACE_INTERVAL_TICKS + 1, () -> {
			// once both spots are filled, no other yellow candles should have been place anywhere else
			helper.method_35987(FLOATING_YELLOW_CANDLE_POS, class_5544.field_27174, 1);
			if (yellowCandles.method_6983().method_7947() < 2) {
				helper.method_35996("Too few yellow candles left over", yellowCandles);
			}
			helper.method_36001();
		}).method_36085(() -> {
			// phase 2: ensure various other properties are kept when adding
			helper.method_35968(class_2246.field_27102.method_8389(), FLOWER_POS.method_10263(), FLOWER_POS.method_10264() + 1, FLOWER_POS.method_10260());
			helper.method_35968(class_2246.field_10476.method_8389(), FLOWER_POS.method_10263(), FLOWER_POS.method_10264() + 1, FLOWER_POS.method_10260());
		}).method_36079(() -> {
			helper.method_35987(MAGENTA_CANDLE_POS, class_5544.field_27174, 2);
			helper.method_35987(SEA_PICKLE_POS, class_2472.field_11472, 2);
		}).method_36085(() -> {
			helper.method_35987(MAGENTA_CANDLE_POS, class_5544.field_27175, true);
			helper.method_35987(SEA_PICKLE_POS, class_2472.field_11475, true);
		}).method_36075();
	}

	@class_6302(method_35936 = TEMPLATE, method_35932 = DelayHelper.FUNCTIONAL_INHERENT_DELAY + 13 * RannuncarpusBlockEntity.PLACE_INTERVAL_TICKS)
	public void testMultiplePlacementsPrefersEmptySpots(class_4516 helper) {
		// have the flower place across the entire platform
		helper.method_35984(FILTER_POS, class_2246.field_10093);
		helper.method_35984(FILTERED_POS, class_2246.field_10093);

		// prefill half the spaces
		for (class_2338 pos : class_2338.method_10094(0, 2, 0, 4, 2, 4)) {
			if (((pos.method_10263() + pos.method_10260()) % 2) == 1) {
				helper.method_35984(pos, class_2246.field_10476);
			}
		}

		// provide exactly enough items to fill the other half
		final var seaPickles = helper.method_35968(class_2246.field_10476.method_8389(), FLOWER_POS.method_10263(), FLOWER_POS.method_10264() + 1, FLOWER_POS.method_10260());
		final var stack = seaPickles.method_6983();
		stack.method_7939(12);
		seaPickles.method_6979(stack);

		helper.method_36041().method_36077(DelayHelper.FUNCTIONAL_INHERENT_DELAY + 12 * RannuncarpusBlockEntity.PLACE_INTERVAL_TICKS + 1, () -> {
			// ensure every block has exactly one sea pickle
			for (class_2338 pos : class_2338.method_10094(1, 2, 1, 4, 2, 4)) {
				if (pos.equals(FILTER_POS)) {
					continue;
				}
				helper.method_35972(class_2246.field_10476, pos);
				helper.method_35987(pos, class_2472.field_11472, 1);
			}
			if (!stack.method_7960()) {
				helper.method_35996("Not all items used", seaPickles);
			}
		}).method_36075();
	}

	private static class_1533 getItemFrame(class_4516 helper) {
		var bounds = new class_238(helper.method_36052(FLOWER_POS));
		var list = helper.method_35943().method_18467(class_1533.class, bounds);
		TestingUtil.assertThat(list.size() == 1, () -> "Number of item frames wasn't 1");
		return list.get(0);
	}
}
